/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.core;

import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.Dependency;
import tigase.kernel.core.Kernel;

public class PlantUMLGrapher {
    private Kernel kernel;

    private static String n(BeanConfig beanConfig) {
        Kernel bk = beanConfig.getKernel();
        String kernelName = bk.getName();
        String beanName = beanConfig.getBeanName();
        return (kernelName + "." + beanName).replace("#", "_").replace("<", "_").replace(">", "_");
    }

    public PlantUMLGrapher() {
    }

    public PlantUMLGrapher(Kernel krnl) {
        this.setKernel(krnl);
    }

    public String getDependencyGraph() {
        StringBuilder sb = new StringBuilder();
        sb.append("@startuml").append('\n');
        sb.append((CharSequence)this.makePackage(this.kernel));
        sb.append("@enduml").append('\n');
        return sb.toString();
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    private StringBuilder makeObject(BeanConfig bc) {
        StringBuilder sb = new StringBuilder();
        sb.append("object ").append("\"").append(bc.getBeanName()).append("\" as ").append(PlantUMLGrapher.n(bc));
        sb.append("{\n");
        for (Dependency d : bc.getFieldDependencies().values()) {
            sb.append(d.getField().getName());
            sb.append('\n');
        }
        sb.append("}");
        sb.append('\n');
        return sb;
    }

    private StringBuilder makePackage(Kernel k) {
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(k.getName()).append(" {\n");
        for (BeanConfig bc : k.getDependencyManager().getBeanConfigs()) {
            Object sk;
            if (Kernel.class.isAssignableFrom(bc.getClazz()) && (sk = (Kernel)k.getInstance(bc)) != k) {
                sb.append((CharSequence)this.makePackage((Kernel)sk));
            }
            sb.append((CharSequence)this.makeObject(bc));
            sk = bc.getFieldDependencies().values().iterator();
            while (sk.hasNext()) {
                BeanConfig[] dBeans;
                Dependency dp = (Dependency)sk.next();
                for (BeanConfig dBean : dBeans = k.getDependencyManager().getBeanConfig(dp)) {
                    if (dBean == null) continue;
                    sb.append(PlantUMLGrapher.n(dBean)).append(" *- ").append(PlantUMLGrapher.n(bc)).append('\n');
                }
            }
            if (!(bc instanceof Kernel.DelegatedBeanConfig)) continue;
            BeanConfig orginal = ((Kernel.DelegatedBeanConfig)bc).getOriginal();
            sb.append(PlantUMLGrapher.n(orginal)).append(" .. ").append(PlantUMLGrapher.n(bc)).append('\n');
        }
        sb.append("}\n");
        return sb;
    }
}

