/*
 * Decompiled with CFR 0.152.
 */
package tigase.io.repo;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.comp.UserRepoRepository;
import tigase.io.CertificateContainer;
import tigase.io.repo.CertificateItem;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.jid.BareJID;

@Bean(name="repository", parent=CertificateContainer.class, active=false)
public class CertificateRepository
extends UserRepoRepository<CertificateItem> {
    private static final Logger log = Logger.getLogger(CertificateRepository.class.getName());
    private static final String CONFIG_KEY = "vhost-certificates";
    private static final BareJID REPO_USER_JID = BareJID.bareJIDInstanceNS((String)"certificate-manager");
    @ConfigField(desc="Automatically migrate certificates from filesystem to repository (and make backup)", alias="move-from-filesystem-to-repository")
    protected boolean moveFromFilesystemToRepository = true;

    public CertificateRepository() {
        this.autoReloadInterval = TimeUnit.HOURS.toSeconds(1L);
    }

    @Override
    public void addItem(CertificateItem item) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Adding item: {0}", item);
        }
        this.addItemNoStore(item);
        if (this.repo != null && this.isInitialized()) {
            this.storeSingleItem(item);
        }
    }

    @Override
    public boolean itemChanged(CertificateItem oldItem, CertificateItem newItem) {
        return oldItem.getFingerprint().isPresent() && newItem.getFingerprint().isPresent() && oldItem.getFingerprint().get().equals(newItem.getFingerprint().get());
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getConfigKey() {
        return CONFIG_KEY;
    }

    @Override
    public CertificateItem getItemInstance() {
        return new CertificateItem();
    }

    @Override
    public String getPropertyKey() {
        return "--vhost-certificates";
    }

    @Override
    public BareJID getRepoUser() {
        return REPO_USER_JID;
    }

    public boolean isMoveFromFilesystemToRepository() {
        return this.moveFromFilesystemToRepository;
    }

    @Override
    public void reload() {
        int hashCode = 0;
        try {
            if (this.repo == null) {
                log.log(Level.SEVERE, "Repository is not initialised - skipping reload");
                return;
            }
            Map<String, String> itemsMap = this.repo.getDataMap(this.getRepoUser(), this.getItemsListPKey());
            if (itemsMap != null && (hashCode = itemsMap.hashCode()) != this.itemsHash) {
                HashSet oldKeys = new HashSet(this.items.keySet());
                itemsMap.forEach((? super K key, ? super V value) -> this.parseElement((String)value).ifPresentOrElse(item -> {
                    this.addItemNoStore(item);
                    oldKeys.remove(item.getKey());
                }, () -> oldKeys.remove(key)));
                log.log(Level.CONFIG, "All loaded items: {0}", this.items);
                this.itemsHash = hashCode;
                oldKeys.forEach(this::removeItemNoStore);
            }
        }
        catch (TigaseDBException ex) {
            log.log(Level.SEVERE, "Problem with loading items list from the database.", ex);
        }
    }

    @Override
    public void removeItem(String key) {
        super.removeItem(key);
        if (this.repo != null && this.isInitialized()) {
            try {
                this.repo.removeData(this.getRepoUser(), this.getItemsListPKey(), key);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error removing item from the repository", e);
            }
        }
    }

    @Override
    public void store() {
        if (this.repo != null && this.isInitialized()) {
            for (CertificateItem item : this.items.values()) {
                this.storeSingleItem(item);
            }
        }
    }

    private Optional<CertificateItem> parseElement(String element) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        SimpleParser parser = SingletonFactory.getParserInstance();
        parser.parse((SimpleHandler)domHandler, element);
        Queue parsedElements = domHandler.getParsedElements();
        if (!parsedElements.isEmpty() && parsedElements.peek() != null) {
            CertificateItem item = this.getItemInstance();
            item.initFromElement((Element)parsedElements.peek());
            return Optional.of(item);
        }
        log.log(Level.WARNING, "Parsing certificate from element failed: " + element);
        return Optional.empty();
    }

    protected void storeSingleItem(CertificateItem item) {
        try {
            this.repo.setData(this.getRepoUser(), this.getItemsListPKey(), item.getKey(), item.toElement().toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error storing item in the repository", e);
        }
    }
}

