/*
 * Decompiled with CFR 0.152.
 */
package tigase.examples;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataRepository;
import tigase.db.DataSourceAware;
import tigase.db.Repository;
import tigase.db.TigaseDBException;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
public class ExampleUsingDataRepository
implements DataSourceAware<DataRepository> {
    private static final System.Logger log = System.getLogger(ExampleUsingDataRepository.class.getName());
    private static final String GET_DATA = "SELECT field FROM my_custom_table WHERE user_id = ?";
    private DataRepository data_repo = null;

    @Override
    public void setDataSource(DataRepository dataSource) throws RepositoryException {
        this.data_repo = dataSource;
        try {
            this.data_repo.initPreparedStatement("GET_DATA", GET_DATA);
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Failed to init prepared statement: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDataFromRepo(String userID) throws TigaseDBException {
        try {
            PreparedStatement getDataQuery = this.data_repo.getPreparedStatement(null, GET_DATA);
            getDataQuery.setString(1, userID);
            ResultSet rs = null;
            PreparedStatement preparedStatement = getDataQuery;
            synchronized (preparedStatement) {
                try {
                    rs = getDataQuery.executeQuery();
                    if (rs.next()) {
                        log.log(System.Logger.Level.INFO, "User data: " + rs.getString(1));
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
        }
        catch (SQLException e) {
            throw new TigaseDBException("Failed to get prepared statement: " + e.getMessage());
        }
    }
}

