/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util.locker;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.logging.Level;
import tigase.db.util.locker.ConnectionLock;

class MssqlConnectionLock
extends ConnectionLock {
    public MssqlConnectionLock(String db_conn) {
        super(db_conn);
    }

    @Override
    protected boolean lockDatabase(Connection connection) {
        String query = "{ ? = call dbo.sp_getapplock(?, ?, ?, ?) }";
        return this.executeProcedure(connection, query, statement -> {
            try {
                statement.setString(2, this.lockName);
                statement.setString(3, "Exclusive");
                statement.setString(4, "Session");
                statement.setInt(5, 1000);
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Failed to set statement parameters", e);
            }
        });
    }

    @Override
    protected boolean unlockDatabase(Connection connection) {
        String query = "{ ? = call dbo.sp_releaseapplock(?, ?) }";
        return this.executeProcedure(connection, query, statement -> {
            try {
                statement.setString(2, this.lockName);
                statement.setString(3, "Session");
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Failed to set statement parameters", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean executeProcedure(Connection connection, String query, Consumer<CallableStatement> consumer) {
        boolean isLocked = false;
        CallableStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareCall(query);
            statement.registerOutParameter(1, 4);
            consumer.accept(statement);
            statement.execute();
            int returnCode = statement.getInt(1);
            log.log(Level.FINEST, "Stored procedure return code: " + returnCode);
            switch (returnCode) {
                case 0: 
                case 1: {
                    isLocked = true;
                    return isLocked;
                }
                default: {
                    isLocked = false;
                    return isLocked;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
            return isLocked;
        }
        finally {
            this.release(statement, resultSet);
        }
    }
}

