/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util.importexport;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.component.exceptions.RepositoryException;
import tigase.conf.ConfigHolder;
import tigase.conf.ConfigReader;
import tigase.db.UserRepository;
import tigase.db.comp.ConfigRepository;
import tigase.db.util.SchemaManager;
import tigase.db.util.importexport.DataSourceHelper;
import tigase.db.util.importexport.Exporter;
import tigase.db.util.importexport.Importer;
import tigase.db.util.importexport.RepositoryHolder;
import tigase.db.util.importexport.RepositoryManagerExtension;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.Kernel;
import tigase.util.ClassUtil;
import tigase.util.ui.console.CommandlineParameter;
import tigase.util.ui.console.ParameterParser;
import tigase.util.ui.console.Task;
import tigase.vhosts.VHostItemDefaults;
import tigase.vhosts.VHostItemExtensionManager;
import tigase.vhosts.VHostJDBCRepository;

public class RepositoryManager {
    private static final Logger log = Logger.getLogger(RepositoryManager.class.getSimpleName());
    private final CommandlineParameter EXPORT_TO = new CommandlineParameter.Builder(null, "to").description("Path to export data to").required(true).build();
    private final CommandlineParameter IMPORT_FROM = new CommandlineParameter.Builder(null, "from").description("Path to import data from").required(true).build();
    private final CommandlineParameter TDSL_CONFIG_FILE = new CommandlineParameter.Builder(null, "config-file").description("Path to Tigase XMPP Server config file").defaultValue(ConfigHolder.TDSL_CONFIG_FILE_DEF).required(false).build();
    private final CommandlineParameter DEBUG = new CommandlineParameter.Builder(null, "debug").description("Enable verbose logging").defaultValue("false").required(false).requireArguments(false).build();
    private static final String LOGGING_CONFIG = "handlers = java.util.logging.ConsoleHandler\n.level = ALL\njava.util.logging.ConsoleHandler.formatter = tigase.util.log.LogFormatter\n";
    private Path rootPath;
    private Map<String, Object> config;
    private Kernel kernel;
    private DataSourceHelper dataSourceHelper;
    private RepositoryHolder repositoryHolder;
    private List<RepositoryManagerExtension> extensions = new ArrayList<RepositoryManagerExtension>();
    private VHostJDBCRepository vhostRepository;

    public static boolean isSet(CommandlineParameter parameter) throws Exception {
        String value = (String)parameter.getValue().or(() -> ((CommandlineParameter)parameter).getDefaultValue()).orElseThrow();
        return Boolean.parseBoolean(value);
    }

    public void execute(String[] args) throws Exception {
        Properties props;
        ParameterParser parser;
        String scriptName;
        block5: {
            RepositoryManager.configureLogging(Level.SEVERE);
            scriptName = System.getProperty("scriptName");
            parser = new ParameterParser(true);
            this.extensions = ClassUtil.getClassesImplementing(RepositoryManagerExtension.class).stream().map(clazz -> {
                try {
                    return (RepositoryManagerExtension)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable ex) {
                    log.log(Level.WARNING, ex.getMessage(), ex);
                    return null;
                }
            }).filter(Objects::nonNull).toList();
            parser.setTasks(new Task[]{new Task.Builder().name("export-data").description("Export data to XML").additionalParameterSupplier(() -> Stream.concat(Stream.of(this.TDSL_CONFIG_FILE, this.EXPORT_TO, this.DEBUG), this.extensions.stream().flatMap(RepositoryManagerExtension::getExportParameters)).toList()).function(this::exportData).build(), new Task.Builder().name("import-data").description("Import data from XML").additionalParameterSupplier(() -> Stream.concat(Stream.of(this.TDSL_CONFIG_FILE, this.IMPORT_FROM, this.DEBUG), this.extensions.stream().flatMap(RepositoryManagerExtension::getImportParameters)).toList()).function(this::importData).build()});
            props = null;
            try {
                props = parser.parseArgs(args);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                if (!log.isLoggable(Level.FINEST)) break block5;
                log.log(Level.FINEST, ex.getMessage(), ex);
            }
        }
        Optional task = parser.getTask();
        if (props != null && task.isPresent()) {
            ((Task)task.get()).execute(props);
        } else {
            String executionCommand = null;
            if (scriptName != null) {
                executionCommand = "$ " + scriptName + " [task] [params-file.conf] [options]\n\t\tif the option defines default then <value> is optional";
            }
            System.out.println(parser.getHelp(executionCommand));
        }
    }

    public static void configureLogging(Level level) throws IOException {
        String config = "handlers = java.util.logging.ConsoleHandler\n.level = ALL\ntigase.xml.level = SEVERE\njava.util.logging.ConsoleHandler.level =" + level.getName() + "\njava.util.logging.ConsoleHandler.formatter = tigase.util.log.LogFormatter";
        byte[] data = config.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            LogManager.getLogManager().reset();
            LogManager.getLogManager().updateConfiguration(in, k -> k.endsWith(".handlers") ? (o, n) -> o == null ? n : o : (o, n) -> n);
        }
    }

    private void initialize(CommandlineParameter fileParam, Properties properties) throws ConfigReader.ConfigException, IOException, ClassNotFoundException, RepositoryException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        this.rootPath = Paths.get(properties.getProperty((String)fileParam.getFullName().get()), new String[0]);
        ConfigHolder holder = new ConfigHolder();
        holder.loadConfiguration(new String[]{"--config-file", (String)this.TDSL_CONFIG_FILE.getValue().orElseThrow()});
        this.config = holder.getProperties();
        this.config.remove("cluster-mode");
        this.kernel = SchemaManager.prepareKernel(this.config);
        List<BeanConfig> repoBeans = SchemaManager.getRepositoryBeans(this.kernel, SchemaManager.getRepositoryClasses(), this.config);
        List<SchemaManager.RepoInfo> repositories = SchemaManager.getRepositories(this.kernel, repoBeans, this.config);
        Map userRepoMap = repositories.stream().filter(repoInfo -> UserRepository.class.isAssignableFrom(repoInfo.getImplementation())).collect(Collectors.toMap(repoInfo -> repoInfo.getDataSource().getName(), Function.identity()));
        this.dataSourceHelper = new DataSourceHelper(repositories.stream().map(SchemaManager.RepoInfo::getDataSource).distinct().toList());
        this.repositoryHolder = new RepositoryHolder(this.dataSourceHelper, repositories);
        this.vhostRepository = new VHostJDBCRepository();
        this.vhostRepository.setRepo(this.repositoryHolder.getDefaultRepository(UserRepository.class));
        this.vhostRepository.setMainVHostName((String)this.config.get("default-virtual-host"));
        this.vhostRepository.setExtensionManager(new VHostItemExtensionManager());
        this.vhostRepository.setVhostDefaultValues(new VHostItemDefaults());
        this.vhostRepository.reload();
        Field f = ConfigRepository.class.getDeclaredField("initialized");
        f.setAccessible(true);
        f.set(this.vhostRepository, true);
        for (RepositoryManagerExtension extension : this.extensions) {
            extension.initialize(this.kernel, this.dataSourceHelper, this.repositoryHolder, this.rootPath);
        }
        Level level = Boolean.parseBoolean((String)this.DEBUG.getValue().orElseThrow()) ? Level.FINEST : Level.INFO;
        RepositoryManager.configureLogging(level);
        log.finest("extensions: " + String.valueOf(this.extensions));
    }

    private void importData(Properties properties) throws Exception {
        this.initialize(this.IMPORT_FROM, properties);
        if (!Files.exists(this.rootPath, new LinkOption[0])) {
            throw new RuntimeException("Source directory does not exist");
        }
        Importer importer = new Importer(this.repositoryHolder, this.vhostRepository, this.extensions, this.rootPath);
        importer.process(this.rootPath.resolve("server-data.xml"));
    }

    private void exportData(Properties properties) throws Exception {
        this.initialize(this.EXPORT_TO, properties);
        if (!Files.exists(this.rootPath, new LinkOption[0])) {
            Files.createDirectories(this.rootPath, new FileAttribute[0]);
        }
        Exporter exporter = new Exporter(this.repositoryHolder, this.vhostRepository, this.extensions, this.rootPath);
        exporter.export("server-data.xml");
    }

    public static void main(String[] args) throws IOException, ConfigReader.ConfigException {
        try {
            RepositoryManager repositoryManager = new RepositoryManager();
            repositoryManager.execute(args);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error while executing task", ex);
        }
        finally {
            System.exit(0);
        }
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<X> {
        public void accept(X var1) throws Exception;
    }
}

