/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util.importexport;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import tigase.component.exceptions.RepositoryException;
import tigase.db.util.SchemaManager;
import tigase.db.util.importexport.DataSourceHelper;

public class RepositoryHolder {
    private final DataSourceHelper dataSourceHelper;
    private final List<SchemaManager.RepoInfo> allRepoInfos;
    private final Map<RepoCacheKey, Object> repoCache = new ConcurrentHashMap<RepoCacheKey, Object>();
    private final Map<Class, Function> prepFuncs = new ConcurrentHashMap<Class, Function>();

    public RepositoryHolder(DataSourceHelper dataSourceHelper, List<SchemaManager.RepoInfo> allRepoInfos) {
        this.dataSourceHelper = dataSourceHelper;
        this.allRepoInfos = allRepoInfos;
    }

    public <X> X getDefaultRepository(Class<X> ifc) throws RepositoryException, InstantiationException, IllegalAccessException {
        return this.getRepository(ifc, "default");
    }

    public <X> X getRepository(Class<X> ifc, String name) throws RepositoryException, InstantiationException, IllegalAccessException {
        RepoCacheKey key = new RepoCacheKey(ifc, name);
        Object repo = this.repoCache.get(key);
        if (repo == null) {
            List<SchemaManager.RepoInfo> matchingClasses = this.allRepoInfos.stream().filter(repoInfo -> ifc.isAssignableFrom(repoInfo.getImplementation())).toList();
            SchemaManager.RepoInfo repoInfo2 = this.findRepoInfo(matchingClasses, name).or(() -> this.findRepoInfo(matchingClasses, "default")).orElseThrow();
            repo = this.prepareRepository(this.dataSourceHelper.createRepository(repoInfo2));
            this.repoCache.put(key, repo);
        }
        return (X)repo;
    }

    public <X> void registerPrepFn(Class<X> ifc, Function<X, X> func) {
        this.prepFuncs.put(ifc, func);
    }

    protected <X> X prepareRepository(X repo) throws RepositoryException, InstantiationException, IllegalAccessException {
        for (Map.Entry<Class, Function> e : this.prepFuncs.entrySet()) {
            if (!e.getKey().isAssignableFrom(repo.getClass())) continue;
            repo = e.getValue().apply(repo);
        }
        return repo;
    }

    private Optional<SchemaManager.RepoInfo> findRepoInfo(List<SchemaManager.RepoInfo> repoInfos, String name) {
        return repoInfos.stream().filter(repoInfo -> name.equals(repoInfo.getDataSource().getName())).findFirst();
    }

    private record RepoCacheKey(Class<?> ifc, String name) {
    }
}

