/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBInitForkJoinPoolCache {
    private static final Logger log = Logger.getLogger(DBInitForkJoinPoolCache.class.getCanonicalName());
    public static final DBInitForkJoinPoolCache shared = new DBInitForkJoinPoolCache();
    private final HashMap<String, Item> cache = new HashMap();
    private Timer timer = null;

    public synchronized ForkJoinPool pool(String key, int concurrency) {
        Item item = this.cache.get(key);
        if (item == null) {
            item = new Item(key, concurrency);
            this.cache.put(key, item);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "creating fork-join thread pool for " + key);
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "reusing fork-join thread pool for " + key);
        }
        if (this.timer == null) {
            this.timer = new Timer("dbinit-fork-join-pool-cache-timer", true);
        }
        item.restartTimer(this.timer);
        return item.getPool();
    }

    private synchronized void release(Item item) {
        this.cache.remove(item.getKey());
        if (this.cache.isEmpty()) {
            this.timer.cancel();
            this.timer = null;
        }
        item.getPool().shutdown();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "releasing fork-join thread pool for " + item.getKey());
        }
    }

    private class Item {
        private final String key;
        private final ForkJoinPool pool;
        private TimerTask timerTask;

        public Item(String key, int concurrency) {
            this.key = key;
            this.pool = new ForkJoinPool(concurrency);
        }

        public String getKey() {
            return this.key;
        }

        public ForkJoinPool getPool() {
            return this.pool;
        }

        public void restartTimer(Timer timer) {
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
            this.timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DBInitForkJoinPoolCache dBInitForkJoinPoolCache = DBInitForkJoinPoolCache.this;
                    synchronized (dBInitForkJoinPoolCache) {
                        if (Item.this.timerTask != this) {
                            return;
                        }
                        DBInitForkJoinPoolCache.this.release(Item.this);
                    }
                }
            };
            timer.schedule(this.timerTask, 60000L);
        }
    }
}

