/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.comp;

import java.util.HashSet;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.db.comp.ConfigRepository;
import tigase.db.comp.RepositoryItem;
import tigase.kernel.beans.Inject;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.jid.BareJID;

public abstract class UserRepoRepository<Item extends RepositoryItem>
extends ConfigRepository<Item> {
    public static final String REPO_CLASS_PROP_KEY = "repo-class";
    public static final String REPO_URI_PROP_KEY = "repo-uri";
    private static final Logger log = Logger.getLogger(UserRepoRepository.class.getName());
    private String items_list_pkey = "items-lists";
    @Inject
    protected UserRepository repo = null;

    public abstract BareJID getRepoUser();

    public String getItemsListPKey() {
        return this.items_list_pkey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reload() {
        int hashCode = 0;
        super.reload();
        try {
            if (this.repo == null) {
                log.log(Level.SEVERE, "Repository is not initialised - skipping reload");
                return;
            }
            String items_list = this.repo.getData(this.getRepoUser(), this.getItemsListPKey());
            if (items_list == null) return;
            hashCode = items_list.hashCode();
            if (hashCode != this.itemsHash) {
                HashSet<String> oldKeys = new HashSet<String>(this.items.keySet());
                if (!items_list.isEmpty()) {
                    DomBuilderHandler domHandler = new DomBuilderHandler();
                    SimpleParser parser = SingletonFactory.getParserInstance();
                    parser.parse((SimpleHandler)domHandler, items_list.toCharArray(), 0, items_list.length());
                    Queue elems = domHandler.getParsedElements();
                    if (elems != null && elems.size() > 0) {
                        for (Element elem : elems) {
                            Object item = this.getItemInstance();
                            item.initFromElement(elem);
                            this.addItemNoStore(item);
                            oldKeys.remove(item.getKey());
                        }
                    }
                    log.log(Level.CONFIG, "All loaded items: {0}", this.items);
                }
                this.itemsHash = hashCode;
                for (String key : oldKeys) {
                    this.removeItemNoStore(key);
                }
            }
            if (hashCode == this.itemsHash) return;
        }
        catch (TigaseDBException ex) {
            log.log(Level.SEVERE, "Problem with loading items list from the database.", ex);
        }
    }

    public void setRepo(UserRepository userRepository) {
        this.repo = userRepository;
        try {
            if (!this.repo.userExists(this.getRepoUser())) {
                this.repo.addUser(this.getRepoUser());
            }
        }
        catch (UserExistsException userExistsException) {
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problem with adding '" + String.valueOf(this.getRepoUser()) + "' user to the database", e);
        }
        this.reload();
    }

    @Override
    public void store() {
        super.store();
        if (this.repo != null && this.isInitialized()) {
            StringBuilder sb = new StringBuilder();
            for (RepositoryItem item : this.items.values()) {
                sb.append(item.toElement().toString());
            }
            try {
                this.repo.setData(this.getRepoUser(), this.getItemsListPKey(), sb.toString());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error storing items list in the repository", e);
            }
        }
    }
}

