/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.beans;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.beans.DataSourceBean;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.kernel.core.Kernel;
import tigase.osgi.ModulesManagerImpl;

public abstract class SDRepositoryBean<A extends DataSourceAware>
implements Initializable,
UnregisterAware,
ConfigurationChangedAware,
RegistrarBean {
    private static final Logger log = Logger.getLogger(SDRepositoryBean.class.getCanonicalName());
    @ConfigField(alias="repo-class", desc="Class implementing repository", allowAliasFromParent=false)
    private String cls;
    private DataSource dataSource;
    @Inject
    private DataSourceBean dataSourceBean;
    @ConfigField(desc="Name of data source", alias="data-source")
    private String dataSourceName;
    @Inject
    private EventBus eventBus;
    private Kernel kernel;
    @ConfigField(desc="Bean name")
    private String name;
    @Inject(bean="instance", nullAllowed=true)
    private A repository;

    public String getDataSourceName() {
        if (this.dataSourceName == null) {
            return "default";
        }
        return this.dataSourceName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void beanConfigurationChanged(Collection<String> changedFields) {
        if (this.dataSourceBean == null) {
            return;
        }
        String name = "default";
        if (this.dataSourceName != null && !this.dataSourceName.isEmpty()) {
            name = this.dataSourceName;
        }
        this.dataSource = this.dataSourceBean.getRepository(name);
        if (this.dataSource != null) {
            try {
                Class<?> repoClass = this.getRepositoryClassName();
                this.kernel.registerBean("instance").asClass(repoClass).exec();
            }
            catch (ClassNotFoundException | DBInitException ex) {
                throw new RuntimeException("Could not initialize bean '" + name + "'", ex);
            }
        } else {
            if (this.kernel.isBeanClassRegistered("instance")) {
                this.kernel.unregister("instance");
            }
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "There is no data source named '" + Optional.ofNullable(this.dataSourceName).orElse(name) + "'");
            }
        }
    }

    @Override
    public void register(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public void unregister(Kernel kernel) {
        kernel.unregister("instance");
    }

    @Override
    public void initialize() {
        this.eventBus.registerAll(this);
        this.beanConfigurationChanged(Collections.singleton("uri"));
        if (this.dataSource == null) {
            throw new RuntimeException("There is no data source named '" + Optional.ofNullable(this.dataSourceName).orElse("default") + "'");
        }
        this.setRepository((DataSourceAware)this.kernel.getInstance("instance"));
    }

    @Override
    public void beforeUnregister() {
        this.eventBus.unregisterAll(this);
        this.kernel.unregister("instance");
    }

    protected abstract Class<?> findClassForDataSource(DataSource var1) throws DBInitException;

    protected void initializeRepository(A repository) {
    }

    protected A getRepository() {
        return this.repository;
    }

    public void setRepository(A repository) {
        if (repository != null) {
            this.initializeRepository(repository);
            try {
                this.dataSource.checkSchemaVersion((DataSourceAware<? extends DataSource>)repository, true);
                repository.setDataSource((DataSource)this.dataSource);
            }
            catch (RepositoryException ex) {
                throw new RuntimeException("Failed to initialize repository", ex);
            }
        }
        this.repository = repository;
    }

    protected Class<?> getRepositoryClassName() throws DBInitException, ClassNotFoundException {
        if (this.cls == null) {
            return this.findClassForDataSource(this.dataSource);
        }
        return ModulesManagerImpl.getInstance().forName(this.cls);
    }

    @HandleEvent
    protected void onDataSourceChange(DataSourceBean.DataSourceChangedEvent event) {
        if (!event.isCorrectSender(this.dataSourceBean)) {
            return;
        }
        if (!event.getDomain().equals("default") && !event.getDomain().equals(this.dataSourceName)) {
            return;
        }
        this.beanConfigurationChanged(Collections.singleton("uri"));
    }
}

