/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.annotations.TigaseDeprecated;
import tigase.db.AuthRepository;
import tigase.db.AuthRepositoryPool;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataRepositoryPool;
import tigase.db.Repository;
import tigase.db.UserRepository;
import tigase.db.UserRepositoryPool;
import tigase.osgi.ModulesManagerImpl;
import tigase.util.reflection.ClassUtilBean;

@Deprecated
@TigaseDeprecated(since="8.0.0")
public abstract class RepositoryFactory {
    public static final String AUTH_DOMAIN_POOL_CLASS = "--auth-domain-repo-pool";
    public static final String AUTH_DOMAIN_POOL_CLASS_PROP_KEY = "auth-domain-repo-pool";
    public static final String AUTH_DOMAIN_POOL_CLASS_PROP_VAL = "tigase.db.AuthRepositoryMDImpl";
    public static final String AUTH_REPO_CLASS_PROP_KEY = "auth-repo-class";
    @Deprecated
    public static final String AUTH_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.TigaseCustomAuth";
    public static final String AUTH_REPO_DOMAINS_PROP_KEY = "auth-repo-domains";
    public static final String AUTH_REPO_PARAMS_NODE = "auth-repo-params";
    public static final String AUTH_REPO_POOL_CLASS = "--auth-repo-pool";
    public static final String AUTH_REPO_POOL_CLASS_PROP_DEF = "tigase.db.AuthRepositoryPool";
    public static final String AUTH_REPO_POOL_CLASS_PROP_KEY = "auth-repo-pool";
    public static final String AUTH_REPO_POOL_CLASS_PROP_VAL = null;
    public static final String AUTH_REPO_POOL_SIZE = "--auth-repo-pool-size";
    public static final String AUTH_REPO_POOL_SIZE_PROP_KEY = "auth-repo-pool-size";
    public static final int REPO_POOL_SIZE_FACTOR_PROP_VAL = 4;
    public static final int AUTH_REPO_POOL_SIZE_PROP_VAL = Math.max(10, Runtime.getRuntime().availableProcessors() * 4);
    public static final String AUTH_REPO_URL_PROP_KEY = "auth-repo-url";
    public static final String DATA_REPO_CLASS_PROP_KEY = "data-repo";
    @Deprecated
    public static final String DATA_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.DataRepositoryImpl";
    public static final String DATA_REPO_POOL_CLASS_PROP_KEY = "data-repo-pool";
    public static final String DATA_REPO_POOL_CLASS_PROP_VAL = "tigase.db.DataRepositoryPool";
    public static final String DATA_REPO_POOL_SIZE = "--data-repo-pool-size";
    public static final String DATA_REPO_POOL_SIZE_PROP_KEY = "data-repo-pool-size";
    public static final int DATA_REPO_POOL_SIZE_PROP_VAL = Math.max(10, Runtime.getRuntime().availableProcessors() * 4);
    public static final String DERBY_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.JDBCRepository";
    public static final String DERBY_REPO_URL_PROP_VAL = "jdbc:derby:tigase-derbydb;create=true";
    public static final String DRUPAL_REPO_URL_PROP_VAL = "jdbc:mysql://localhost/drupal?user=root&password=mypass";
    public static final String DRUPALWP_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.DrupalWPAuth";
    public static final String DUMMY_REPO_CLASS_PROP_VAL = "tigase.db.DummyRepository";
    public static final String GEN_AUTH_DB = "--auth-db";
    public static final String GEN_AUTH_DB_URI = "--auth-db-uri";
    public static final String GEN_USER_DB_PROP_KEY = "user-db";
    public static final String GEN_USER_DB = "--user-db";
    public static final String GEN_USER_DB_URI_PROP_KEY = "user-db-uri";
    public static final String GEN_USER_DB_URI = "--user-db-uri";
    public static final String LIBRESOURCE_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.LibreSourceAuth";
    public static final String LIBRESOURCE_REPO_URL_PROP_VAL = "jdbc:postgresql://localhost/libresource?user=demo";
    public static final String SQLSERVER_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.JDBCRepository";
    public static final String SQLSERVER_REPO_URL_PROP_VAL = "jdbc:sqlserver://localhost:1433;databaseName=tigasedb;user=tigase;password=tigase;schema=dbo";
    public static final String MYSQL_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.JDBCRepository";
    public static final String MYSQL_REPO_URL_PROP_VAL = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
    public static final String PGSQL_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.JDBCRepository";
    public static final String PGSQL_REPO_URL_PROP_VAL = "jdbc:postgresql://localhost/tigase?user=tigase";
    public static final String SHARED_AUTH_REPO_PARAMS_PROP_KEY = "shared-auth-repo-params";
    public static final String SHARED_AUTH_REPO_PROP_KEY = "shared-auth-repo";
    public static final String SHARED_USER_REPO_PARAMS_PROP_KEY = "shared-user-repo-params";
    public static final String SHARED_USER_REPO_PROP_KEY = "shared-user-repo";
    public static final String TIGASE_AUTH_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.TigaseAuth";
    public static final String TIGASE_AUTH_REPO_URL_PROP_VAL = "jdbc:mysql://localhost/tigasedb?user=tigase_user&password=mypass";
    public static final String TIGASE_CUSTOM_AUTH_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.TigaseCustomAuth";
    public static final String USER_DOMAIN_POOL_CLASS = "--user-domain-repo-pool";
    public static final String USER_DOMAIN_POOL_CLASS_PROP_KEY = "user-domain-repo-pool";
    public static final String USER_DOMAIN_POOL_CLASS_PROP_VAL = "tigase.db.UserRepositoryMDImpl";
    public static final String USER_REPO_CLASS_PROP_KEY = "user-repo-class";
    @Deprecated
    public static final String USER_REPO_CLASS_PROP_VAL = "tigase.db.jdbc.JDBCRepository";
    public static final String USER_REPO_DOMAINS_PROP_KEY = "user-repo-domains";
    public static final String USER_REPO_PARAMS_NODE = "user-repo-params";
    public static final String USER_REPO_POOL_CLASS = "--user-repo-pool";
    public static final String USER_REPO_POOL_CLASS_PROP_DEF = "tigase.db.UserRepositoryPool";
    public static final String USER_REPO_POOL_CLASS_PROP_KEY = "user-repo-pool";
    public static final String USER_REPO_POOL_CLASS_PROP_VAL = null;
    public static final String USER_REPO_POOL_SIZE = "--user-repo-pool-size";
    public static final String USER_REPO_POOL_SIZE_PROP_KEY = "user-repo-pool-size";
    public static final int USER_REPO_POOL_SIZE_PROP_VAL = Math.max(10, Runtime.getRuntime().availableProcessors() * 4);
    public static final String USER_REPO_URL_PROP_KEY = "user-repo-url";
    public static final String XML_REPO_CLASS_PROP_VAL = "tigase.db.xml.XMLRepository";
    public static final String XML_REPO_URL_PROP_VAL = "user-repository.xml";
    public static final String DATABASE_TYPE_PROP_KEY = "database-type";
    private static final String REPO_POOL_SIZE_PROP_KEY = "repo-pool-size";
    private static final String DEF_REPO_POOL_SIZE_PROP_KEY = "def-repo-pool-size";
    private static final Logger log = Logger.getLogger(RepositoryFactory.class.getCanonicalName());
    private static final ConcurrentMap<String, UserRepository> user_repos = new ConcurrentHashMap<String, UserRepository>(USER_REPO_POOL_SIZE_PROP_VAL);
    private static final ConcurrentMap<String, DataRepository> data_repos = new ConcurrentHashMap<String, DataRepository>(DATA_REPO_POOL_SIZE_PROP_VAL);
    private static final ConcurrentMap<String, AuthRepository> auth_repos = new ConcurrentHashMap<String, AuthRepository>(AUTH_REPO_POOL_SIZE_PROP_VAL);

    public static AuthRepository getAuthRepository(String class_name, String resource, Map<String, String> params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, DBInitException {
        String cls = class_name;
        if (cls == null && (cls = System.getProperty(AUTH_REPO_CLASS_PROP_KEY)) == null) {
            cls = RepositoryFactory.getRepoClassName(AuthRepository.class, resource);
        }
        if (params == null) {
            params = new LinkedHashMap<String, String>(AUTH_REPO_POOL_SIZE_PROP_VAL);
        }
        cls = RepositoryFactory.getRepoClass(cls);
        AuthRepository repo = (AuthRepository)auth_repos.get(cls + resource);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting AuthRepository using: {0} for: {1}; repository instance: ", new Object[]{cls, resource, repo});
        }
        if (repo == null) {
            int repo_pool_size;
            String repo_pool_cls = System.getProperty(AUTH_REPO_POOL_CLASS_PROP_KEY, AUTH_REPO_POOL_CLASS_PROP_VAL);
            if (params.get(AUTH_REPO_POOL_SIZE_PROP_KEY) != null) {
                repo_pool_size = Integer.parseInt(params.get(AUTH_REPO_POOL_SIZE_PROP_KEY));
                params.put(REPO_POOL_SIZE_PROP_KEY, String.valueOf(repo_pool_size));
            } else if (Integer.getInteger(AUTH_REPO_POOL_SIZE_PROP_KEY) != null) {
                repo_pool_size = Integer.getInteger(AUTH_REPO_POOL_SIZE_PROP_KEY);
                params.put(REPO_POOL_SIZE_PROP_KEY, String.valueOf(repo_pool_size));
            } else {
                repo_pool_size = AUTH_REPO_POOL_SIZE_PROP_VAL;
                params.put(DEF_REPO_POOL_SIZE_PROP_KEY, String.valueOf(repo_pool_size));
            }
            params.put(DATABASE_TYPE_PROP_KEY, class_name);
            if (repo_pool_cls != null) {
                AuthRepositoryPool repo_pool = (AuthRepositoryPool)ModulesManagerImpl.getInstance().forName(repo_pool_cls).newInstance();
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "No AuthRepository, creating new; repo_pool_cls: {0}, repo_pool_size: {1}", new Object[]{repo_pool_cls, repo_pool_size});
                }
                repo_pool.initRepository(resource, params);
                for (int i = 0; i < repo_pool_size; ++i) {
                    repo = (AuthRepository)ModulesManagerImpl.getInstance().forName(cls).newInstance();
                    repo.initRepository(resource, params);
                    repo_pool.addRepo(repo);
                }
                repo = repo_pool;
            } else {
                repo = (AuthRepository)ModulesManagerImpl.getInstance().forName(cls).newInstance();
                repo.initRepository(resource, params);
            }
            auth_repos.put(cls + resource, repo);
        }
        return repo;
    }

    public static DataRepository getDataRepository(String class_name, String resource, Map<String, String> params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, DBInitException, SQLException {
        String cls = class_name;
        if (cls == null && (cls = System.getProperty(DATA_REPO_CLASS_PROP_KEY)) == null) {
            cls = RepositoryFactory.getRepoClassName(DataRepository.class, resource);
        }
        if (params == null) {
            params = new LinkedHashMap<String, String>(DATA_REPO_POOL_SIZE_PROP_VAL);
        }
        cls = RepositoryFactory.getRepoClass(cls);
        DataRepository repo = (DataRepository)data_repos.get(cls + resource);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting DataRepository: {0} for: {1}; repository instance: ", new Object[]{cls, resource, repo});
        }
        if (repo == null) {
            int repo_pool_size = params.get(DATA_REPO_POOL_SIZE_PROP_KEY) != null ? Integer.parseInt(params.get(DATA_REPO_POOL_SIZE_PROP_KEY)) : (params.get(REPO_POOL_SIZE_PROP_KEY) != null ? Integer.parseInt(params.get(REPO_POOL_SIZE_PROP_KEY)) : (Integer.getInteger(DATA_REPO_POOL_SIZE_PROP_KEY) != null ? Integer.getInteger(DATA_REPO_POOL_SIZE_PROP_KEY) : (params.get(DEF_REPO_POOL_SIZE_PROP_KEY) != null ? Integer.parseInt(params.get(DEF_REPO_POOL_SIZE_PROP_KEY)) : Integer.getInteger(DATA_REPO_POOL_SIZE_PROP_KEY, DATA_REPO_POOL_SIZE_PROP_VAL))));
            params.put(DATABASE_TYPE_PROP_KEY, class_name);
            String repo_pool_cls = System.getProperty(DATA_REPO_POOL_CLASS_PROP_KEY, DATA_REPO_POOL_CLASS_PROP_VAL);
            DataRepositoryPool repo_pool = (DataRepositoryPool)ModulesManagerImpl.getInstance().forName(repo_pool_cls).newInstance();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "No DataRepository, creating new; repo_pool_cls: {0}, repo_pool_size: {1}", new Object[]{repo_pool_cls, repo_pool_size});
            }
            repo_pool.initRepository(resource, params);
            for (int i = 0; i < repo_pool_size; ++i) {
                repo = (DataRepository)ModulesManagerImpl.getInstance().forName(cls).newInstance();
                repo.initRepository(resource, params);
                repo_pool.addRepo(repo);
            }
            repo = repo_pool;
            data_repos.put(cls + resource, repo);
        }
        return repo;
    }

    public static <T extends Class<? extends Repository>> T getRepoClass(T cls, String uri) throws DBInitException {
        Set<T> classes = RepositoryFactory.getRepoInternalClasses(cls);
        HashSet<T> supported = new HashSet<T>();
        for (T clazz : classes) {
            Repository.Meta annotation = clazz.getAnnotation(Repository.Meta.class);
            if (annotation != null) {
                String[] supportedUris = annotation.supportedUris();
                if (supportedUris != null) {
                    for (String supportedUri : supportedUris) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "checking if {0} for {1} supports {2} while it supports {3} result = {4}", new Object[]{clazz.getCanonicalName(), cls.getCanonicalName(), uri, supportedUri, Pattern.matches(supportedUri, uri)});
                        }
                        if (!Pattern.matches(supportedUri, uri)) continue;
                        supported.add(clazz);
                    }
                    continue;
                }
                supported.add(clazz);
                continue;
            }
            supported.add(clazz);
        }
        if (supported.isEmpty()) {
            throw new DBInitException("[RepositoryFactory] Not found class supporting uri = " + uri);
        }
        Class result = null;
        for (Class clazz : supported) {
            if (result == null) {
                result = clazz;
                continue;
            }
            Repository.Meta ar = result.getAnnotation(Repository.Meta.class);
            Repository.Meta ac = clazz.getAnnotation(Repository.Meta.class);
            if (ac == null || (ar != null || ac == null) && (ar.isDefault() || (ar.supportedUris() != null || ac.supportedUris() == null) && !ac.isDefault())) continue;
            result = clazz;
        }
        return (T)result;
    }

    public static String getRepoClass(String repo_name) {
        String result = repo_name;
        if (repo_name.equals("mysql")) {
            result = "tigase.db.jdbc.JDBCRepository";
        }
        if (repo_name.equals("pgsql")) {
            result = "tigase.db.jdbc.JDBCRepository";
        }
        if (repo_name.equals("derby")) {
            result = "tigase.db.jdbc.JDBCRepository";
        }
        if (repo_name.equals("tigase-custom-auth") || repo_name.equals("tigase-custom") || repo_name.equals("custom-auth")) {
            result = "tigase.db.jdbc.TigaseCustomAuth";
        }
        if (repo_name.equals("tigase-auth")) {
            result = TIGASE_AUTH_REPO_CLASS_PROP_VAL;
        }
        if (repo_name.equals("drupal") || repo_name.equals("wp")) {
            result = DRUPALWP_REPO_CLASS_PROP_VAL;
        }
        if (repo_name.equals("libresource")) {
            result = LIBRESOURCE_REPO_CLASS_PROP_VAL;
        }
        if (repo_name.equals("sqlserver")) {
            result = "tigase.db.jdbc.JDBCRepository";
        }
        return result;
    }

    public static String getRepoClassName(Class cls, String uri) throws DBInitException {
        Class result = RepositoryFactory.getRepoClass(cls, uri);
        return result.getCanonicalName();
    }

    private static <T extends Class<? extends Repository>> Set<T> getRepoInternalClasses(T cls) {
        HashSet result = new HashSet();
        for (Class<?> clazz : ClassUtilBean.getInstance().getAllClasses()) {
            if (!cls.isAssignableFrom(clazz)) continue;
            result.add(clazz);
        }
        return result;
    }

    public static UserRepository getUserRepository(String class_name, String resource, Map<String, String> params) throws ClassNotFoundException, InstantiationException, IllegalAccessException, DBInitException {
        String cls = class_name;
        if (resource == null) {
            resource = System.getProperty(GEN_USER_DB_URI_PROP_KEY);
        }
        if (cls == null && (cls = System.getProperty(USER_REPO_CLASS_PROP_KEY)) == null && (cls = RepositoryFactory.getRepoClassName(UserRepository.class, resource)) == null) {
            cls = System.getProperty(GEN_USER_DB_PROP_KEY);
        }
        if (params == null) {
            params = new LinkedHashMap<String, String>(USER_REPO_POOL_SIZE_PROP_VAL);
        }
        cls = RepositoryFactory.getRepoClass(cls);
        UserRepository repo = (UserRepository)user_repos.get(cls + resource);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting UserRepository: {0} for: {1}; repository instance: ", new Object[]{cls, resource, repo});
        }
        if (repo == null) {
            int repo_pool_size;
            String repo_pool_cls = System.getProperty(USER_REPO_POOL_CLASS_PROP_KEY, USER_REPO_POOL_CLASS_PROP_VAL);
            if (params.get(USER_REPO_POOL_SIZE_PROP_KEY) != null) {
                repo_pool_size = Integer.parseInt(params.get(USER_REPO_POOL_SIZE_PROP_KEY));
                params.put(REPO_POOL_SIZE_PROP_KEY, String.valueOf(repo_pool_size));
            } else if (Integer.getInteger(USER_REPO_POOL_SIZE_PROP_KEY) != null) {
                repo_pool_size = Integer.getInteger(USER_REPO_POOL_SIZE_PROP_KEY);
                params.put(REPO_POOL_SIZE_PROP_KEY, String.valueOf(repo_pool_size));
            } else {
                repo_pool_size = USER_REPO_POOL_SIZE_PROP_VAL;
                params.put(DEF_REPO_POOL_SIZE_PROP_KEY, String.valueOf(repo_pool_size));
            }
            params.put(DATABASE_TYPE_PROP_KEY, class_name);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "No UserRepository, creating new; repo_pool_cls: {0}, repo_pool_size: {1}", new Object[]{repo_pool_cls, repo_pool_size});
            }
            if (repo_pool_cls != null) {
                UserRepositoryPool repo_pool = (UserRepositoryPool)ModulesManagerImpl.getInstance().forName(repo_pool_cls).newInstance();
                repo_pool.initRepository(resource, params);
                for (int i = 0; i < repo_pool_size; ++i) {
                    repo = (UserRepository)ModulesManagerImpl.getInstance().forName(cls).newInstance();
                    repo.initRepository(resource, params);
                    repo_pool.addRepo(repo);
                }
                repo = repo_pool;
            } else {
                repo = (UserRepository)ModulesManagerImpl.getInstance().forName(cls).newInstance();
                repo.initRepository(resource, params);
            }
            user_repos.put(cls + resource, repo);
        }
        return repo;
    }
}

