/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.config.ConfigurationChangedAware;
import tigase.server.Packet;
import tigase.server.monitor.MonitorRuntime;
import tigase.util.log.LogFormatter;

public class LoggingBean
implements ConfigurationChangedAware {
    @ConfigField(desc="Debug", alias="debug")
    private String[] debug;
    @ConfigField(desc="Debug packages", alias="debug-packages")
    private String[] debugPackages;
    @ConfigField(desc="Handlers")
    private HashMap<String, HashMap<String, Object>> handlers = new HashMap();
    @ConfigField(desc="Loggers")
    private HashMap<String, HashMap<String, Object>> loggers = new HashMap();
    @ConfigField(desc="Packet full debug", alias="packet-debug-full")
    private boolean packetFullDebug = Packet.FULL_DEBUG;
    @ConfigField(desc="Root handlers")
    private String[] rootHandlers = new String[0];
    @ConfigField(desc="Root level")
    private Level rootLevel = Level.CONFIG;
    @ConfigField(desc="Log thread dump on shutdown", alias="shutdown-thread-dump")
    private boolean shutdownThreadDump = true;
    private static final Logger log = Logger.getLogger(LoggingBean.class.getName());

    public LoggingBean() {
        HashMap<String, HashMap<String, Object>> loggers = new HashMap<String, HashMap<String, Object>>();
        loggers.computeIfAbsent("tigase.kernel.core.Kernel", name -> {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("level", "CONFIG");
            return props;
        });
        this.setLoggers(loggers);
        this.setHandlers(new HashMap<String, HashMap<String, Object>>());
        this.rootHandlers = new String[]{ConsoleHandler.class.getCanonicalName(), FileHandler.class.getCanonicalName()};
    }

    public synchronized Map<String, Level> getPackageLoggingLevels() {
        Stream<String> debugStream = Stream.concat(Optional.ofNullable(this.debug).map(Arrays::stream).orElse(Stream.empty()).map(s -> "tigase." + s), Optional.ofNullable(this.debugPackages).map(Arrays::stream).orElse(Stream.empty()));
        HashMap<String, Level> result = new HashMap<String, Level>();
        debugStream.forEach(p -> result.put((String)p, Level.ALL));
        for (String p2 : this.loggers.keySet()) {
            Optional.ofNullable(this.loggers.get(p2)).map(v -> v.get("level")).filter(String.class::isInstance).map(v -> {
                try {
                    return Level.parse((String)v);
                }
                catch (IllegalArgumentException ex) {
                    return null;
                }
            }).filter(Objects::nonNull).ifPresent(level -> result.put(p2, (Level)level));
        }
        log.log(Level.FINE, "Currently configured loggers: " + String.valueOf(result));
        return result;
    }

    public synchronized void setPackageLoggingLevel(String packageName, Level level) throws RuntimeException {
        log.log(Level.CONFIG, "Setting log level for package: {0} to {1}", new Object[]{packageName, level});
        if (packageName.startsWith("tigase.")) {
            String part = packageName.substring("tigase.".length());
            Optional.ofNullable(this.debug).map(Arrays::stream).map(s -> s.filter(name -> !part.equals(name))).map(s -> (String[])s.toArray(String[]::new)).ifPresent(value -> {
                this.debug = value;
            });
        }
        Optional.ofNullable(this.debugPackages).map(Arrays::stream).map(s -> s.filter(name -> !packageName.equals(name))).map(s -> (String[])s.toArray(String[]::new)).ifPresent(value -> {
            this.debugPackages = value;
        });
        HashMap<String, Object> value2 = this.loggers.get(packageName);
        if (value2 == null) {
            if (level != Level.OFF) {
                value2 = new HashMap();
                value2.put("level", level.getName());
                this.loggers.put(packageName, value2);
            }
        } else if (level == Level.OFF) {
            if (value2.size() == 1) {
                this.loggers.remove(packageName);
            } else {
                value2.remove("level");
            }
        } else {
            value2.put("level", level.getName());
        }
        this.beanConfigurationChanged(Collections.emptySet());
    }

    public void setLoggers(HashMap<String, HashMap<String, Object>> loggers) {
        loggers.compute("tigase", (name, props) -> {
            if (props == null) {
                props = new HashMap<String, Boolean>();
            }
            props.putIfAbsent("useParentHandlers", true);
            return props;
        });
        this.loggers = loggers;
    }

    public void setHandlers(HashMap<String, HashMap<String, Object>> handlers) {
        handlers.compute(ConsoleHandler.class.getCanonicalName(), (cls, props) -> {
            if (props == null) {
                props = new HashMap<String, Level>();
            }
            props.putIfAbsent("level", Level.INFO);
            props.putIfAbsent("formatter", (Level)((Object)LogFormatter.class.getCanonicalName()));
            return props;
        });
        handlers.compute(FileHandler.class.getCanonicalName(), (cls, props) -> {
            if (props == null) {
                props = new HashMap<String, Level>();
            }
            props.putIfAbsent("level", Level.ALL);
            props.putIfAbsent("append", (Level)((Object)Boolean.valueOf(true)));
            props.putIfAbsent("count", (Level)((Object)Integer.valueOf(5)));
            props.putIfAbsent("limit", (Level)((Object)Integer.valueOf(10000000)));
            props.putIfAbsent("formatter", (Level)((Object)LogFormatter.class.getCanonicalName()));
            props.putIfAbsent("pattern", (Level)((Object)"logs/tigase.log"));
            return props;
        });
        this.handlers = handlers;
    }

    public boolean getPacketFullDebug() {
        return Packet.FULL_DEBUG;
    }

    public void setPacketFullDebug(boolean packetFullDebug) {
        this.packetFullDebug = packetFullDebug;
        Packet.FULL_DEBUG = packetFullDebug;
    }

    @Override
    public void beanConfigurationChanged(Collection<String> changedFields) {
        StringBuilder sb = new StringBuilder();
        sb.append(".level=").append(this.rootLevel.getName()).append("\n");
        Stream.concat(Optional.ofNullable(this.debug).stream().flatMap(Arrays::stream).map(s -> "tigase." + s), Optional.ofNullable(this.debugPackages).stream().flatMap(Arrays::stream)).forEach(name -> sb.append((String)name).append(".level=").append(Level.ALL).append("\n"));
        this.loggers.forEach((name, props) -> props.forEach((key, value) -> {
            log.log(Level.CONFIG, "Setting log level for loggerName: {0} to: {1}", new Object[]{name, props});
            sb.append((String)name).append(".").append((String)key).append("=");
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                boolean first = true;
                for (Object item : col) {
                    if (!first) {
                        sb.append(" ");
                    } else {
                        first = false;
                    }
                    sb.append(item);
                }
            } else {
                sb.append(value);
            }
            sb.append("\n");
        }));
        this.handlers.forEach((name, props) -> props.forEach((key, value) -> sb.append((String)name).append(".").append((String)key).append("=").append(value).append("\n")));
        sb.append("handlers=");
        if (this.rootHandlers != null) {
            for (int i = 0; i < this.rootHandlers.length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(this.rootHandlers[i]);
            }
        }
        byte[] data = sb.toString().getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            LogManager.getLogManager().reset();
            LogManager.getLogManager().updateConfiguration(in, k -> k.endsWith(".handlers") ? (o, n) -> o == null ? n : o : (o, n) -> n);
            log.log(Level.CONFIG, "Initialised LogManager with configuration: {0}", new Object[]{sb});
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load logging configuration", ex);
        }
    }

    public boolean isShutdownThreadDump() {
        return MonitorRuntime.getMonitorRuntime().isShutdownThreadDump();
    }

    public void setShutdownThreadDump(boolean shutdownThreadDump) {
        MonitorRuntime.getMonitorRuntime().setShutdownThreadDump(shutdownThreadDump);
    }
}

