/*
 * Decompiled with CFR 0.152.
 */
package tigase.component.modules.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tigase.annotations.TigaseDeprecated;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.AbstractModule;
import tigase.component.modules.Module;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.criteria.Or;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.BasicComponent;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.rsm.RSM;

@Bean(name="disco", active=true)
public class DiscoveryModule
extends AbstractModule {
    public static final String DISCO_INFO_XMLNS = "http://jabber.org/protocol/disco#info";
    public static final String DISCO_ITEMS_XMLNS = "http://jabber.org/protocol/disco#items";
    private static final String[] FEATURES = new String[]{"http://jabber.org/protocol/disco#info", "http://jabber.org/protocol/disco#items"};
    public static final String ID = "disco";
    @Inject(nullAllowed=true)
    private AdHocCommandModule adHocCommandModule;
    @Inject(bean="service")
    protected BasicComponent component;
    private Criteria criteria = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)new Or(new Criteria[]{ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#info"), ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#items")}));
    @Inject(type=Module.class)
    private List<Module> modules;

    public AdHocCommandModule getAdHocCommandModule() {
        return this.adHocCommandModule;
    }

    public void setAdHocCommandModule(AdHocCommandModule adHocCommandModule) {
        this.adHocCommandModule = adHocCommandModule;
    }

    public Set<String> getAvailableFeatures(BareJID serviceJID, String node, BareJID senderJID) {
        return this.getAvailableFeatures();
    }

    public Set<String> getAvailableFeatures() {
        HashSet<String> features = new HashSet<String>();
        for (Module m : this.modules) {
            String[] fs = m.getFeatures();
            if (fs == null) continue;
            for (String string : fs) {
                features.add(string);
            }
        }
        return features;
    }

    @Override
    public String[] getFeatures() {
        return FEATURES;
    }

    @Override
    public Criteria getModuleCriteria() {
        return this.criteria;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        block6: {
            Element q = packet.getElement().getChild("query");
            JID senderJID = packet.getStanzaFrom();
            JID jid = packet.getStanzaTo();
            String node = q.getAttributeStaticStr("node");
            try {
                if (q.getXMLNS().equals(DISCO_INFO_XMLNS)) {
                    this.processDiscoInfo(packet, jid, node, senderJID);
                    break block6;
                }
                if (q.getXMLNS().equals(DISCO_ITEMS_XMLNS) && node != null && node.equals("http://jabber.org/protocol/commands")) {
                    this.processAdHocCommandItems(packet, jid, node, senderJID);
                    break block6;
                }
                if (q.getXMLNS().equals(DISCO_ITEMS_XMLNS)) {
                    this.processDiscoItems(packet, jid, node, senderJID);
                    break block6;
                }
                throw new ComponentException(Authorization.BAD_REQUEST);
            }
            catch (ComponentException e) {
                throw e;
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void processAdHocCommandItems(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        if (this.adHocCommandModule == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND);
        }
        Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{DISCO_ITEMS_XMLNS});
        Packet result = packet.okResult(resultQuery, 0);
        List<Element> items = this.adHocCommandModule.getScriptItems(node, packet.getStanzaTo(), packet.getStanzaFrom());
        resultQuery.addChildren(items);
        this.write(result);
    }

    protected void processDiscoInfo(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        Packet resultIq = this.prepareDiscoInfoResponse(packet, jid, node, senderJID);
        this.write(resultIq);
    }

    @Deprecated
    @TigaseDeprecated(removeIn="9.0.0", since="8.1.0", note="Deprecating method with type-o")
    protected Packet prepareDiscoInfoReponse(Packet packet, JID jid, String node, JID senderJID) {
        return this.prepareDiscoInfoResponse(packet, jid, node, senderJID);
    }

    protected Packet prepareDiscoInfoResponse(Packet packet, JID jid, String node, JID senderJID) {
        Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{DISCO_INFO_XMLNS});
        Packet resultIq = packet.okResult(resultQuery, 0);
        resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type", "name"}, new String[]{this.component.getDiscoCategory(), this.component.getDiscoCategoryType(), this.component.getDiscoDescription()}));
        for (String f : this.getAvailableFeatures(jid.getBareJID(), node, senderJID.getBareJID())) {
            resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{f}));
        }
        Element form = this.component.getDiscoExtensionsForm(jid.getDomain());
        if (form != null) {
            resultQuery.addChild((XMLNodeIfc)form);
        }
        return resultIq;
    }

    protected List<Element> prepareDiscoItems(JID jid, String node, JID senderJID, RSM rsm) throws ComponentException, RepositoryException {
        return Collections.emptyList();
    }

    protected void processDiscoItems(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{DISCO_ITEMS_XMLNS});
        Element rsmEl = packet.getElement().getChildStaticStr("query", DISCO_ITEMS_XMLNS).getChildStaticStr("set", "http://jabber.org/protocol/rsm");
        RSM rsm = null;
        if (rsmEl != null) {
            rsm = RSM.parseRootElement((Element)packet.getElement().getChild("query"));
        }
        List<Element> results = this.prepareDiscoItems(jid, node, senderJID, rsm);
        if (node != null) {
            resultQuery.setAttribute("node", node);
        }
        resultQuery.addChildren(results);
        if (rsm != null && !results.isEmpty()) {
            resultQuery.addChild((XMLNodeIfc)rsm.toElement());
        }
        this.write(packet.okResult(resultQuery, 0));
    }
}

