/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.credentials.entries;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import tigase.auth.CredentialsDecoderBean;
import tigase.auth.CredentialsEncoderBean;
import tigase.auth.credentials.entries.PlainCredentialsEntry;
import tigase.auth.credentials.entries.ScramCredentialsEntry;
import tigase.kernel.beans.Bean;

public class ScramSha256CredentialsEntry
extends ScramCredentialsEntry {
    private static final String ALGORITHM = "SHA-256";

    public ScramSha256CredentialsEntry(PlainCredentialsEntry entry) throws NoSuchAlgorithmException, InvalidKeyException {
        super(ALGORITHM, entry);
    }

    public ScramSha256CredentialsEntry(byte[] salt, int iterations, byte[] saltedPassword) throws NoSuchAlgorithmException, InvalidKeyException {
        super(ALGORITHM, salt, iterations, saltedPassword);
    }

    public ScramSha256CredentialsEntry(byte[] salt, int iterations, byte[] storedKey, byte[] serverKey) {
        super(ALGORITHM, salt, iterations, storedKey, serverKey);
    }

    @Bean(name="SCRAM-SHA-256", parent=CredentialsEncoderBean.class, active=true)
    public static class Encoder
    extends ScramCredentialsEntry.Encoder {
        public Encoder() {
            super(ScramSha256CredentialsEntry.ALGORITHM);
        }
    }

    @Bean(name="SCRAM-SHA-256", parent=CredentialsDecoderBean.class, active=true)
    public static class Decoder
    extends ScramCredentialsEntry.Decoder {
        public Decoder() {
            super(ScramSha256CredentialsEntry.ALGORITHM);
        }

        @Override
        protected ScramSha256CredentialsEntry newInstance(byte[] salt, int iterations, byte[] saltedPassword) {
            try {
                return new ScramSha256CredentialsEntry(salt, iterations, saltedPassword);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected ScramSha256CredentialsEntry newInstance(byte[] salt, int iterations, byte[] storedKey, byte[] serverKey) {
            return new ScramSha256CredentialsEntry(salt, iterations, storedKey, serverKey);
        }
    }
}

