/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Queue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.MobileV3;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.JID;

public class MobileV3Test
extends ProcessorTestCase {
    private SessionManagerHandler loginHandler;
    private MobileV3 mobileV3;

    @Override
    @Before
    public void setUp() throws Exception {
        this.mobileV3 = new MobileV3();
        this.mobileV3.init(new HashMap());
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.mobileV3 = null;
        super.tearDown();
    }

    @Test
    public void testRecipientDisabledFor2ResourcesMessage() throws TigaseStringprepException, NotAuthorizedException {
        String recipient = "recipient-1@localhost";
        JID recp1 = JID.jidInstanceNS((String)(recipient + "/res1"));
        JID recp2 = JID.jidInstanceNS((String)(recipient + "/res2"));
        JID connId1 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res1");
        JID connId2 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res2");
        XMPPResourceConnection session1 = this.getSession(connId1, recp1);
        this.getSession(connId2, recp2);
        Packet p = Packet.packetInstance((String)"message", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.chat);
        p.setPacketTo(connId1);
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        results.offer(p);
        Object[] expected = results.toArray(new Packet[0]);
        this.mobileV3.filter(p, session1, null, results);
        Object[] processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
    }

    @Test
    public void testRecipientEnabledFor2ResourcesMessage() throws TigaseStringprepException, NotAuthorizedException {
        String recipient = "recipient-1@localhost";
        JID recp1 = JID.jidInstanceNS((String)(recipient + "/res1"));
        JID recp2 = JID.jidInstanceNS((String)(recipient + "/res2"));
        JID connId1 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res1");
        JID connId2 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res2");
        XMPPResourceConnection session1 = this.getSession(connId1, recp1);
        this.getSession(connId2, recp2);
        this.enableMobileV3(session1, recp1);
        Packet p = Packet.packetInstance((String)"message", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.chat);
        p.setPacketTo(connId1);
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        results.offer(p);
        Object[] expected = results.toArray(new Packet[0]);
        this.mobileV3.filter(p, session1, null, results);
        Object[] processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
    }

    @Test
    public void testRecipientDisabledFor2ResourcesPresence() throws TigaseStringprepException, NotAuthorizedException {
        String recipient = "recipient-1@localhost";
        JID recp1 = JID.jidInstanceNS((String)(recipient + "/res1"));
        JID recp2 = JID.jidInstanceNS((String)(recipient + "/res2"));
        JID connId1 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res1");
        JID connId2 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res2");
        XMPPResourceConnection session1 = this.getSession(connId1, recp1);
        this.getSession(connId2, recp2);
        Packet p = Packet.packetInstance((String)"presence", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.chat);
        p.setPacketTo(connId1);
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        results.offer(p);
        Object[] expected = results.toArray(new Packet[0]);
        this.mobileV3.filter(p, session1, null, results);
        Object[] processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
    }

    @Test
    public void testRecipientEnabledFor2ResourcesPresence() throws TigaseStringprepException, NotAuthorizedException {
        String recipient = "recipient-1@localhost";
        JID recp1 = JID.jidInstanceNS((String)(recipient + "/res1"));
        JID recp2 = JID.jidInstanceNS((String)(recipient + "/res2"));
        JID connId1 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res1");
        JID connId2 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res2");
        XMPPResourceConnection session1 = this.getSession(connId1, recp1);
        this.getSession(connId2, recp2);
        this.enableMobileV3(session1, recp1);
        Packet presence = Packet.packetInstance((String)"presence", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.available);
        presence.setPacketTo(connId1);
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        results.offer(presence);
        Object[] expected = new Packet[]{};
        this.mobileV3.filter(presence, session1, null, results);
        Object[] processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
    }

    @Test
    public void testRecipientEnabledFor2Resources2Presences() throws TigaseStringprepException, NotAuthorizedException {
        String recipient = "recipient-1@localhost";
        JID recp1 = JID.jidInstanceNS((String)(recipient + "/res1"));
        JID recp2 = JID.jidInstanceNS((String)(recipient + "/res2"));
        JID connId1 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res1");
        JID connId2 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res2");
        XMPPResourceConnection session1 = this.getSession(connId1, recp1);
        this.getSession(connId2, recp2);
        this.enableMobileV3(session1, recp1);
        Packet presence = Packet.packetInstance((String)"presence", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.available);
        presence.setPacketTo(connId1);
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        results.offer(presence);
        Object[] expected = new Packet[]{};
        this.mobileV3.filter(presence, session1, null, results);
        Object[] processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
        presence = Packet.packetInstance((String)"presence", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.available);
        presence.setPacketTo(connId1);
        results = new ArrayDeque();
        results.offer(presence);
        expected = new Packet[]{};
        this.mobileV3.filter(presence, session1, null, results);
        processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
        results.clear();
        Packet p = Packet.packetInstance((String)"message", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.chat);
        p.setPacketTo(connId1);
        results.offer(p);
        Packet p1 = Packet.packetInstance((String)"presence", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.error);
        p1.setPacketTo(connId1);
        results.offer(p1);
        expected = new Packet[]{presence, p, p1};
        this.mobileV3.filter(p, session1, null, results);
        processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
    }

    @Test
    public void testRecipientEnabledFor2Resources() throws TigaseStringprepException, NotAuthorizedException {
        String recipient = "recipient-1@localhost";
        JID recp1 = JID.jidInstanceNS((String)(recipient + "/res1"));
        JID recp2 = JID.jidInstanceNS((String)(recipient + "/res2"));
        JID connId1 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res1");
        JID connId2 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res2");
        XMPPResourceConnection session1 = this.getSession(connId1, recp1);
        this.getSession(connId2, recp2);
        this.enableMobileV3(session1, recp1);
        Packet presence = Packet.packetInstance((String)"presence", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.available);
        presence.setPacketTo(connId1);
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        results.offer(presence);
        Object[] expected = new Packet[]{};
        this.mobileV3.filter(presence, session1, null, results);
        Object[] processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
        results.clear();
        Packet p = Packet.packetInstance((String)"message", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.chat);
        p.setPacketTo(connId1);
        results.offer(p);
        Packet p1 = Packet.packetInstance((String)"presence", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.error);
        p1.setPacketTo(connId1);
        results.offer(p1);
        expected = new Packet[]{presence, p, p1};
        this.mobileV3.filter(p, session1, null, results);
        processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
    }

    @Test
    public void testRecipientEnabledFor2ResourcesMixed() throws TigaseStringprepException, NotAuthorizedException {
        String recipient = "recipient-1@localhost";
        JID recp1 = JID.jidInstanceNS((String)(recipient + "/res1"));
        JID recp2 = JID.jidInstanceNS((String)(recipient + "/res2"));
        JID connId1 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res1");
        JID connId2 = JID.jidInstanceNS((String)"c2s@localhost/recipient1-res2");
        XMPPResourceConnection session1 = this.getSession(connId1, recp1);
        this.getSession(connId2, recp2);
        this.enableMobileV3(session1, recp1);
        Packet presence = Packet.packetInstance((String)"presence", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.available);
        presence.setPacketTo(connId1);
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        results.offer(presence);
        Object[] expected = new Packet[]{};
        this.mobileV3.filter(presence, session1, null, results);
        Object[] processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
        results.clear();
        Packet m1 = Packet.packetInstance((String)"message", (String)recp2.toString(), (String)recp1.toString(), (StanzaType)StanzaType.chat);
        Element receivedEl = new Element("received", new String[]{"xmlns"}, new String[]{"urn:xmpp:carbons:2"});
        Element forwardedEl = new Element("forwarded", new String[]{"xmlns"}, new String[]{"urn:xmpp:forward:0"});
        forwardedEl.addChild((XMLNodeIfc)new Element("message", new String[]{"from", "to"}, new String[]{recp2.toString(), "sender-1@localhost/res1"}));
        receivedEl.addChild((XMLNodeIfc)forwardedEl);
        m1.getElement().addChild((XMLNodeIfc)receivedEl);
        m1.setPacketTo(connId1);
        results.offer(m1);
        expected = new Packet[]{};
        this.mobileV3.filter(m1, session1, null, results);
        processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
        results.clear();
        presence = Packet.packetInstance((String)"presence", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.available);
        presence.setPacketTo(connId1);
        results.offer(presence);
        expected = new Packet[]{};
        this.mobileV3.filter(presence, session1, null, results);
        processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
        results.clear();
        Packet p = Packet.packetInstance((String)"message", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.chat);
        p.setPacketTo(connId1);
        results.offer(p);
        Packet p1 = Packet.packetInstance((String)"presence", (String)"sender-1@localhost/res1", (String)recp1.toString(), (StanzaType)StanzaType.error);
        p1.setPacketTo(connId1);
        results.offer(p1);
        expected = new Packet[]{presence, m1, p, p1};
        this.mobileV3.filter(p, session1, null, results);
        processed = results.toArray(new Packet[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])processed);
    }

    private Queue<Packet> enableMobileV3(XMPPResourceConnection session, JID userJid) throws TigaseStringprepException {
        Packet p = Packet.packetInstance((String)"iq", (String)userJid.toString(), (String)userJid.toString(), (StanzaType)StanzaType.set);
        p.getElement().addChild((XMLNodeIfc)new Element("mobile", new String[]{"xmlns", "enable"}, new String[]{"http://tigase.org/protocol/mobile#v3", "true"}));
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        this.mobileV3.process(p, session, null, results, null);
        return results;
    }
}

