/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.MessageCarbons;
import tigase.xmpp.impl.MessageDeliveryLogic;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class MessageCarbonsTest
extends ProcessorTestCase {
    private MessageCarbons carbonsProcessor;

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean(MessageDeliveryLogic.class).exec();
        kernel.registerBean(MessageCarbons.class).setActive(true).exec();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.carbonsProcessor = this.getInstance(MessageCarbons.class);
    }

    @Test
    public void testDisco() throws Exception {
        Assert.assertTrue((boolean)Arrays.stream(this.carbonsProcessor.supDiscoFeatures(null)).anyMatch(el -> "urn:xmpp:carbons:2".equals(el.getAttributeStaticStr("var"))));
        Assert.assertTrue((boolean)Arrays.stream(this.carbonsProcessor.supDiscoFeatures(null)).anyMatch(el -> "urn:xmpp:carbons:rules:0".equals(el.getAttributeStaticStr("var"))));
    }

    @Test
    public void testDeliveryOfMessageWithBody() throws Exception {
        Packet packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body")}, new String[]{"type"}, new String[]{"chat"}));
        Assert.assertTrue((boolean)this.carbonsProcessor.shouldSendCarbons(packet, null));
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body")}, new String[]{"type"}, new String[]{"normal"}));
        Assert.assertTrue((boolean)this.carbonsProcessor.shouldSendCarbons(packet, null));
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body")}, null, null));
        Assert.assertTrue((boolean)this.carbonsProcessor.shouldSendCarbons(packet, null));
        packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body")}, new String[]{"type"}, new String[]{"groupchat"}));
        Assert.assertFalse((boolean)this.carbonsProcessor.shouldSendCarbons(packet, null));
    }

    @Test
    public void testDeliveryOfMessageWithIMPayload() throws Exception {
        Packet packet = Packet.packetInstance((Element)new Element("message"));
        Assert.assertFalse((boolean)this.carbonsProcessor.shouldSendCarbons(packet, null));
        packet.getElement().setChildren(List.of(new Element("received", new String[]{"xmlns"}, new String[]{"urn:xmpp:receipts"})));
        Assert.assertTrue((boolean)this.carbonsProcessor.shouldSendCarbons(packet, null));
        packet.getElement().setChildren(List.of(new Element("active", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/chatstates"})));
        Assert.assertTrue((boolean)this.carbonsProcessor.shouldSendCarbons(packet, null));
        packet.getElement().setChildren(List.of(new Element("received", new String[]{"xmlns"}, new String[]{"urn:xmpp:chat-markers:0"})));
        Assert.assertTrue((boolean)this.carbonsProcessor.shouldSendCarbons(packet, null));
    }

    @Test
    public void testDeliveryOfMucMessage_Groupchat() throws Exception {
        Packet packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body")}, new String[]{"type"}, new String[]{"groupchat"}));
        Assert.assertFalse((boolean)this.carbonsProcessor.shouldSendCarbons(packet, null));
    }

    @Test
    public void testDeliveryOfMucMessage_DirectInvitation() throws Exception {
        Packet packet = Packet.packetInstance((Element)new Element("message"));
        packet.getElement().setChildren(List.of(new Element("x", new Element[]{new Element("invite")}, new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"})));
        Assert.assertTrue((boolean)this.carbonsProcessor.shouldSendCarbons(packet, null));
    }

    @Test
    public void testDeliveryOfMucMessage_SentPM() throws Exception {
        JID sender = JID.jidInstanceNS((String)"user@domain.com/res-1");
        JID recipient = JID.jidInstanceNS((String)"room@muc.domain.com/Julia");
        XMPPResourceConnection session = this.getSession(sender, sender);
        Packet packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body"), new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"})}, new String[]{"type"}, new String[]{"chat"}), (JID)sender, (JID)recipient);
        Assert.assertTrue((boolean)this.carbonsProcessor.shouldSendCarbons(packet, session));
    }

    @Test
    public void testDeliveryOfMucMessage_ReceivedPM() throws Exception {
        JID recipient = JID.jidInstanceNS((String)"user@domain.com/res-1");
        JID sender = JID.jidInstanceNS((String)"room@muc.domain.com/Julia");
        XMPPResourceConnection session = this.getSession(recipient, recipient);
        Packet packet = Packet.packetInstance((Element)new Element("message", new Element[]{new Element("body"), new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"})}, new String[]{"type"}, new String[]{"chat"}), (JID)sender, (JID)recipient);
        Assert.assertFalse((boolean)this.carbonsProcessor.shouldSendCarbons(packet, session));
    }

    @Test
    public void testDeliveryOfMucMessage_MediatedInvitation() throws Exception {
        Packet packet = Packet.packetInstance((Element)new Element("message"));
        packet.getElement().setChildren(List.of(new Element("x", new String[]{"xmlns"}, new String[]{"jabber:x:conference"})));
        Assert.assertTrue((boolean)this.carbonsProcessor.shouldSendCarbons(packet, null));
    }

    @Test
    public void testResourceSelectionForMessageDeliveryForBareJid() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        JID res2 = JID.jidInstance((BareJID)userJid, (String)"res2");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        XMPPResourceConnection session2 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res2);
        session2.putSessionData("urn:xmpp:carbons:2-enabled", (Object)true);
        HashMap<JID, Boolean> enabled = new HashMap<JID, Boolean>();
        enabled.put(res2, true);
        session2.putCommonSessionData("urn:xmpp:carbons:2-resources", enabled);
        Assert.assertEquals(Arrays.asList(session1, session2), (Object)session1.getActiveSessions());
        Element packetEl = new Element("message", new String[]{"type", "from", "to"}, new String[]{"chat", "remote-user@test.com/res1", userJid.toString()});
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque<Object> results = new ArrayDeque<Packet>();
        this.carbonsProcessor.process(packet, session2, null, results, null);
        Assert.assertEquals((String)"generated result even than no resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session2.getJID()), this.collectStanzaTo(results));
        session1.setPresence(new Element("presence"));
        results = new ArrayDeque();
        this.carbonsProcessor.process(packet, session2, null, results, null);
        Assert.assertEquals((String)"not generated result even than 1 resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session2.getJID()), this.collectStanzaTo(results));
        session2.setPresence(new Element("presence"));
        results = new ArrayDeque();
        this.carbonsProcessor.process(packet, session1, null, results, null);
        Assert.assertEquals((String)"not generated result even than 2 resource had nonnegative priority", (long)0L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(new Object[0]), this.collectStanzaTo(results));
    }

    @Test
    public void testResourceSelectionForMessageDeliveryForFullJid() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        JID res2 = JID.jidInstance((BareJID)userJid, (String)"res2");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        XMPPResourceConnection session2 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res2);
        session2.putSessionData("urn:xmpp:carbons:2-enabled", (Object)true);
        HashMap<JID, Boolean> enabled = new HashMap<JID, Boolean>();
        enabled.put(res2, true);
        session2.putCommonSessionData("urn:xmpp:carbons:2-resources", enabled);
        Assert.assertEquals(Arrays.asList(session1, session2), (Object)session1.getActiveSessions());
        Element packetEl = new Element("message", new String[]{"type", "from", "to"}, new String[]{"chat", "remote-user@test.com/res1", res1.toString()});
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque<Object> results = new ArrayDeque<Packet>();
        this.carbonsProcessor.process(packet, session1, null, results, null);
        Assert.assertEquals((String)"generated result even than no resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session2.getJID()), this.collectStanzaTo(results));
        session1.setPresence(new Element("presence"));
        results = new ArrayDeque();
        this.carbonsProcessor.process(packet, session1, null, results, null);
        Assert.assertEquals((String)"not generated result even than 1 resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session2.getJID()), this.collectStanzaTo(results));
        session2.setPresence(new Element("presence"));
        results = new ArrayDeque();
        this.carbonsProcessor.process(packet, session1, null, results, null);
        Assert.assertEquals((String)"not generated result even than 2 resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session2.getJID()), this.collectStanzaTo(results));
        results = new ArrayDeque();
        Packet packet1 = packet.copyElementOnly();
        packet1.getElement().addChild((XMLNodeIfc)new Element("no-copy", new String[]{"xmlns"}, new String[]{"urn:xmpp:hints"}));
        this.carbonsProcessor.process(packet1, session1, null, results, null);
        Assert.assertEquals((String)"generated result even that no-copy was sent", (long)0L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", (Object)Collections.EMPTY_LIST, this.collectStanzaTo(results));
    }

    @Test
    public void testResourceSelectionForMessageDeliveryForFullJid_NotChat() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        JID res2 = JID.jidInstance((BareJID)userJid, (String)"res2");
        XMPPResourceConnection session1 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res1);
        XMPPResourceConnection session2 = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res2);
        session2.putSessionData("urn:xmpp:carbons:2-enabled", (Object)true);
        HashMap<JID, Boolean> enabled = new HashMap<JID, Boolean>();
        enabled.put(res2, true);
        session2.putCommonSessionData("urn:xmpp:carbons:2-resources", enabled);
        Assert.assertEquals(Arrays.asList(session1, session2), (Object)session1.getActiveSessions());
        Element packetEl = new Element("message", new String[]{"from", "to"}, new String[]{"remote-user@test.com/res1", res1.toString()});
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque<Object> results = new ArrayDeque<Packet>();
        this.carbonsProcessor.process(packet, session1, null, results, null);
        Assert.assertEquals((String)"generated result even than no resource had nonnegative priority", (long)0L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Collections.emptyList(), this.collectStanzaTo(results));
        packetEl = new Element("message", new String[]{"from", "to"}, new String[]{"remote-user@test.com/res1", res1.toString()});
        packetEl.addChild((XMLNodeIfc)new Element("received", new String[]{"xmlns"}, new String[]{"urn:xmpp:receipts"}));
        packet = Packet.packetInstance((Element)packetEl);
        results = new ArrayDeque();
        this.carbonsProcessor.process(packet, session1, null, results, null);
        Assert.assertEquals((String)"generated result even than no resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session2.getJID()), this.collectStanzaTo(results));
        session1.setPresence(new Element("presence"));
        results = new ArrayDeque();
        this.carbonsProcessor.process(packet, session1, null, results, null);
        Assert.assertEquals((String)"not generated result even than 1 resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session2.getJID()), this.collectStanzaTo(results));
        session2.setPresence(new Element("presence"));
        results = new ArrayDeque();
        this.carbonsProcessor.process(packet, session1, null, results, null);
        Assert.assertEquals((String)"not generated result even than 2 resource had nonnegative priority", (long)1L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", Arrays.asList(session2.getJID()), this.collectStanzaTo(results));
        results = new ArrayDeque();
        Packet packet1 = packet.copyElementOnly();
        packet1.getElement().addChild((XMLNodeIfc)new Element("no-copy", new String[]{"xmlns"}, new String[]{"urn:xmpp:hints"}));
        this.carbonsProcessor.process(packet1, session1, null, results, null);
        Assert.assertEquals((String)"generated result even that no-copy was sent", (long)0L, (long)results.size());
        Assert.assertEquals((String)"packet sent to wrong jids", (Object)Collections.EMPTY_LIST, this.collectStanzaTo(results));
    }

    protected List<JID> collectStanzaTo(Queue<Packet> packets) {
        Packet p;
        ArrayList<JID> result = new ArrayList<JID>();
        while ((p = packets.poll()) != null) {
            result.add(p.getStanzaTo());
        }
        return result;
    }
}

