/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.junit.Assert;
import tigase.TestLogger;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostItemDefaults;
import tigase.vhosts.VHostItemExtensionManager;
import tigase.vhosts.VHostItemImpl;
import tigase.vhosts.filter.DomainFilterPolicy;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

public class VHostItemTest
extends TestCase {
    private static final Logger log = TestLogger.getLogger(VHostItemTest.class);
    private final VHostItemExtensionManager vHostItemExtensionManager = new VHostItemExtensionManager();

    public void testVHostItem() throws TigaseStringprepException {
        VHostItemTest.assertEquals((Object)new VHostItemImpl("lowercase.com"), (Object)new VHostItemImpl("lowercase.com"));
        VHostItemTest.assertEquals((Object)new VHostItemImpl("CAPITAL.COM"), (Object)new VHostItemImpl("capital.com"));
        VHostItemTest.assertNotSame((Object)new VHostItemImpl("CAPITAL.COM"), (Object)new VHostItemImpl("lowercase.com"));
    }

    public void testVHostDomainPolicy() throws TigaseStringprepException {
        VHostItemImpl vHostItem = new VHostItemImpl();
        vHostItem.setExtensionManager(this.vHostItemExtensionManager);
        vHostItem.initFromPropertyString("domain1:domain-filter=LOCAL:max-users=1000");
        VHostItemTest.assertEquals((Object)DomainFilterPolicy.LOCAL, (Object)vHostItem.getDomainFilter());
        VHostItemTest.assertTrue((vHostItem.getDomainFilterDomains() == null ? 1 : 0) != 0);
        vHostItem = new VHostItemImpl();
        vHostItem.setExtensionManager(this.vHostItemExtensionManager);
        vHostItem.initFromPropertyString("domain1:domain-filter=LIST=domain1;domain2;domain3:max-users=1000");
        VHostItemTest.assertEquals((Object)DomainFilterPolicy.LIST, (Object)vHostItem.getDomainFilter());
        VHostItemTest.assertTrue((boolean)Arrays.asList(vHostItem.getDomainFilterDomains()).contains("domain1"));
        VHostItemTest.assertTrue((boolean)Arrays.asList(vHostItem.getDomainFilterDomains()).contains("domain3"));
        VHostItemTest.assertFalse((boolean)Arrays.asList(vHostItem.getDomainFilterDomains()).contains("domain5"));
        vHostItem = new VHostItemImpl();
        vHostItem.setExtensionManager(this.vHostItemExtensionManager);
        Element el = new Element("vhost", new String[]{"hostname", "domain-filter", "domain-filter-domains"}, new String[]{"domain3", "ALL", "domain1;domain2;domain3"});
        vHostItem.initFromElement(el);
        VHostItemTest.assertEquals((Object)DomainFilterPolicy.ALL, (Object)vHostItem.getDomainFilter());
        VHostItemTest.assertTrue((vHostItem.getDomainFilterDomains() == null ? 1 : 0) != 0);
        VHostItemTest.assertTrue((boolean)vHostItem.toPropertyString().contains("domain-filter=ALL"));
        vHostItem = new VHostItemImpl();
        vHostItem.setExtensionManager(this.vHostItemExtensionManager);
        el = new Element("vhost", new String[]{"hostname", "domain-filter", "domain-filter-domains"}, new String[]{"domain3", "BLACKLIST", "domain1;domain2;domain3"});
        vHostItem.initFromElement(el);
        VHostItemTest.assertEquals((Object)DomainFilterPolicy.BLACKLIST, (Object)vHostItem.getDomainFilter());
        VHostItemTest.assertTrue((boolean)Arrays.asList(vHostItem.getDomainFilterDomains()).contains("domain1"));
        VHostItemTest.assertTrue((boolean)Arrays.asList(vHostItem.getDomainFilterDomains()).contains("domain3"));
        VHostItemTest.assertFalse((boolean)Arrays.asList(vHostItem.getDomainFilterDomains()).contains("domain5"));
        VHostItemTest.assertTrue((boolean)vHostItem.toPropertyString().contains("domain-filter=BLACKLIST"));
        vHostItem = new VHostItemImpl();
        vHostItem.setExtensionManager(this.vHostItemExtensionManager);
        el = new Element("vhost", new String[]{"hostname", "domain-filter", "domain-filter-domains"}, new String[]{"domain3", "CUSTOM", "4,deny,all;1,allow,self;3,allow,jid,pubsub@test.com;2,allow,jid,admin@test2.com"});
        vHostItem.initFromElement(el);
        VHostItemTest.assertEquals((Object)DomainFilterPolicy.CUSTOM, (Object)vHostItem.getDomainFilter());
        VHostItemTest.assertTrue((boolean)vHostItem.toPropertyString().contains("domain-filter=CUSTOM=4,deny,all;1,allow,self;3,allow,jid,pubsub@test.com;2,allow,jid,admin@test2.com"));
        vHostItem = new VHostItemImpl();
        vHostItem.setExtensionManager(this.vHostItemExtensionManager);
        vHostItem.initFromPropertyString("domain1:domain-filter=CUSTOM=4|deny|all;1|allow|self;3|allow|jid|pubsub@test.com;2|allow|jid|admin@test2.com");
        VHostItemTest.assertEquals((Object)DomainFilterPolicy.CUSTOM, (Object)vHostItem.getDomainFilter());
        String toPropertyString = vHostItem.toPropertyString();
        log.log(Level.FINE, "to property string: " + toPropertyString);
        VHostItemTest.assertTrue((String)"different", (boolean)toPropertyString.contains("domain-filter=CUSTOM=4|deny|all;1|allow|self;3|allow|jid|pubsub@test.com;2|allow|jid|admin@test2.com"));
    }

    public void testInitFromPropertyString() throws TigaseStringprepException, IllegalAccessException, NoSuchFieldException {
        JID jid = JID.jidInstanceNS((String)"comp1@example.com");
        JID notTrusted = JID.jidInstanceNS((String)"not-trusted@example.com");
        VHostItemImpl item = new VHostItemImpl();
        item.setExtensionManager(this.vHostItemExtensionManager);
        item.toString();
        Assert.assertTrue((boolean)item.getTrustedJIDs().isEmpty());
        Assert.assertFalse((boolean)item.isTrustedJID(jid));
        item.initFromPropertyString("example.com:trusted-jids=comp1@example.com");
        Assert.assertArrayEquals((Object[])new String[]{jid.toString()}, (Object[])Optional.ofNullable(item.getTrustedJIDs()).map(it -> it.toArray(new String[0])).orElse(new String[0]));
        Assert.assertTrue((boolean)item.isTrustedJID(jid));
        Assert.assertTrue((boolean)item.isTrustedJID(jid.copyWithResource("test")));
        Assert.assertFalse((boolean)item.isTrustedJID(notTrusted));
        item = new VHostItemImpl();
        item.setExtensionManager(this.vHostItemExtensionManager);
        item.initFromPropertyString("example.com:trusted-jids=comp1@example.com,comp2@example.com");
        Assert.assertArrayEquals((Object[])new String[]{jid.toString(), "comp2@example.com"}, (Object[])item.getTrustedJIDs().stream().sorted().toArray(String[]::new));
        Assert.assertTrue((boolean)item.isTrustedJID(jid));
        Assert.assertTrue((boolean)item.isTrustedJID(jid.copyWithResource("test")));
        Assert.assertFalse((boolean)item.isTrustedJID(notTrusted));
        item = new VHostItemImpl();
        item.setExtensionManager(this.vHostItemExtensionManager);
        item.initFromPropertyString("example.com:trusted-jids=comp1@example.com;comp2@example.com");
        Assert.assertArrayEquals((Object[])new String[]{jid.toString(), "comp2@example.com"}, (Object[])item.getTrustedJIDs().stream().sorted().toArray(String[]::new));
        Assert.assertTrue((boolean)item.isTrustedJID(jid));
        Assert.assertTrue((boolean)item.isTrustedJID(jid.copyWithResource("test")));
        Assert.assertFalse((boolean)item.isTrustedJID(notTrusted));
        item = new VHostItemImpl();
        item.setExtensionManager(this.vHostItemExtensionManager);
        item.toString();
        item.initFromPropertyString("example.com:trusted-jids=example.com");
        item.toString();
        Assert.assertArrayEquals((Object[])new String[]{"example.com"}, (Object[])item.getTrustedJIDs().toArray(new String[0]));
        Assert.assertTrue((boolean)item.isTrustedJID(jid));
        Assert.assertTrue((boolean)item.isTrustedJID(jid.copyWithResource("test")));
        Assert.assertTrue((boolean)item.isTrustedJID(notTrusted));
        VHostItemDefaults defaults = new VHostItemDefaults();
        Field f = VHostItemDefaults.class.getDeclaredField("trusted");
        f.setAccessible(true);
        f.set(defaults, new ConcurrentSkipListSet());
        defaults.getTrusted().add("comp3@example.com");
        defaults.getTrusted().add("comp4@example.com");
        item = new VHostItemImpl();
        item.setExtensionManager(this.vHostItemExtensionManager);
        item.initializeFromDefaults(defaults);
        item.toString();
        Assert.assertArrayEquals((Object[])new String[]{"comp3@example.com", "comp4@example.com"}, (Object[])item.getTrustedJIDs().stream().sorted().toArray(String[]::new));
        Assert.assertTrue((boolean)item.isTrustedJID(JID.jidInstanceNS((String)"comp3@example.com")));
        Assert.assertTrue((boolean)item.isTrustedJID(JID.jidInstanceNS((String)"comp3@example.com").copyWithResource("test")));
        Assert.assertFalse((boolean)item.isTrustedJID(notTrusted));
        item.initFromPropertyString("example.com:trusted-jids=comp1@example.com;comp2@example.com");
        Assert.assertArrayEquals((Object[])new String[]{jid.toString(), "comp2@example.com"}, (Object[])item.getTrustedJIDs().stream().sorted().toArray(String[]::new));
        Assert.assertTrue((boolean)item.isTrustedJID(jid));
        Assert.assertTrue((boolean)item.isTrustedJID(jid.copyWithResource("test")));
        Assert.assertFalse((boolean)item.isTrustedJID(notTrusted));
        Assert.assertFalse((boolean)item.isTrustedJID(JID.jidInstanceNS((String)"comp3@example.com")));
    }
}

