/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import junit.framework.TestCase;
import org.junit.Test;
import tigase.cluster.ClusterConnection;
import tigase.cluster.ClusterConnectionSelector;
import tigase.cluster.api.ClusterConnectionHandler;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xmpp.XMPPIOService;

public class ClusterConnectionSelectorTest
extends TestCase {
    @Test
    public void testSelectConnection() throws Exception {
        ClusterConnection conn = new ClusterConnection("test");
        ClusterConnectionSelector selector = new ClusterConnectionSelector();
        selector.setClusterConnectionHandler(new ClusterConnectionHandler(this){

            public int hashCodeForPacket(Packet packet) {
                return packet.getStanzaFrom().hashCode();
            }
        });
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        props.put("cluster-sys-connections-per-node", 1);
        selector.setProperties(props);
        Element el = new Element("iq", new String[]{"from"}, new String[]{"test1"});
        Packet p = Packet.packetInstance((Element)el);
        ClusterConnectionSelectorTest.assertNull((Object)selector.selectConnection(p, conn));
        XMPPIOService serv1 = new XMPPIOService();
        conn.addConn(serv1);
        ClusterConnectionSelectorTest.assertEquals((Object)serv1, (Object)selector.selectConnection(p, conn));
        p.setPriority(Priority.SYSTEM);
        ClusterConnectionSelectorTest.assertEquals((Object)serv1, (Object)selector.selectConnection(p, conn));
        p.setPriority(null);
        XMPPIOService serv2 = new XMPPIOService();
        conn.addConn(serv2);
        ClusterConnectionSelectorTest.assertEquals((int)2, (int)conn.size());
        ClusterConnectionSelectorTest.assertEquals((Object)serv2, (Object)selector.selectConnection(p, conn));
        p.setPriority(Priority.SYSTEM);
        ClusterConnectionSelectorTest.assertEquals((Object)serv1, (Object)selector.selectConnection(p, conn));
        p.setPriority(null);
        XMPPIOService serv3 = new XMPPIOService();
        conn.addConn(serv3);
        ClusterConnectionSelectorTest.assertEquals((int)3, (int)conn.size());
        ClusterConnectionSelectorTest.assertNotSame((Object)serv1, (Object)selector.selectConnection(p, conn));
        p.setPriority(Priority.SYSTEM);
        ClusterConnectionSelectorTest.assertEquals((Object)serv1, (Object)selector.selectConnection(p, conn));
        el = new Element("iq", new String[]{"from"}, new String[]{"test2"});
        p = Packet.packetInstance((Element)el);
        ClusterConnectionSelectorTest.assertEquals((int)3, (int)conn.size());
        ClusterConnectionSelectorTest.assertNotSame((Object)serv1, (Object)selector.selectConnection(p, conn));
        el = new Element("iq", new String[]{"from"}, new String[]{"test3"});
        p = Packet.packetInstance((Element)el);
        ClusterConnectionSelectorTest.assertEquals((int)3, (int)conn.size());
        ClusterConnectionSelectorTest.assertNotSame((Object)serv1, (Object)selector.selectConnection(p, conn));
        el = new Element("iq", new String[]{"from"}, new String[]{"test4"});
        p = Packet.packetInstance((Element)el);
        ClusterConnectionSelectorTest.assertEquals((int)3, (int)conn.size());
        ClusterConnectionSelectorTest.assertNotSame((Object)serv1, (Object)selector.selectConnection(p, conn));
    }

    @Test
    public void testSelectConnectionFor2() throws Exception {
        ClusterConnection conn = new ClusterConnection("test");
        ClusterConnectionSelector selector = new ClusterConnectionSelector();
        selector.setClusterConnectionHandler(new ClusterConnectionHandler(this){

            public int hashCodeForPacket(Packet packet) {
                return packet.getStanzaFrom().hashCode();
            }
        });
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        props.put("cluster-sys-connections-per-node", 2);
        selector.setProperties(props);
        Element el = new Element("iq", new String[]{"from"}, new String[]{"test1"});
        Packet p = Packet.packetInstance((Element)el);
        ClusterConnectionSelectorTest.assertNull((Object)selector.selectConnection(p, conn));
        XMPPIOService serv1 = new XMPPIOService();
        conn.addConn(serv1);
        ClusterConnectionSelectorTest.assertEquals((Object)serv1, (Object)selector.selectConnection(p, conn));
        p.setPriority(Priority.SYSTEM);
        ClusterConnectionSelectorTest.assertEquals((Object)serv1, (Object)selector.selectConnection(p, conn));
        p.setPriority(null);
        XMPPIOService serv2 = new XMPPIOService();
        conn.addConn(serv2);
        HashSet<XMPPIOService> sysServs = new HashSet<XMPPIOService>(Arrays.asList(serv1, serv2));
        ClusterConnectionSelectorTest.assertEquals((int)2, (int)conn.size());
        ClusterConnectionSelectorTest.assertTrue((boolean)sysServs.contains(selector.selectConnection(p, conn)));
        p.setPriority(Priority.SYSTEM);
        ClusterConnectionSelectorTest.assertTrue((boolean)sysServs.contains(selector.selectConnection(p, conn)));
        p.setPriority(null);
        XMPPIOService serv3 = new XMPPIOService();
        conn.addConn(serv3);
        ClusterConnectionSelectorTest.assertEquals((int)3, (int)conn.size());
        ClusterConnectionSelectorTest.assertSame((Object)serv3, (Object)selector.selectConnection(p, conn));
        p.setPriority(Priority.SYSTEM);
        ClusterConnectionSelectorTest.assertTrue((boolean)sysServs.contains(selector.selectConnection(p, conn)));
        el = new Element("iq", new String[]{"from"}, new String[]{"test2"});
        p = Packet.packetInstance((Element)el);
        ClusterConnectionSelectorTest.assertEquals((int)3, (int)conn.size());
        ClusterConnectionSelectorTest.assertSame((Object)serv3, (Object)selector.selectConnection(p, conn));
        el = new Element("iq", new String[]{"from"}, new String[]{"test3"});
        p = Packet.packetInstance((Element)el);
        ClusterConnectionSelectorTest.assertEquals((int)3, (int)conn.size());
        ClusterConnectionSelectorTest.assertSame((Object)serv3, (Object)selector.selectConnection(p, conn));
        el = new Element("iq", new String[]{"from"}, new String[]{"test4"});
        p = Packet.packetInstance((Element)el);
        ClusterConnectionSelectorTest.assertEquals((int)3, (int)conn.size());
        ClusterConnectionSelectorTest.assertSame((Object)serv3, (Object)selector.selectConnection(p, conn));
    }
}

