/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import tigase.TestLogger;
import tigase.auth.callbacks.AuthorizationIdCallback;
import tigase.auth.callbacks.ReplaceServerKeyCallback;
import tigase.auth.callbacks.ServerKeyCallback;
import tigase.auth.callbacks.SharedSecretKeyCallback;
import tigase.auth.mechanisms.SaslSCRAMTest;
import tigase.auth.mechanisms.SaslXTOKEN;
import tigase.xmpp.jid.BareJID;

@RunWith(value=Parameterized.class)
public class SaslXTOKENTest
extends TestCase {
    private static final Logger log = TestLogger.getLogger(SaslSCRAMTest.class);
    private byte[] serverKey;
    private byte[] newServerKey;
    private final SecureRandom random = new SecureRandom();
    private SaslXTOKEN sasl;
    private final byte[] sharedKey;
    private final boolean printTestVectors = false;

    public SaslXTOKENTest(byte[] sharedKey) {
        this.sharedKey = sharedKey;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        byte[] sharedKey = new byte[32];
        SecureRandom random = new SecureRandom();
        random.nextBytes(sharedKey);
        return Arrays.asList({null}, {sharedKey});
    }

    @Before
    public void setUp() {
        this.serverKey = new byte[32];
        this.random.nextBytes(this.serverKey);
        HashMap props = new HashMap();
        CallbackHandler callbackHandler = new CallbackHandler(){
            private String username;

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        BareJID jid = BareJID.bareJIDInstanceNS((String)((NameCallback)callback).getDefaultName());
                        if (jid.getLocalpart() == null || !"domain.com".equalsIgnoreCase(jid.getDomain())) {
                            jid = BareJID.bareJIDInstanceNS((String)((NameCallback)callback).getDefaultName(), (String)"domain.com");
                        }
                        this.username = jid.toString();
                        ((NameCallback)callback).setName(this.username);
                        continue;
                    }
                    if (callback instanceof ServerKeyCallback) {
                        ((ServerKeyCallback)callback).setServerKey(SaslXTOKENTest.this.serverKey);
                        continue;
                    }
                    if (callback instanceof AuthorizationIdCallback) continue;
                    if (callback instanceof AuthorizeCallback) {
                        boolean a = ((AuthorizeCallback)callback).getAuthorizationID().equals(((AuthorizeCallback)callback).getAuthenticationID());
                        ((AuthorizeCallback)callback).setAuthorized(a);
                        if (!a) continue;
                        ((AuthorizeCallback)callback).setAuthorizedID(((AuthorizeCallback)callback).getAuthorizationID());
                        continue;
                    }
                    if (callback instanceof ReplaceServerKeyCallback) {
                        ((ReplaceServerKeyCallback)callback).setNewServerKey(SaslXTOKENTest.this.newServerKey);
                        continue;
                    }
                    if (callback instanceof SharedSecretKeyCallback) {
                        ((SharedSecretKeyCallback)callback).setSecret(SaslXTOKENTest.this.sharedKey);
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        };
        this.sasl = new SaslXTOKEN(props, callbackHandler);
    }

    @Test
    public void testEmptyToken() {
        try {
            this.sasl.evaluateResponse(new byte[0]);
            SaslXTOKENTest.fail((String)"Exception must be thrown");
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        SaslXTOKENTest.assertFalse((boolean)this.sasl.isComplete());
    }

    @Test
    public void testValidToken() throws InvalidKeyException, NoSuchAlgorithmException {
        this.newServerKey = null;
        byte[] data = new byte[32];
        this.random.nextBytes(data);
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(this.serverKey, "SHA-256"));
        mac.update(data);
        if (this.sharedKey != null) {
            mac.update(this.sharedKey);
        }
        byte[] token = mac.doFinal();
        try {
            byte[] jid = "test@domain.com".getBytes(StandardCharsets.UTF_8);
            byte[] response = new byte[data.length + 1 + token.length + 1 + jid.length];
            System.arraycopy(data, 0, response, 0, 32);
            System.arraycopy(token, 0, response, 33, 32);
            System.arraycopy(jid, 0, response, 66, jid.length);
            byte[] finish = this.sasl.evaluateResponse(response);
            Assert.assertArrayEquals((byte[])jid, (byte[])finish);
        }
        catch (SaslException e) {
            e.printStackTrace();
            SaslXTOKENTest.fail((String)"Exception must not be thrown");
        }
        SaslXTOKENTest.assertTrue((boolean)this.sasl.isComplete());
    }

    @Test
    public void testValidTokenWithNewKey() throws InvalidKeyException, NoSuchAlgorithmException {
        this.newServerKey = new byte[32];
        this.random.nextBytes(this.newServerKey);
        byte[] data = new byte[32];
        this.random.nextBytes(data);
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(this.serverKey, "SHA-256"));
        mac.update(data);
        if (this.sharedKey != null) {
            mac.update(this.sharedKey);
        }
        byte[] token = mac.doFinal();
        try {
            byte[] jid = "test@domain.com".getBytes(StandardCharsets.UTF_8);
            byte[] response = new byte[data.length + 1 + token.length + 1 + jid.length];
            System.arraycopy(data, 0, response, 0, 32);
            System.arraycopy(token, 0, response, 33, 32);
            System.arraycopy(jid, 0, response, 66, jid.length);
            byte[] finish = this.sasl.evaluateResponse(response);
            byte[] exp = new byte[jid.length + 1 + this.newServerKey.length];
            System.arraycopy(jid, 0, exp, 0, jid.length);
            System.arraycopy(this.newServerKey, 0, exp, jid.length + 1, this.newServerKey.length);
            Assert.assertArrayEquals((byte[])exp, (byte[])finish);
            this.print(jid, this.serverKey, response, finish, this.newServerKey);
            this.serverKey = this.newServerKey;
            this.newServerKey = null;
            mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(this.serverKey, "SHA-256"));
            mac.update(data);
            if (this.sharedKey != null) {
                mac.update(this.sharedKey);
            }
            token = mac.doFinal();
            response = new byte[data.length + 1 + token.length + 1 + jid.length];
            System.arraycopy(data, 0, response, 0, 32);
            System.arraycopy(token, 0, response, 33, 32);
            System.arraycopy(jid, 0, response, 66, jid.length);
            finish = this.sasl.evaluateResponse(response);
            Assert.assertArrayEquals((byte[])jid, (byte[])finish);
            this.print(jid, this.serverKey, response, finish, this.newServerKey);
        }
        catch (SaslException e) {
            e.printStackTrace();
            SaslXTOKENTest.fail((String)"Exception must not be thrown");
        }
        SaslXTOKENTest.assertTrue((boolean)this.sasl.isComplete());
    }

    private void print(byte[] jid, byte[] serverKey, byte[] clientSaslRequest, byte[] serverSaslResponse, byte[] newServerKey) {
    }
}

