/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Queue;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.auth.BruteForceLockerBean;
import tigase.auth.TigaseSaslProvider;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.impl.SaslAuth;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class SaslAuthTest
extends ProcessorTestCase {
    private SaslAuth saslAuth;

    @Override
    @Before
    public void setUp() throws Exception {
        this.saslAuth = this.getInstance(SaslAuth.class);
        this.saslAuth.init(new HashMap());
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.saslAuth = null;
        super.tearDown();
    }

    @Test
    public void testAuthenticationAccountStatusPending() throws Exception {
        AuthRepository.AccountStatus accountStatus = AuthRepository.AccountStatus.pending;
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        XMPPResourceConnection session = this.authenticateSession(accountStatus, results);
        Assert.assertFalse((boolean)session.isAuthorized());
        Packet result = (Packet)results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"failure", (Object)result.getElemName());
    }

    @Test
    public void testAuthenticationAccountStatusDisabled() throws Exception {
        AuthRepository.AccountStatus accountStatus = AuthRepository.AccountStatus.disabled;
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        XMPPResourceConnection session = this.authenticateSession(accountStatus, results);
        Assert.assertFalse((boolean)session.isAuthorized());
        Packet result = (Packet)results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"failure", (Object)result.getElemName());
    }

    @Test
    public void testAuthenticationAccountStatusSystem() throws Exception {
        AuthRepository.AccountStatus accountStatus = AuthRepository.AccountStatus.system;
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        XMPPResourceConnection session = this.authenticateSession(accountStatus, results);
        Assert.assertFalse((boolean)session.isAuthorized());
        Packet result = (Packet)results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"failure", (Object)result.getElemName());
    }

    @Test
    public void testAuthenticationAccountStatusActive() throws Exception {
        AuthRepository.AccountStatus accountStatus = AuthRepository.AccountStatus.active;
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        XMPPResourceConnection session = this.authenticateSession(accountStatus, results);
        Assert.assertTrue((boolean)session.isAuthorized());
        Packet result = (Packet)results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"success", (Object)result.getElemName());
    }

    @Test
    public void testAuthenticationAccountStatusPaid() throws Exception {
        AuthRepository.AccountStatus accountStatus = AuthRepository.AccountStatus.paid;
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        XMPPResourceConnection session = this.authenticateSession(accountStatus, results);
        Assert.assertTrue((boolean)session.isAuthorized());
        Packet result = (Packet)results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"success", (Object)result.getElemName());
    }

    @Test
    public void testAuthenticationAccountStatusVip() throws Exception {
        AuthRepository.AccountStatus accountStatus = AuthRepository.AccountStatus.vip;
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        XMPPResourceConnection session = this.authenticateSession(accountStatus, results);
        Assert.assertTrue((boolean)session.isAuthorized());
        Packet result = (Packet)results.poll();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"success", (Object)result.getElemName());
    }

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean("eventbus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean("sess-man").asInstance((Object)new SessionManager()).setActive(true).exportable().exec();
        kernel.registerBean(BruteForceLockerBean.class).setActive(true).exportable().exec();
        kernel.registerBean(TigaseSaslProvider.class).setActive(true).exportable().exec();
        kernel.registerBean(SaslAuth.class).setActive(true).exportable().exec();
    }

    private XMPPResourceConnection authenticateSession(AuthRepository.AccountStatus accountStatus, Queue<Packet> results) throws TigaseDBException, TigaseStringprepException, NotAuthorizedException {
        BareJID user = BareJID.bareJIDInstanceNS((String)"user@example.com");
        this.getUserRepository().addUser(user);
        this.getAuthRepository().updateCredential(user, null, "password");
        this.getAuthRepository().setAccountStatus(user, accountStatus);
        JID res = JID.jidInstance((BareJID)user, (String)"res");
        XMPPResourceConnection session = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), res, false);
        session.putSessionData("allowed-sasl-mechanisms", Collections.singletonList("PLAIN"));
        Packet packet = this.getPlainSaslPacket();
        this.saslAuth.process(packet, session, null, results, null);
        return session;
    }

    private Packet getPlainSaslPacket() throws TigaseStringprepException {
        Element packetEl = new Element("auth", new String[]{"xmlns", "mechanism"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl", "PLAIN"});
        byte[] bytes = "\u0000user\u0000password".getBytes();
        packetEl.setCData(Base64.encode((byte[])bytes));
        Packet packet = Packet.packetInstance((Element)packetEl);
        return packet;
    }
}

