/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;
import tigase.db.TigaseDBException;
import tigase.kernel.BeanUtils;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.DependencyManager;
import tigase.xmpp.impl.JabberIqRegister;
import tigase.xmpp.jid.JID;

public class JabberIqRegisterWhitelistTest
extends TestCase {
    private static final String CONNECTION_ID = JabberIqRegisterWhitelistTest.connectionId("127.0.0.2");

    private static final String connectionId(String remoteAddress) {
        return "c2s@0123456789/127.0.0.1_5222_" + remoteAddress + "_50123";
    }

    @Test
    public void testRegistrationAllowedDefaultSettings() throws Exception {
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        JabberIqRegisterWhitelistTest.assertTrue((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)CONNECTION_ID)));
    }

    @Test
    public void testRegistrationAllowedNotInBlacklist() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("registration-blacklist", "127.0.0.3,127.0.0.4");
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        jabberIqRegister.init(settings);
        JabberIqRegisterWhitelistTest.assertTrue((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)CONNECTION_ID)));
    }

    @Test
    public void testRegistrationAllowedInWhitelist() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("whitelist-registration-only", Boolean.TRUE.toString());
        settings.put("registration-whitelist", "127.0.0.2,127.0.0.3");
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        jabberIqRegister.init(settings);
        JabberIqRegisterWhitelistTest.assertTrue((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)CONNECTION_ID)));
    }

    @Test
    public void testRegistrationAllowedInCIDRWhitelist() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("whitelist-registration-only", Boolean.TRUE.toString());
        settings.put("registration-whitelist", "127.0.0.0/24");
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        jabberIqRegister.init(settings);
        JabberIqRegisterWhitelistTest.assertTrue((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)CONNECTION_ID)));
    }

    @Test
    public void testRegistrationAllowedInCIDRMultipleWhitelist() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("whitelist-registration-only", Boolean.TRUE.toString());
        settings.put("registration-whitelist", "127.0.0.0/24,127.0.0.1/24");
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        jabberIqRegister.init(settings);
        JabberIqRegisterWhitelistTest.assertTrue((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)CONNECTION_ID)));
    }

    @Test
    public void testRegistrationFromMultipleSourcesAllowedInCIDRWhitelist() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("whitelist-registration-only", Boolean.TRUE.toString());
        settings.put("registration-whitelist", "127.0.0.0/24");
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        jabberIqRegister.init(settings);
        for (int i = 0; i <= 255; ++i) {
            JabberIqRegisterWhitelistTest.assertTrue((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)JabberIqRegisterWhitelistTest.connectionId("127.0.0." + i))));
        }
    }

    @Test
    public void testRegistrationNotAllowedWhitelistOnlyEmpty() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("whitelist-registration-only", Boolean.TRUE.toString());
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        jabberIqRegister.init(settings);
        JabberIqRegisterWhitelistTest.assertFalse((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)CONNECTION_ID)));
    }

    @Test
    public void testRegistrationNotAllowedWhitelistOnly() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("whitelist-registration-only", Boolean.TRUE.toString());
        settings.put("registration-whitelist", "127.0.0.3,127.0.0.4");
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        jabberIqRegister.init(settings);
        JabberIqRegisterWhitelistTest.assertFalse((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)CONNECTION_ID)));
    }

    @Test
    public void testRegistrationNotAllowedCIDRWhitelistOnly() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("whitelist-registration-only", Boolean.TRUE.toString());
        settings.put("registration-whitelist", "127.0.0.0/24");
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        jabberIqRegister.init(settings);
        for (int i = 0; i <= 255; ++i) {
            JabberIqRegisterWhitelistTest.assertFalse((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)JabberIqRegisterWhitelistTest.connectionId("127.0.1." + i))));
        }
    }

    public void testRegistrationNotAllowedWhitelistSingle() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("whitelist-registration-only", Boolean.TRUE.toString());
        settings.put("registration-whitelist", "127.0.0.3");
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        jabberIqRegister.init(settings);
        JabberIqRegisterWhitelistTest.assertFalse((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)CONNECTION_ID)));
    }

    @Test
    public void testRegistrationNotAllowedInBlacklist() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("registration-blacklist", "127.0.0.2,127.0.0.3");
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        jabberIqRegister.init(settings);
        JabberIqRegisterWhitelistTest.assertFalse((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)CONNECTION_ID)));
    }

    @Test
    public void testRegistrationNotAllowedInBlacklistSingle() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("registration-blacklist", "127.0.0.2");
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        jabberIqRegister.init(settings);
        JabberIqRegisterWhitelistTest.assertFalse((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)CONNECTION_ID)));
    }

    @Test
    public void testRegistrationNotAllowedInCIDRBlacklist() throws Exception {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("registration-blacklist", "127.0.0.0/24");
        JabberIqRegister jabberIqRegister = new JabberIqRegister(this);
        jabberIqRegister.init(settings);
        for (int i = 0; i <= 255; ++i) {
            JabberIqRegisterWhitelistTest.assertFalse((boolean)jabberIqRegister.isRegistrationAllowedForConnection(JID.jidInstance((String)JabberIqRegisterWhitelistTest.connectionId("127.0.0." + i))));
        }
    }

    @Test
    public void testCIDR() {
        String val = "192.168.122.0/24";
        JabberIqRegister.CIDRAddress addr = JabberIqRegister.CIDRAddress.parse((String)val);
        JabberIqRegisterWhitelistTest.assertEquals((String)val, (String)addr.toString());
        val = "193.34.32.0/19";
        addr = JabberIqRegister.CIDRAddress.parse((String)val);
        JabberIqRegisterWhitelistTest.assertEquals((String)val, (String)addr.toString());
    }

    private class JabberIqRegister
    extends tigase.xmpp.impl.JabberIqRegister {
        private JabberIqRegister(JabberIqRegisterWhitelistTest jabberIqRegisterWhitelistTest) {
        }

        public void init(Map<String, Object> settings) throws TigaseDBException {
            Field[] fields;
            for (Field field : fields = DependencyManager.getAllFields(((Object)((Object)this)).getClass())) {
                ConfigField configField = field.getAnnotation(ConfigField.class);
                if (configField == null) continue;
                try {
                    LinkedList<String> value = settings.getOrDefault(field.getName(), settings.get(configField.alias()));
                    if (value == null) continue;
                    if (Boolean.TYPE.equals(field.getType())) {
                        value = Boolean.valueOf(((Object)value).toString());
                    }
                    if (LinkedList.class.equals(field.getType())) {
                        value = new LinkedList<String>(Arrays.asList(((Object)value).toString().split(",")));
                    }
                    BeanUtils.setValue((Object)((Object)this), (Field)field, (Object)value);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

