/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.HashMap;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import tigase.auth.BruteForceLockerBean;
import tigase.auth.TigaseSaslProvider;
import tigase.eventbus.EventBusFactory;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.JabberIqAuth;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.JID;

public class JabberIqAuthTest
extends ProcessorTestCase {
    @Before
    public void prepare() {
        this.getKernel().registerBean("eventbus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        this.getKernel().registerBean("sess-man").asInstance((Object)new SessionManager()).setActive(true).exportable().exec();
        this.getKernel().registerBean(BruteForceLockerBean.class).setActive(true).exportable().exec();
        this.getKernel().registerBean(TigaseSaslProvider.class).setActive(true).exportable().exec();
        this.getKernel().registerBean(JabberIqAuth.class).setActive(true).exec();
    }

    @Test
    public void testAuthMissingPassword() throws XMPPException, TigaseStringprepException {
        JID jid1 = JID.jidInstance((String)"user1@example.com/res1");
        XMPPResourceConnection session = this.getSession(jid1, jid1, false);
        Element iqElement = new Element("iq", new String[]{"xmlns", "type"}, new String[]{"jabber:client", StanzaType.set.name()});
        Element query = new Element("query", new String[]{"xmlns"}, new String[]{"jabber:iq:auth"});
        query.addChild((XMLNodeIfc)new Element("username", "abcde123"));
        query.addChild((XMLNodeIfc)new Element("password"));
        query.addChild((XMLNodeIfc)new Element("resource", "Miranda"));
        iqElement.addChild((XMLNodeIfc)query);
        Packet iq = Packet.packetInstance((Element)iqElement);
        iq.setPacketFrom(jid1);
        JabberIqAuth processor = (JabberIqAuth)this.getKernel().getInstance(JabberIqAuth.class);
        TestCase.assertEquals((Object)Authorization.AUTHORIZED, (Object)processor.canHandle(iq, session));
        LinkedList results = new LinkedList();
        processor.process(iq, session, null, results, new HashMap());
        TestCase.assertEquals((int)2, (int)results.size());
        Assert.assertNotNull((Object)((Packet)results.get(0)).getElement().getChild("error").getChild("not-acceptable"));
        TestCase.assertEquals((String)"CLOSE", (String)((Packet)results.get(1)).getElement().getChild("command").getAttributeStaticStr("node"));
    }
}

