/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import org.junit.After;
import org.junit.Before;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.DataSourceHelper;
import tigase.kernel.core.Kernel;
import tigase.xmpp.impl.AbstractProcessorWithDataSourceTestCase;

public abstract class AbstractProcessorWithDataSourceAwareTestCase<DS extends DataSource, R extends DataSourceAware>
extends AbstractProcessorWithDataSourceTestCase<DS> {
    protected R repo;

    protected abstract Class<? extends DataSourceAware> getDataSourceAwareIfc();

    @Before
    public void setupDataSourceAware() throws Exception {
        this.repo = this.prepareDataSourceAware();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.repo = null;
    }

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        try {
            Class dataSourceAwareClassForUri = DataSourceHelper.getDefaultClass(this.getDataSourceAwareIfc(), (String)uri);
            kernel.registerBean("repository").asClass(dataSourceAwareClassForUri).setActive(true).exec();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected R prepareDataSourceAware() throws Exception {
        DataSourceAware repo = this.getInstance(this.getDataSourceAwareIfc());
        try {
            repo.setDataSource(this.dataSource);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw new RepositoryException((Throwable)ex);
        }
        return (R)repo;
    }
}

