/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.junit.Test;
import tigase.xmpp.XMPPIOService;

public class XMPPIOServiceTest_Proxy
extends TestCase {
    private XMPPIOService service;
    private ServerSocketChannel serverSocket;
    private SocketChannel clientSocket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        this.service = new XMPPIOService();
        this.service.setSessionData(Map.of("type", "accept", "proxy-protocol", true));
        this.serverSocket = ServerSocketChannel.open(StandardProtocolFamily.INET);
        this.serverSocket = this.serverSocket.bind(new InetSocketAddress("localhost", 6123 + new Random().nextInt(0, 100)));
        Object lock = new Object();
        new Thread(() -> {
            try {
                SocketChannel channel = this.serverSocket.accept();
                this.service.accept(channel, Integer.valueOf(1024));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
        }).start();
        this.clientSocket = SocketChannel.open(StandardProtocolFamily.INET);
        this.clientSocket.connect(this.serverSocket.getLocalAddress());
        Object object = lock;
        synchronized (object) {
            lock.wait();
        }
        XMPPIOServiceTest_Proxy.assertTrue((boolean)this.clientSocket.isOpen());
    }

    protected void tearDown() throws Exception {
        this.serverSocket.close();
        this.clientSocket.close();
    }

    @Test
    public void testProxy1_IPv4() throws IOException, InterruptedException {
        this.clientSocket.write(ByteBuffer.wrap("PROXY TCP4 192.168.1.223 192.168.3.22 56342 5222\r\n".getBytes()));
        Thread.sleep(10L);
        this.service.processSocketData();
        XMPPIOServiceTest_Proxy.assertEquals((String)"192.168.1.223", (String)this.service.getRemoteAddress());
        XMPPIOServiceTest_Proxy.assertEquals((String)"192.168.3.22", (String)this.service.getLocalAddress());
    }

    @Test
    public void testProxy1_IPv6() throws IOException, InterruptedException {
        this.clientSocket.write(ByteBuffer.wrap("PROXY TCP4 ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff eeee:eeee:eeee:eeee:eeee:eeee:eeee:eeee 56342 5222\r\n".getBytes()));
        Thread.sleep(10L);
        this.service.processSocketData();
        XMPPIOServiceTest_Proxy.assertEquals((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff", (String)this.service.getRemoteAddress());
        XMPPIOServiceTest_Proxy.assertEquals((String)"eeee:eeee:eeee:eeee:eeee:eeee:eeee:eeee", (String)this.service.getLocalAddress());
    }

    @Test
    public void testProxy2_IPv4() throws IOException, InterruptedException {
        String proxy = "0D0A0D0A000D0A515549540A2111000CC0A800017f00000130391F90";
        byte[] data = new byte[proxy.length() / 2];
        for (int i = 0; i < proxy.length(); i += 2) {
            data[i / 2] = (byte)((Character.digit(proxy.charAt(i), 16) << 4) + Character.digit(proxy.charAt(i + 1), 16));
        }
        this.clientSocket.write(ByteBuffer.wrap(data));
        Thread.sleep(10L);
        this.service.processSocketData();
        XMPPIOServiceTest_Proxy.assertEquals((String)"192.168.0.1", (String)this.service.getRemoteAddress());
        XMPPIOServiceTest_Proxy.assertEquals((String)"127.0.0.1", (String)this.service.getLocalAddress());
    }

    @Test
    public void testProxy2_IPv6() throws IOException, InterruptedException {
        String proxy = "0D0A0D0A000D0A515549540A21210024FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE30391F90";
        byte[] data = new byte[proxy.length() / 2];
        for (int i = 0; i < proxy.length(); i += 2) {
            data[i / 2] = (byte)((Character.digit(proxy.charAt(i), 16) << 4) + Character.digit(proxy.charAt(i + 1), 16));
        }
        this.clientSocket.write(ByteBuffer.wrap(data));
        Thread.sleep(10L);
        this.service.processSocketData();
        XMPPIOServiceTest_Proxy.assertEquals((String)"ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff", (String)this.service.getRemoteAddress());
        XMPPIOServiceTest_Proxy.assertEquals((String)"eeee:eeee:eeee:eeee:eeee:eeee:eeee:eeee", (String)this.service.getLocalAddress());
    }
}

