/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.Test;
import tigase.stats.StatisticsList;
import tigase.util.historyCache.AllHistoryCache;

public class AllHistoryCacheTest {
    private boolean highMemory = false;

    @Test
    public void testReductionOnHighMemoryUsage() throws NoSuchFieldException, IllegalAccessException {
        int i;
        int limit = 20;
        final ArrayList entries = new ArrayList();
        AllHistoryCache cache = new AllHistoryCache(limit, 95){

            public synchronized void addItem(StatisticsList item) {
                super.addItem(item);
                entries.add(item);
            }

            protected boolean isHighMemoryUsage() {
                return AllHistoryCacheTest.this.highMemory;
            }
        };
        for (i = 0; i < limit + 5; ++i) {
            StatisticsList stats = new StatisticsList(Level.FINE);
            cache.addItem(stats);
        }
        Assert.assertEquals((long)20L, (long)cache.getCurrentHistory().length);
        for (i = 0; i < 5; ++i) {
            entries.remove(0);
        }
        Assert.assertArrayEquals((Object[])entries.toArray(new StatisticsList[entries.size()]), (Object[])cache.getCurrentHistory());
        this.highMemory = true;
        cache.addItem(new StatisticsList(Level.FINE));
        while (entries.size() != 10) {
            entries.remove(0);
        }
        Assert.assertEquals((long)10L, (long)cache.getCurrentHistory().length);
        Assert.assertArrayEquals((Object[])entries.toArray(new StatisticsList[entries.size()]), (Object[])cache.getCurrentHistory());
        cache.addItem(new StatisticsList(Level.FINE));
        while (entries.size() != 5) {
            entries.remove(0);
        }
        Assert.assertEquals((long)5L, (long)cache.getCurrentHistory().length);
        Assert.assertArrayEquals((Object[])entries.toArray(new StatisticsList[entries.size()]), (Object[])cache.getCurrentHistory());
        this.highMemory = false;
        cache.addItem(new StatisticsList(Level.FINE));
        Assert.assertEquals((long)6L, (long)cache.getCurrentHistory().length);
        Assert.assertArrayEquals((Object[])entries.toArray(new StatisticsList[entries.size()]), (Object[])cache.getCurrentHistory());
        this.highMemory = true;
        cache.addItem(new StatisticsList(Level.FINE));
        while (entries.size() != 5) {
            entries.remove(0);
        }
        Assert.assertEquals((long)5L, (long)cache.getCurrentHistory().length);
        Assert.assertArrayEquals((Object[])entries.toArray(new StatisticsList[entries.size()]), (Object[])cache.getCurrentHistory());
        Field f = AllHistoryCache.class.getDeclaredField("buffer");
        f.setAccessible(true);
        Object arr = f.get(cache);
        int count = 0;
        for (int i2 = 0; i2 < limit; ++i2) {
            if (Array.get(arr, i2) == null) continue;
            ++count;
        }
        Assert.assertEquals((long)5L, (long)count);
    }
}

