/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import tigase.TestLogger;
import tigase.server.xmppserver.SSLTestAbstract;

@Ignore
public class SSLSocketDirectTest
extends SSLTestAbstract {
    static String hostname = "wojtek-local.tigase.eu";
    static int port = 5269;

    private static void reopenStream(SSLSocket socket) throws IOException, InterruptedException {
        BufferedInputStream is = new BufferedInputStream(socket.getInputStream());
        BufferedOutputStream os = new BufferedOutputStream(socket.getOutputStream());
        PrintWriter writer = new PrintWriter(os, true);
        writer.println("<stream:stream xmlns:stream='http://etherx.jabber.org/streams'  xmlns:xml='http://www.w3.org/XML/1998/namespace' xmlns='jabber:client'  to='" + hostname + "' version='1.0'>");
    }

    @BeforeClass
    public static void setup() {
        SSLSocketDirectTest.getSslDebugString().ifPresent(debug -> System.setProperty("javax.net.debug", debug));
        log = Logger.getLogger("tigase");
        TestLogger.configureLogger(log, Level.INFO);
        hostname = System.getProperty("test-hostname");
        String portProperty = System.getProperty("test-port");
        try {
            port = Integer.parseInt(portProperty);
        }
        catch (NumberFormatException e) {
            log.log(Level.INFO, () -> "parsing portProperty: " + portProperty + " failed");
        }
    }

    public static void testSSLSocketConnection(String[] protocols) {
        try (SSLSocket socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(hostname, port);){
            if (protocols != null) {
                socket.setEnabledProtocols(protocols);
            }
            log.log(Level.INFO, () -> "Socket enabled protocols: " + Arrays.toString(socket.getEnabledProtocols()));
            socket.addHandshakeCompletedListener(event -> log.log(Level.INFO, "Connected using: " + event.getSession().getProtocol() + ", with cipher: " + event.getCipherSuite() + ", enabled protocols: " + Arrays.toString(event.getSocket().getEnabledProtocols())));
            socket.startHandshake();
            Assert.assertTrue((boolean)socket.isConnected());
            SSLSocketDirectTest.reopenStream(socket);
        }
        catch (Exception e) {
            Assert.fail((String)("exception: " + String.valueOf(e)));
        }
    }

    @Test
    public void testSSLSocketConnection_defaults() {
        SSLSocketDirectTest.testSSLSocketConnection(null);
    }

    @Test
    public void testSSLSocketConnection_TLS13_only() {
        SSLSocketDirectTest.testSSLSocketConnection(new String[]{"TLSv1.3"});
    }

    @Test
    public void testSSLSocketConnection_default_w_TLS13_w_SSLv2Hello() {
        SSLSocketDirectTest.testSSLSocketConnection(new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1", "SSLv2Hello"});
    }

    @Test
    public void testSSLSocketConnection_default_w_TLS13_wo_SSLv2Hello() {
        SSLSocketDirectTest.testSSLSocketConnection(new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1"});
    }

    @Test
    public void testSSLSocketConnection_default_wo_TLS13_w_SSLv2Hello() {
        SSLSocketDirectTest.testSSLSocketConnection(new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv2Hello"});
    }
}

