/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.websocket;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;
import tigase.server.websocket.WebSocketProtocolIfc;
import tigase.server.websocket.WebSocketXMPPIOService;

public class WebSocketXMPPIOServiceTest
extends TestCase {
    private HashMap<String, String> headers;
    private WebSocketXMPPIOService service;

    @Test
    public void testHttpHeadersParsingWithSpaces() throws UnsupportedEncodingException {
        byte[] data = this.prepareHTTPRequest(this.headers, true);
        HashMap<String, String> parsedHeaders = new HashMap<String, String>();
        this.service.parseHttpHeaders(data, parsedHeaders);
        this.assertMaps(this.prepareExpectedParsedHeaders(this.headers), parsedHeaders);
    }

    @Test
    public void testHttpHeadersParsingWithoutSpaces() throws UnsupportedEncodingException {
        byte[] data = this.prepareHTTPRequest(this.headers, false);
        HashMap<String, String> parsedHeaders = new HashMap<String, String>();
        this.service.parseHttpHeaders(data, parsedHeaders);
        this.assertMaps(this.prepareExpectedParsedHeaders(this.headers), parsedHeaders);
    }

    protected void setUp() throws Exception {
        this.service = new WebSocketXMPPIOService(new WebSocketProtocolIfc[0]);
        this.headers = new HashMap();
        this.headers.put("Connection", "Upgrade");
        this.headers.put("Host", "test.example.com:5291");
        this.headers.put("Origin", "test.example.com:5291");
        this.headers.put("Sec-WebSocket-Key", "JRqGsrthbnle6zl8sFQPpQ==");
        this.headers.put("Sec-WebSocket-Protocol", "xmpp");
        this.headers.put("Sec-WebSocket-Version", "13");
        this.headers.put("Upgrade", "websocket");
    }

    protected void tearDown() throws Exception {
        this.service = null;
    }

    private void assertMaps(Map<String, String> expected, Map<String, String> actual) {
        ArrayList<String> expectedKeys = new ArrayList<String>(expected.keySet());
        ArrayList<String> actualKeys = new ArrayList<String>(actual.keySet());
        Collections.sort(expectedKeys);
        Collections.sort(actualKeys);
        WebSocketXMPPIOServiceTest.assertEquals(expectedKeys, actualKeys);
        for (String key : expectedKeys) {
            WebSocketXMPPIOServiceTest.assertEquals((String)expected.get(key), (String)actual.get(key));
        }
    }

    private byte[] prepareHTTPRequest(Map<String, String> headers, boolean useSpaces) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder("GET HTTP/1.1\r\n");
        for (Map.Entry<String, String> e : headers.entrySet()) {
            sb.append(e.getKey());
            sb.append(':');
            if (useSpaces) {
                sb.append(' ');
            }
            sb.append(e.getValue()).append("\r\n");
        }
        sb.append("\r\n");
        return sb.toString().getBytes("UTF-8");
    }

    private Map<String, String> prepareExpectedParsedHeaders(Map<String, String> headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> e : headers.entrySet()) {
            result.put(e.getKey().toUpperCase(), e.getValue());
        }
        return result;
    }
}

