/*
 * Decompiled with CFR 0.152.
 */
package tigase.map;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import tigase.map.DMap;

public class DMapTest {
    @Test
    public void testBasicOperations() {
        final HashSet removedItems = new HashSet();
        final HashMap addedItems = new HashMap();
        final boolean[] cleared = new boolean[]{false};
        DMap.DMapListener listener = new DMap.DMapListener(){

            public void onClear(DMap map) {
                cleared[0] = true;
            }

            public void onPut(DMap map, Object key, Object value) {
                Assert.assertNull((Object)addedItems.put((String)key, (String)value));
            }

            public void onPutAll(DMap map, Map m) {
                addedItems.putAll(m);
            }

            public void onRemove(DMap map, Object key) {
                Assert.assertTrue((boolean)removedItems.add((String)key));
            }
        };
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("7", "seven");
        tmp.put("8", "eight");
        tmp.put("9", "nine");
        tmp.put("A", "ten");
        DMap map = new DMap("test", listener, String.class, String.class);
        map.put("1", "one");
        map.put("2", "two");
        map.put("3", "three");
        map.put("4", "four");
        map.put("5", "five");
        map.put("6", "six");
        Assert.assertEquals((long)6L, (long)map.size());
        Assert.assertEquals((long)map.size(), (long)addedItems.size());
        Assert.assertTrue((map.values().containsAll(addedItems.values()) && addedItems.values().containsAll(map.values()) ? 1 : 0) != 0);
        map.putAll(tmp);
        Assert.assertEquals((long)10L, (long)map.size());
        Assert.assertTrue((boolean)map.values().containsAll(addedItems.values()));
        Assert.assertTrue((boolean)addedItems.values().containsAll(map.values()));
        map.remove("1");
        map.remove("2");
        Assert.assertEquals((long)8L, (long)map.size());
        Assert.assertEquals((long)2L, (long)removedItems.size());
        try {
            Iterator itK = map.keySet().iterator();
            String elK = (String)itK.next();
            itK.remove();
            Assert.fail((String)"Should be blocked!");
        }
        catch (UnsupportedOperationException itK) {
            // empty catch block
        }
        Assert.assertEquals((long)8L, (long)map.size());
        Assert.assertEquals((long)2L, (long)removedItems.size());
        try {
            Iterator itE = map.entrySet().iterator();
            Map.Entry elE = itE.next();
            itE.remove();
            Assert.fail((String)"Should be blocked!");
        }
        catch (UnsupportedOperationException itE) {
            // empty catch block
        }
        Assert.assertEquals((long)8L, (long)map.size());
        Assert.assertEquals((long)2L, (long)removedItems.size());
        try {
            Iterator itV = map.values().iterator();
            String elV = (String)itV.next();
            itV.remove();
            Assert.fail((String)"Should be blocked!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((long)8L, (long)map.size());
        Assert.assertEquals((long)2L, (long)removedItems.size());
        Assert.assertFalse((boolean)cleared[0]);
        map.clear();
        Assert.assertTrue((boolean)cleared[0]);
        Assert.assertEquals((long)0L, (long)map.size());
    }
}

