/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import tigase.io.SSLContextContainer;
import tigase.io.SSLContextContainerAbstract;

public class SSLContextContainerTest {
    @Test
    public void testFind() {
        HashMap<String, String> domains = new HashMap<String, String>();
        domains.put("one.com", "one.com");
        domains.put("a.two.com", "a.two.com");
        domains.put("*.two.com", "*.two.com");
        Assert.assertEquals((Object)"one.com", (Object)SSLContextContainer.find(domains, (String)"one.com"));
        Assert.assertNull((Object)SSLContextContainer.find(domains, (String)"tone.com"));
        Assert.assertNull((Object)SSLContextContainer.find(domains, (String)"zero.com"));
        Assert.assertEquals((Object)"a.two.com", (Object)SSLContextContainer.find(domains, (String)"a.two.com"));
        Assert.assertEquals((Object)"*.two.com", (Object)SSLContextContainer.find(domains, (String)"b.two.com"));
        Assert.assertEquals((Object)"*.two.com", (Object)SSLContextContainer.find(domains, (String)"b.two.com"));
        Assert.assertNull((Object)SSLContextContainer.find(domains, (String)"btwo.com"));
        Assert.assertEquals((Object)"*.two.com", (Object)SSLContextContainer.find(domains, (String)".two.com"));
    }

    @Test
    public void testFindMuc() {
        HashMap<String, String> domains = new HashMap<String, String>();
        domains.put("*.tigase.org", "*.tigase.org");
        Assert.assertEquals((Object)"*.tigase.org", (Object)SSLContextContainer.find(domains, (String)"tigase.org"));
        Assert.assertEquals((Object)"*.tigase.org", (Object)SSLContextContainer.find(domains, (String)"muc.tigase.org"));
        domains.put("tigase.org", "tigase.org");
        Assert.assertEquals((Object)"tigase.org", (Object)SSLContextContainer.find(domains, (String)"tigase.org"));
        Assert.assertEquals((Object)"*.tigase.org", (Object)SSLContextContainer.find(domains, (String)"muc.tigase.org"));
    }

    @Test
    public void testRemoveMatched() {
        HashMap<String, String> contexts = new HashMap<String, String>();
        contexts.put("one.com", "one.com");
        contexts.put("push.one.com", "push.one.com");
        contexts.put("sub.push.one.com", "sub.push.one.com");
        contexts.put("*.one.com", "*.one.com");
        contexts.put("a.two.com", "a.two.com");
        contexts.put("*.two.com", "*.two.com");
        HashSet<String> domains = new HashSet<String>(Arrays.asList("one.com", "*.one.com", "two.com"));
        SSLContextContainer.removeMatchedDomains(contexts, domains);
        Assert.assertFalse((boolean)contexts.containsKey("one.com"));
        Assert.assertFalse((boolean)contexts.containsKey("push.one.com"));
        Assert.assertTrue((boolean)contexts.containsKey("sub.push.one.com"));
        Assert.assertFalse((boolean)contexts.containsKey("*.one.com"));
        Assert.assertTrue((boolean)contexts.containsKey("a.two.com"));
        Assert.assertTrue((boolean)contexts.containsKey("*.two.com"));
    }

    @Test
    public void testGetSpareDomainNamesToRemove() {
        TreeSet<String> contexts = new TreeSet<String>();
        contexts.add("one.com");
        contexts.add("push.one.com");
        contexts.add("muc.one.com");
        contexts.add("sub.push.one.com");
        contexts.add("*.one.com");
        contexts.add("two.com");
        contexts.add("a.two.com");
        contexts.add("*.two.com");
        contexts.add("three.com");
        contexts.add("*.three.com");
        contexts.add("push.three.com");
        contexts.add("muc.three.com");
        HashSet<String> domains = new HashSet<String>(Arrays.asList("one.com", "*.one.com", "two.com"));
        Set spareDomainNamesToRemove = SSLContextContainerAbstract.getSpareDomainNamesToRemove(contexts, domains);
        Assert.assertFalse((boolean)spareDomainNamesToRemove.contains("one.com"));
        Assert.assertTrue((boolean)spareDomainNamesToRemove.contains("push.one.com"));
        Assert.assertTrue((boolean)spareDomainNamesToRemove.contains("muc.one.com"));
        Assert.assertFalse((boolean)spareDomainNamesToRemove.contains("sub.push.one.com"));
        Assert.assertFalse((boolean)spareDomainNamesToRemove.contains("*.one.com"));
        Assert.assertFalse((boolean)spareDomainNamesToRemove.contains("two.com"));
        Assert.assertFalse((boolean)spareDomainNamesToRemove.contains("a.two.com"));
        Assert.assertFalse((boolean)spareDomainNamesToRemove.contains("*.two.com"));
        Assert.assertFalse((boolean)spareDomainNamesToRemove.contains("three.com"));
        Assert.assertFalse((boolean)spareDomainNamesToRemove.contains("*.three.com"));
        Assert.assertFalse((boolean)spareDomainNamesToRemove.contains("push.three.com"));
        Assert.assertFalse((boolean)spareDomainNamesToRemove.contains("muc.three.com"));
        spareDomainNamesToRemove.forEach(contexts::remove);
        Assert.assertTrue((boolean)contexts.contains("one.com"));
        Assert.assertFalse((boolean)contexts.contains("push.one.com"));
        Assert.assertFalse((boolean)contexts.contains("muc.one.com"));
        Assert.assertTrue((boolean)contexts.contains("sub.push.one.com"));
        Assert.assertTrue((boolean)contexts.contains("*.one.com"));
        Assert.assertTrue((boolean)contexts.contains("two.com"));
        Assert.assertTrue((boolean)contexts.contains("a.two.com"));
        Assert.assertTrue((boolean)contexts.contains("*.two.com"));
        Assert.assertTrue((boolean)contexts.contains("three.com"));
        Assert.assertTrue((boolean)contexts.contains("*.three.com"));
        Assert.assertTrue((boolean)contexts.contains("push.three.com"));
        Assert.assertTrue((boolean)contexts.contains("muc.three.com"));
        contexts.addAll(domains);
        Assert.assertTrue((boolean)contexts.contains("one.com"));
        Assert.assertFalse((boolean)contexts.contains("push.one.com"));
        Assert.assertFalse((boolean)contexts.contains("muc.one.com"));
        Assert.assertTrue((boolean)contexts.contains("sub.push.one.com"));
        Assert.assertTrue((boolean)contexts.contains("*.one.com"));
        Assert.assertTrue((boolean)contexts.contains("two.com"));
        Assert.assertTrue((boolean)contexts.contains("a.two.com"));
        Assert.assertTrue((boolean)contexts.contains("*.two.com"));
        Assert.assertTrue((boolean)contexts.contains("three.com"));
        Assert.assertTrue((boolean)contexts.contains("*.three.com"));
        Assert.assertTrue((boolean)contexts.contains("push.three.com"));
        Assert.assertTrue((boolean)contexts.contains("muc.three.com"));
    }

    @Test
    public void testGetSpareDomainNamesToRemoveSimple() {
        TreeSet<String> contexts = new TreeSet<String>();
        contexts.add("one.com");
        contexts.add("two.com");
        HashSet<String> domains = new HashSet<String>(Arrays.asList("one.com", "*.one.com"));
        Set spareDomainNamesToRemove = SSLContextContainerAbstract.getSpareDomainNamesToRemove(contexts, domains);
        Assert.assertTrue((boolean)spareDomainNamesToRemove.isEmpty());
        spareDomainNamesToRemove.forEach(contexts::remove);
        Assert.assertTrue((boolean)contexts.contains("one.com"));
        Assert.assertFalse((boolean)contexts.contains("*.one.com"));
        Assert.assertTrue((boolean)contexts.contains("two.com"));
        contexts.addAll(domains);
        Assert.assertTrue((boolean)contexts.contains("one.com"));
        Assert.assertTrue((boolean)contexts.contains("*.one.com"));
        Assert.assertTrue((boolean)contexts.contains("two.com"));
    }

    @Test
    public void testGetSpareDomainNamesToRemoveAtlantiscity() {
        TreeSet<String> contexts = new TreeSet<String>();
        contexts.add("atlantiscity");
        contexts.add("firefly");
        HashSet<String> domains = new HashSet<String>(Arrays.asList("atlantiscity", "*.atlantiscity"));
        Set spareDomainNamesToRemove = SSLContextContainerAbstract.getSpareDomainNamesToRemove(contexts, domains);
        Assert.assertTrue((boolean)spareDomainNamesToRemove.isEmpty());
        spareDomainNamesToRemove.forEach(contexts::remove);
        Assert.assertTrue((boolean)contexts.contains("atlantiscity"));
        Assert.assertFalse((boolean)contexts.contains("*.atlantiscity"));
        Assert.assertTrue((boolean)contexts.contains("firefly"));
        contexts.addAll(domains);
        Assert.assertTrue((boolean)contexts.contains("atlantiscity"));
        Assert.assertTrue((boolean)contexts.contains("*.atlantiscity"));
        Assert.assertTrue((boolean)contexts.contains("firefly"));
    }

    @Test
    public void testGetSpareDomainNamesToRemoveLongDomains() {
        TreeSet<String> contexts = new TreeSet<String>();
        contexts.add("chat.example.com");
        contexts.add("muc.chat.example.com");
        HashSet<String> domains = new HashSet<String>(Arrays.asList("chat.example.com", "*.chat.example.com"));
        Set spareDomainNamesToRemove = SSLContextContainerAbstract.getSpareDomainNamesToRemove(contexts, domains);
        Assert.assertEquals((long)1L, (long)spareDomainNamesToRemove.size());
        Assert.assertTrue((boolean)spareDomainNamesToRemove.contains("muc.chat.example.com"));
        spareDomainNamesToRemove.forEach(contexts::remove);
        Assert.assertTrue((boolean)contexts.contains("chat.example.com"));
        Assert.assertFalse((boolean)contexts.contains("*.chat.example.com"));
        contexts.addAll(domains);
        Assert.assertTrue((boolean)contexts.contains("chat.example.com"));
        Assert.assertTrue((boolean)contexts.contains("*.chat.example.com"));
    }

    @Test
    public void testRemoveMatchedMuc() {
        HashMap<String, String> contexts = new HashMap<String, String>();
        contexts.put("one.com", "one.com");
        contexts.put("muc.one.com", "muc.one.com");
        contexts.put("*.one.com", "*.one.com");
        HashSet<String> domains = new HashSet<String>(Arrays.asList("one.com", "*.one.com"));
        SSLContextContainer.removeMatchedDomains(contexts, domains);
        Assert.assertFalse((boolean)contexts.containsKey("one.com"));
        Assert.assertFalse((boolean)contexts.containsKey("muc.one.com"));
        Assert.assertFalse((boolean)contexts.containsKey("*.one.com"));
        Assert.assertTrue((boolean)contexts.isEmpty());
    }
}

