/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.db.AbstractDataSourceTestCase;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.DataSourceHelper;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.db.jdbc.JDBCRepositoryTest;
import tigase.xmpp.jid.BareJID;

public abstract class AbstractUserRepositoryTest<DS extends DataSource>
extends AbstractDataSourceTestCase<DS> {
    private final Logger log = Logger.getLogger(this.getClass().getCanonicalName());
    protected UserRepository repo;

    @Before
    public void setUp() throws Exception {
        this.repo = (UserRepository)DataSourceHelper.getDefaultClass(UserRepository.class, (String)uri).newInstance();
        if (this.repo instanceof DataSourceAware) {
            ((DataSourceAware)this.repo).setDataSource(this.getDataSource());
        }
    }

    @After
    public void tearDown() {
        this.repo = null;
    }

    @Test
    public void testLongNode() throws InterruptedException, TigaseDBException {
        BareJID user = BareJID.bareJIDInstanceNS((String)"user", (String)"domain");
        this.repo.addUser(user);
        this.repo.setData(user, "node1/node2/node3", "key", "value");
        String node3val = this.repo.getData(user, "node1/node2/node3", "key");
        Assert.assertEquals((String)"String differ from expected!", (Object)"value", (Object)node3val);
        this.repo.removeSubnode(user, "node1");
        node3val = this.repo.getData(user, "node1/node2/node3", "key");
        Assert.assertNull((String)"Node not removed", (Object)node3val);
        this.repo.removeUser(user);
    }

    @Test
    public void testGetData() throws InterruptedException {
        this.log.log(Level.FINE, "repo: " + String.valueOf(this.repo));
        if (this.repo != null) {
            LocalDateTime localNow = LocalDateTime.now();
            long initalDelay = 5L;
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(10);
            int iter = 50;
            int threads = 10;
            for (int i = 0; i < 10; ++i) {
                scheduler.scheduleAtFixedRate(new RunnableImpl(50), initalDelay, 100L, TimeUnit.MILLISECONDS);
            }
            Thread.sleep(10000L);
        }
    }

    private void getData(BareJID user) {
        if (user == null) {
            user = BareJID.bareJIDInstanceNS((String)"user", (String)"domain");
        }
        this.log.log(Level.FINE, "retrieve: " + String.valueOf(user) + " / thread: " + Thread.currentThread().getName());
        try {
            this.repo.addUser(user);
        }
        catch (UserExistsException ex) {
            this.log.log(Level.FINE, "User exists, ignore: " + String.valueOf(ex.getUserId()));
        }
        catch (TigaseDBException ex) {
            Logger.getLogger(JDBCRepositoryTest.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private class RunnableImpl
    implements Runnable {
        int count = 0;
        int max = 50;

        public RunnableImpl(int max) {
            this.max = max;
        }

        @Override
        public void run() {
            while (this.count < this.max) {
                ++this.count;
                BareJID user = BareJID.bareJIDInstanceNS((String)String.valueOf(new Date().getTime() / 10L), (String)"domain");
                AbstractUserRepositoryTest.this.getData(user);
            }
        }
    }
}

