/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.credentials.entries;

import org.junit.Assert;
import org.junit.Test;
import tigase.auth.credentials.entries.MD5UsernamePasswordCredentialsEntry;
import tigase.xmpp.jid.BareJID;

public class MD5UsernamePasswordCredentialsEntryTest {
    @Test
    public void testDecodingOfStoredValue() {
        String testPassword = "some-password-do-protect";
        BareJID user = BareJID.bareJIDInstanceNS((String)"user@domain");
        String encPassword = "3e470bf91e38446f3d58ce890b1a8b63";
        MD5UsernamePasswordCredentialsEntry.Decoder decoder = new MD5UsernamePasswordCredentialsEntry.Decoder();
        MD5UsernamePasswordCredentialsEntry entry = decoder.decode(user, encPassword);
        Assert.assertTrue((boolean)entry.verifyPlainPassword(testPassword));
    }

    @Test
    public void testEncodingAndDecoding() {
        String testPassword = "some-password-do-protect";
        BareJID user = BareJID.bareJIDInstanceNS((String)"user@domain");
        MD5UsernamePasswordCredentialsEntry.Encoder encoder = new MD5UsernamePasswordCredentialsEntry.Encoder();
        String encPassword = encoder.encode(user, testPassword);
        MD5UsernamePasswordCredentialsEntry.Decoder decoder = new MD5UsernamePasswordCredentialsEntry.Decoder();
        MD5UsernamePasswordCredentialsEntry entry = decoder.decode(user, encPassword);
        Assert.assertTrue((boolean)entry.verifyPlainPassword(testPassword));
        Assert.assertEquals((Object)encPassword, (Object)encoder.encode(user, entry));
    }
}

