/*
 * Tigase XMPP Server - The instant messaging server
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 */
package tigase.server.xmppserver.proc;

import tigase.kernel.beans.Bean;
import tigase.server.Packet;
import tigase.server.xmppserver.S2SConnectionManager;
import tigase.server.xmppserver.S2SIOService;
import tigase.xml.Element;

import java.util.List;
import java.util.logging.Logger;

/**
 * Created: Dec 9, 2010 2:01:12 PM
 *
 * @author <a href="mailto:artur.hefczyc@tigase.org">Artur Hefczyc</a>
*/
@Bean(name = "startZlib", parent = S2SConnectionManager.class, active = true)
public class StartZlib
		extends S2SAbstractProcessor {

	private static final Logger log = Logger.getLogger(StartZlib.class.getName());
	private static final String START_ZLIB_XMLNS = "http://jabber.org/features/compress";
	private static final String START_ZLIB_ELEMENT_NAME = "compression";
	private static final Element features = new Element(START_ZLIB_ELEMENT_NAME, new Element[]{new Element("method", "zlib")},
														new String[]{"xmlns"},
														new String[]{START_ZLIB_XMLNS});

	@Override
	public int order() {
		return Order.StartZlib.ordinal();
	}

	@Override
	public void streamFeatures(S2SIOService serv, List<Element> results) {

		// results.add(features);
	}

	@Override
	public boolean shouldSkipUndelivered(Packet packet) {
		return packet.getElemName() == START_ZLIB_ELEMENT_NAME
				|| packet.getXMLNS() == START_ZLIB_XMLNS;
	}
}
