/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.kernel.beans.Bean;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.VCardXMPPProcessorAbstract;
import tigase.xmpp.impl.annotation.DiscoFeatures;
import tigase.xmpp.impl.annotation.Handle;
import tigase.xmpp.impl.annotation.Handles;
import tigase.xmpp.impl.annotation.Id;
import tigase.xmpp.jid.JID;

@Id(value="vcard-xep-0292")
@Handles(value={@Handle(path={"iq", "vcard"}, xmlns="urn:ietf:params:xml:ns:vcard-4.0")})
@DiscoFeatures(value={"urn:ietf:params:xml:ns:vcard-4.0"})
@Bean(name="vcard-xep-0292", parent=SessionManager.class, active=true)
public class VCard4
extends VCardXMPPProcessorAbstract {
    protected static final String VCARD_EL = "vcard";
    protected static final String XMLNS = "urn:ietf:params:xml:ns:vcard-4.0";
    static final String ID = "vcard-xep-0292";
    public static final String REPO_NODE = "vcard-xep-0292";
    static final String VCARD_KEY = "vcard-xep-0292";
    private static final Logger log = Logger.getLogger(VCard4.class.getCanonicalName());
    private static final SimpleParser parser = SingletonFactory.getParserInstance();

    @Override
    public void processFromUserOutPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (session.isLocalDomain(packet.getStanzaTo().getDomain(), false)) {
            try {
                String strvCard = repo.getPublicData(packet.getStanzaTo().getBareJID(), "vcard-xep-0292", "vcard-xep-0292", null);
                Packet result = null;
                result = strvCard != null ? this.parseXMLData(strvCard, packet) : packet.okResult((String)null, 1);
                result.setPacketTo(connectionId);
                results.offer(result);
            }
            catch (UserNotFoundException e) {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "User not found", true));
            }
        } else {
            results.offer(packet.copyElementOnly());
        }
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getType() != null) {
            try {
                Packet result = null;
                switch (packet.getType()) {
                    case get: {
                        String strvCard = session.getPublicData("vcard-xep-0292", "vcard-xep-0292", null);
                        if (strvCard != null) {
                            result = this.parseXMLData(strvCard, packet);
                            break;
                        }
                        result = packet.okResult((String)null, 1);
                        break;
                    }
                    case set: {
                        Element elvCard = packet.getElement().getChild(VCARD_EL, XMLNS);
                        this.setVCard(session, elvCard);
                        result = packet.okResult((String)null, 0);
                        break;
                    }
                }
                if (result != null) {
                    result.setPacketTo(session.getConnectionId());
                    results.offer(result);
                }
            }
            catch (NoConnectionIdException ex) {
                log.warning("This should not happen, unless this is a vcard result packet sent to the server, which should not happen: " + String.valueOf(packet));
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.CONFIG, "Received vCard request but user session is not authorized yet: " + String.valueOf(packet));
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Database problem, please contact admin: " + String.valueOf(ex), ex);
                results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
            }
        }
    }

    @Override
    public void processNullSessionPacket(Packet packet, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getType() == StanzaType.get) {
            try {
                String strvCard = repo.getPublicData(packet.getStanzaTo().getBareJID(), "vcard-xep-0292", "vcard-xep-0292", null);
                if (strvCard != null) {
                    results.offer(this.parseXMLData(strvCard, packet));
                } else {
                    results.offer(packet.okResult((String)null, 1));
                }
            }
            catch (UserNotFoundException e) {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "User not found", true));
            }
        }
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
    }

    @Override
    public void processToUserPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        this.processNullSessionPacket(packet, repo, results, settings);
        if (session != null && session.isAuthorized() && packet.getType() != StanzaType.get) {
            try {
                JID conId = session.getConnectionId(packet.getStanzaTo());
                if (conId == null) {
                    return;
                }
                Packet result = packet.copyElementOnly();
                result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
                results.offer(result);
            }
            catch (NoConnectionIdException ex) {
                log.warning("This should not happen, unless this is a vcard result packet sent to the server, which should not happen: " + String.valueOf(packet));
            }
        }
    }

    @Override
    protected String getVCardXMLNS() {
        return XMLNS;
    }

    @Override
    protected void storeVCard(XMPPResourceConnection session, Element elvCard) throws TigaseDBException, NotAuthorizedException {
        if (elvCard != null && elvCard.getChildren() != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Adding vCard: " + String.valueOf(elvCard));
            }
            session.setPublicData("vcard-xep-0292", "vcard-xep-0292", elvCard.toString());
        } else {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Removing vCard");
            }
            session.removePublicData("vcard-xep-0292", "vcard-xep-0292");
        }
    }

    private Packet parseXMLData(String data, Packet packet) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Queue elems = domHandler.getParsedElements();
        Packet result = packet.okResult((Element)null, 0);
        result.setPacketFrom(null);
        result.setPacketTo(null);
        for (Element el : elems) {
            result.getElement().addChild((XMLNodeIfc)el);
        }
        return result;
    }
}

