/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import tigase.auth.BruteForceLockerBean;
import tigase.auth.XmppSaslException;
import tigase.auth.mechanisms.AbstractSasl;
import tigase.auth.mechanisms.AbstractSaslSCRAM;
import tigase.auth.mechanisms.SaslSCRAMPlus;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.server.xmppsession.SessionManager;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.SaslAuthAbstract;
import tigase.xmpp.impl.StreamManagementInline;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="urn:xmpp:sasl:2", parent=SessionManager.class, active=false)
public class SaslAuth2
extends SaslAuthAbstract
implements XMPPProcessorIfc {
    public static final String ID = "urn:xmpp:sasl:2";
    private static final Logger log = Logger.getLogger(SaslAuth2.class.getName());
    private static final String XMLNS = "urn:xmpp:sasl:2";
    protected static final String USER_AGENT_KEY = "user-agent-key";
    protected static final String SASL_FEATURES_KEY = "sasl-features-key";
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:sasl:2"})};
    private static final String[][] ELEMENTS = new String[][]{{"authenticate"}, {"response"}, {"challenge"}, {"failure"}, {"success"}, {"continue"}, {"next"}, {"data"}, {"upgrade"}, {"parameters"}, {"hash"}, {"abort"}};
    private static final String[] XMLNSS = new String[]{"urn:xmpp:sasl:2", "urn:xmpp:sasl:2", "urn:xmpp:sasl:2", "urn:xmpp:sasl:2", "urn:xmpp:sasl:2", "urn:xmpp:sasl:2", "urn:xmpp:sasl:2", "urn:xmpp:sasl:2", "urn:xmpp:sasl:2", "urn:xmpp:sasl:2", "urn:xmpp:sasl:2", "urn:xmpp:sasl:2"};
    @Inject(nullAllowed=true)
    private SessionManager sessionManager;
    @Inject
    private List<Inline> inlines;

    @Override
    public String id() {
        return "urn:xmpp:sasl:2";
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    public List<Inline> getInlines() {
        return this.inlines;
    }

    public void setInlines(List<Inline> inlines) {
        List<Inline> smInlines;
        if (inlines == null) {
            inlines = Collections.emptyList();
        }
        if (!(smInlines = inlines.stream().filter(it -> it instanceof StreamManagementInline).toList()).isEmpty()) {
            inlines.removeAll(smInlines);
            inlines.addAll(0, smInlines);
        }
        this.inlines = inlines;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null || session.isAuthorized()) {
            return null;
        }
        Collection<String> auth_mechs = this.saslProvider.filterMechanisms(Sasl.getSaslServerFactories(), session);
        if (auth_mechs.isEmpty()) {
            return null;
        }
        session.putSessionData("allowed-sasl-mechanisms", auth_mechs);
        ArrayList<Element> children = new ArrayList<Element>();
        for (String string : auth_mechs) {
            children.add(new Element("mechanism", string));
        }
        Element inlineEl = new Element("inline");
        children.add(inlineEl);
        for (Inline inline : this.inlines) {
            Element[] features = inline.supStreamFeatures(Inline.Action.sasl2);
            if (features == null) continue;
            for (Element feature : features) {
                inlineEl.addChild((XMLNodeIfc)feature);
            }
        }
        if (session.isEncrypted() && session.getSessionData("LOCAL_CERTIFICATE_KEY") != null && SaslSCRAMPlus.containsScramPlus(auth_mechs)) {
            Element element = AbstractSaslSCRAM.getSupportedChannelBindings(session);
            return new Element[]{new Element("authentication", (Element[])children.toArray(Element[]::new), new String[]{"xmlns"}, new String[]{"urn:xmpp:sasl:2"}), element};
        }
        return new Element[]{new Element("authentication", (Element[])children.toArray(Element[]::new), new String[]{"xmlns"}, new String[]{"urn:xmpp:sasl:2"})};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            block33: {
                if (session.getSessionData("authentication-timeout") != null) {
                    return;
                }
                String clientIp = BruteForceLockerBean.getClientIp(session);
                if (session.isAuthorized()) {
                    this.processSessionAlreadyAuthorized(packet, session, results);
                    return;
                }
                try {
                    byte[] challenge;
                    SaslServer ss;
                    ElementType action = ElementType.parse(packet.getElemName());
                    if (action == null) {
                        throw new XmppSaslException(XmppSaslException.SaslError.malformed_request, "Unrecognized element " + packet.getElemName());
                    }
                    byte[] data = new byte[]{};
                    switch (action.ordinal()) {
                        case 1: {
                            String cdata;
                            Element initialResponse;
                            String mechanismName = packet.getElement().getAttributeStaticStr("mechanism");
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Start SASL auth. mechanism=" + mechanismName);
                            }
                            Collection<String> allowedMechanisms = (Collection<String>)session.getSessionData("allowed-sasl-mechanisms");
                            session.removeSessionData("allowed-sasl-mechanisms");
                            if (allowedMechanisms == null) {
                                allowedMechanisms = this.saslProvider.filterMechanisms(Sasl.getSaslServerFactories(), session);
                            }
                            if (mechanismName == null || allowedMechanisms == null || !allowedMechanisms.contains(mechanismName)) {
                                throw new XmppSaslException(XmppSaslException.SaslError.invalid_mechanism, "Mechanism '" + mechanismName + "' is not allowed");
                            }
                            CallbackHandler cbh = this.saslProvider.create(mechanismName, session, repo, settings);
                            ss = Sasl.createSaslServer(mechanismName, "xmpp", session.getDomain().getVhost().getDomain(), this.props, cbh);
                            if (ss == null) {
                                throw new XmppSaslException(XmppSaslException.SaslError.invalid_mechanism, "Mechanism '" + mechanismName + "' is not allowed");
                            }
                            session.putSessionData("SASL_SERVER_KEY", ss);
                            UserAgent userAgent = this.parseUserAgent(packet);
                            session.putSessionData(USER_AGENT_KEY, userAgent);
                            List features = packet.getElement().findChildren(el -> el.getName() != "initial-response" && el.getName() != "user-agent");
                            if (features != null && !features.isEmpty()) {
                                session.putSessionData(SASL_FEATURES_KEY, features);
                            }
                            if ((initialResponse = packet.getElement().getChild("initial-response")) == null || (cdata = initialResponse.getCData()) == null || cdata.equals("=")) break;
                            data = Base64.decode((String)cdata);
                            break;
                        }
                        case 4: {
                            ss = (SaslServer)session.getSessionData("SASL_SERVER_KEY");
                            if (ss == null) {
                                throw new XmppSaslException(XmppSaslException.SaslError.malformed_request);
                            }
                            String cdata = packet.getElement().getCData();
                            if (cdata == null || cdata.equals("=")) break;
                            data = Base64.decode((String)cdata);
                            break;
                        }
                        default: {
                            throw new XmppSaslException(XmppSaslException.SaslError.malformed_request, "Unrecognized element " + action.getElementName());
                        }
                    }
                    String challengeData = (challenge = ss.evaluateResponse(data)) != null ? Base64.encode((byte[])challenge) : null;
                    if (ss.isComplete() && ss.getAuthorizationID() != null) {
                        boolean anonymous;
                        BareJID jid = ss.getAuthorizationID().contains("@") ? BareJID.bareJIDInstance((String)ss.getAuthorizationID()) : BareJID.bareJIDInstance((String)ss.getAuthorizationID(), (String)session.getDomain().getVhost().getDomain());
                        if (this.isLoginAllowedByBruteForceLocker(session, clientIp, jid)) {
                            throw new BruteForceLockerBean.LoginLockedException();
                        }
                        if (log.isLoggable(Level.FINE)) {
                            log.finest("Authorized as " + String.valueOf(jid));
                        }
                        try {
                            Boolean x = (Boolean)ss.getNegotiatedProperty("IS_ANONYMOUS");
                            anonymous = x != null && x != false;
                        }
                        catch (Exception e) {
                            anonymous = false;
                        }
                        session.removeSessionData("SASL_SERVER_KEY");
                        session.authorizeJID(jid, anonymous);
                        if (session.getAuthRepository() != null) {
                            session.getAuthRepository().loggedIn(jid);
                        }
                        this.processSuccess(packet, session, challengeData, results);
                        break block33;
                    }
                    if (!ss.isComplete()) {
                        results.offer(packet.swapFromTo(this.createReply(ElementType.CHALLENGE, challengeData), null, null));
                        break block33;
                    }
                    throw new XmppSaslException(XmppSaslException.SaslError.malformed_request);
                }
                catch (BruteForceLockerBean.LoginLockedException e) {
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Account locked by BruteForceLocker.");
                    }
                    results.offer(this.createSaslErrorResponse(XmppSaslException.SaslError.not_authorized, AbstractSasl.PASSWORD_NOT_VERIFIED_MSG, packet));
                }
                catch (XmppSaslException e) {
                    this.saveIntoBruteForceLocker(session, e);
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "SASL unsuccessful", e);
                    }
                    results.offer(this.createSaslErrorResponse(e.getSaslError(), e.getMessage(), packet));
                }
                catch (SaslException e) {
                    this.saveIntoBruteForceLocker(session, e);
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "SASL unsuccessful", e);
                    }
                    results.offer(this.createSaslErrorResponse(XmppSaslException.SaslError.not_authorized, null, packet));
                }
                catch (Exception e) {
                    this.onAuthFail(session);
                    if (log.isLoggable(Level.WARNING)) {
                        log.log(Level.WARNING, "Problem with SASL", e);
                    }
                    results.offer(this.createSaslErrorResponse(XmppSaslException.SaslError.temporary_auth_failure, null, packet));
                }
            }
        }
    }

    @Override
    protected void processSuccess(Packet packet, XMPPResourceConnection session, String challengeData, Queue<Packet> results) {
        Element success = new Element("success");
        success.setXMLNS("urn:xmpp:sasl:2");
        if (challengeData != null) {
            success.addChild((XMLNodeIfc)new Element("additional-data", challengeData));
        }
        CompletionStage<Inline.Result> result = CompletableFuture.completedFuture(new Inline.Result(null, true));
        List children = (List)session.getSessionData(SASL_FEATURES_KEY);
        if (children != null && !children.isEmpty()) {
            for (Element child : children) {
                for (Inline inline : this.inlines) {
                    if (!inline.canHandle(session, child)) continue;
                    result = result.thenCompose(r -> {
                        if (r.element != null) {
                            success.addChild((XMLNodeIfc)r.element);
                        }
                        if (r.shouldContinue) {
                            return inline.process(session, null, child);
                        }
                        return CompletableFuture.completedFuture(new Inline.Result(null, false));
                    });
                }
            }
        }
        ((CompletableFuture)((CompletableFuture)result.thenCompose(x -> {
            if (x.element != null) {
                success.addChild((XMLNodeIfc)x.element);
            }
            try {
                success.addChild((XMLNodeIfc)new Element("authorization-identifier", session.getJID().toString()));
                return CompletableFuture.completedFuture(packet.swapFromTo(success, null, null));
            }
            catch (NotAuthorizedException ex) {
                return CompletableFuture.failedFuture(ex);
            }
        })).thenAccept(resultPacket -> {
            resultPacket.setPriority(Priority.HIGH);
            this.sessionManager.addOutPacket((Packet)resultPacket);
            Packet getFeaturesCmd = Command.GETFEATURES.getPacket(packet.getFrom(), packet.getTo(), StanzaType.get, UUID.randomUUID().toString(), null);
            getFeaturesCmd.setPacketFrom(packet.getPacketFrom());
            getFeaturesCmd.setPacketTo(packet.getPacketTo());
            this.sessionManager.addOutPacket(getFeaturesCmd);
        })).exceptionally(ex -> {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "SASL2 inline processing failed with exception:", (Throwable)ex);
            }
            this.sessionManager.addOutPacket(this.createSaslErrorResponse(XmppSaslException.SaslError.not_authorized, ex.getMessage(), packet));
            return null;
        });
    }

    @Override
    protected String getXmlns() {
        return "urn:xmpp:sasl:2";
    }

    private UserAgent parseUserAgent(Packet packet) {
        Element el = packet.getElemChild("user-agent");
        if (el == null) {
            return null;
        }
        Element software = el.getChild("software");
        Element device = el.getChild("device");
        return new UserAgent(el.getAttributeStaticStr("id"), software != null ? software.getCData() : null, device != null ? device.getCData() : null);
    }

    protected Element createReply(ElementType type, String cdata) {
        Element reply = new Element(type.getElementName());
        reply.setXMLNS(this.getXmlns());
        if (cdata != null) {
            reply.setCData(cdata);
        }
        return reply;
    }

    public static interface Inline {
        public boolean canHandle(XMPPResourceConnection var1, Element var2);

        public Element[] supStreamFeatures(Action var1);

        public CompletableFuture<Result> process(XMPPResourceConnection var1, JID var2, Element var3);

        public static class Result {
            public final Element element;
            public final boolean shouldContinue;

            public Result(Element element, boolean shouldContinue) {
                this.element = element;
                this.shouldContinue = shouldContinue;
            }
        }

        public static enum Action {
            sasl2,
            bind2;

        }
    }

    public static enum ElementType {
        ABORT,
        AUTHENTICATE,
        CHALLENGE,
        FAILURE,
        RESPONSE,
        SUCCESS,
        CONTINUE,
        NEXT,
        DATA,
        UPGRADE,
        PARAMETERS,
        HASH;

        private static final Map<String, ElementType> ALL_TYPES;
        private final String elementName = this.name().toLowerCase();

        public static ElementType parse(String name) {
            return ALL_TYPES.get(name);
        }

        public String getElementName() {
            return this.elementName;
        }

        static {
            ALL_TYPES = Arrays.stream(ElementType.values()).collect(Collectors.toMap(ElementType::getElementName, Function.identity()));
        }
    }

    public static class UserAgent {
        private final String id;
        private final String software;
        private final String device;

        public UserAgent(String id, String software, String device) {
            this.id = id;
            this.software = software;
            this.device = device;
        }

        public String getId() {
            return this.id;
        }

        public String getSoftware() {
            return this.software;
        }

        public String getDevice() {
            return this.device;
        }
    }
}

