/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.db.TigaseDBException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.JabberIqPrivacy;
import tigase.xmpp.impl.PrivacyList;
import tigase.xmpp.impl.roster.RosterFactory;

public class Privacy {
    public static final String ACTION = "action";
    public static final String ACTIVE = "active-list";
    public static final String DEFAULT = "default-list";
    public static final String ITEM = "item";
    public static final String LIST = "list";
    public static final String NAME = "name";
    public static final String ORDER = "order";
    public static final String PRIVACY = "privacy";
    public static final String PRIVACY_LIST = "privacy-list";
    public static final String STANZAS = "stanzas";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String PRIVACY_LIST_LOADED = "privacy-lists-loaded";
    private static Logger log = Logger.getLogger(Privacy.class.getName());

    public static void addList(XMPPResourceConnection session, Element list) throws NotAuthorizedException, TigaseDBException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Saving privacy list: {0}", list);
        }
        String lNode = Privacy.listNode(list.getAttributeStaticStr(NAME));
        session.setData(lNode, PRIVACY_LIST, list.toString());
    }

    public static boolean block(XMPPResourceConnection session, List<String> jids) throws NotAuthorizedException, TigaseDBException {
        List items;
        String name = Privacy.getDefaultListName(session);
        if (name == null) {
            name = "default";
        }
        Element list_new = new Element(LIST, new String[]{NAME}, new String[]{name});
        for (String jid : jids) {
            list_new.addChild((XMLNodeIfc)new Element(ITEM, new String[]{TYPE, ACTION, VALUE}, new String[]{"jid", "deny", jid}));
        }
        Element list = Privacy.getList(session, name);
        if (list != null && (items = list.getChildren()) != null) {
            items.stream().filter(it -> !jids.contains(it.getAttributeStaticStr(VALUE))).sorted(JabberIqPrivacy.compar).forEach(it -> list_new.addChild((XMLNodeIfc)it));
        }
        int i = 0;
        for (Element item : list_new.getChildren()) {
            item.setAttribute(ORDER, String.valueOf(++i));
        }
        Privacy.updateList(session, name, list_new);
        return true;
    }

    public static PrivacyList getActiveList(XMPPResourceConnection session) throws NotAuthorizedException {
        return (PrivacyList)session.getSessionData(ACTIVE);
    }

    public static String getActiveListName(XMPPResourceConnection session) throws NotAuthorizedException {
        PrivacyList list = Privacy.getActiveList(session);
        if (list != null) {
            return list.getName();
        }
        return null;
    }

    public static List<String> getBlocked(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        PrivacyList list = Privacy.getDefaultList(session);
        List ulist = null;
        if (list != null) {
            ulist = list.getBlockedJids().map(jid -> jid.toString()).collect(Collectors.toList());
        }
        return ulist;
    }

    public static PrivacyList getDefaultList(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        PrivacyList sessionDefaultList = (PrivacyList)session.getCommonSessionData(DEFAULT);
        if (session.getCommonSessionData(PRIVACY_LIST_LOADED) == null) {
            sessionDefaultList = PrivacyList.create(session, RosterFactory.getRosterImplementation(true), Privacy.getDefaultListElement(session));
            if (null != sessionDefaultList) {
                session.putCommonSessionData(DEFAULT, sessionDefaultList);
            }
            session.putCommonSessionData(PRIVACY_LIST_LOADED, PRIVACY_LIST_LOADED);
        }
        return sessionDefaultList;
    }

    public static Element getDefaultListElement(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Element sessionDefaultList = null;
        String defaultListName = Privacy.getDefaultListName(session);
        if (defaultListName != null) {
            sessionDefaultList = Privacy.getList(session, defaultListName);
        }
        return sessionDefaultList;
    }

    public static String getDefaultListName(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        return session.getData(PRIVACY, DEFAULT, null);
    }

    public static Element getList(XMPPResourceConnection session, String list) throws NotAuthorizedException, TigaseDBException {
        String lNode;
        String list_str;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Loading privacy list: {0}", list);
        }
        if ((list_str = session.getData(lNode = Privacy.listNode(list), PRIVACY_LIST, null)) != null && !list_str.isEmpty()) {
            SimpleParser parser = SingletonFactory.getParserInstance();
            DomBuilderHandler domHandler = new DomBuilderHandler();
            parser.parse((SimpleHandler)domHandler, list_str.toCharArray(), 0, list_str.length());
            Queue elems = domHandler.getParsedElements();
            Element result = (Element)elems.poll();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Loaded privacy list: {0}", result);
            }
            return result;
        }
        return Privacy.getListOld(session, list);
    }

    public static Element getListOld(XMPPResourceConnection session, String list) throws NotAuthorizedException, TigaseDBException {
        String lNode = Privacy.listNode(list);
        String[] items = session.getDataGroups(lNode);
        if (items != null && list != null) {
            Element eList = new Element(LIST, new String[]{NAME}, new String[]{list});
            for (String item : items) {
                String iNode = lNode + "/" + item;
                String type = session.getData(iNode, TYPE, null);
                String value = session.getData(iNode, VALUE, null);
                String action = session.getData(iNode, ACTION, null);
                String[] stanzas = session.getDataList(iNode, STANZAS);
                if (item == null || action == null) continue;
                Element eItem = new Element(ITEM, new String[]{ORDER, ACTION}, new String[]{item, action});
                if (type != null) {
                    eItem.addAttribute(TYPE, type);
                }
                if (value != null) {
                    eItem.addAttribute(VALUE, value);
                }
                if (stanzas != null) {
                    for (String stanza : stanzas) {
                        eItem.addChild((XMLNodeIfc)new Element(stanza));
                    }
                }
                eList.addChild((XMLNodeIfc)eItem);
            }
            return eList;
        }
        return null;
    }

    public static String[] getLists(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        return session.getDataGroups(PRIVACY);
    }

    private static boolean isBlockItem(Element item) {
        return "jid".equals(item.getAttributeStaticStr(TYPE)) && "deny".equals(item.getAttributeStaticStr(ACTION)) && item.getChildren() == null;
    }

    public static String listNode(String list) {
        return "privacy/" + list;
    }

    public static void removeList(XMPPResourceConnection session, Element list) throws NotAuthorizedException, TigaseDBException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Removing privacy list: {0}", list);
        }
        String lNode = Privacy.listNode(list.getAttributeStaticStr(NAME));
        session.removeData(lNode, PRIVACY_LIST);
        session.removeDataGroup(lNode);
    }

    public static void setActiveList(XMPPResourceConnection session, String lName) throws NotAuthorizedException, TigaseDBException {
        if (lName == null) {
            session.removeSessionData(ACTIVE);
        } else {
            PrivacyList list = PrivacyList.create(session, RosterFactory.getRosterImplementation(true), Privacy.getList(session, lName));
            if (list != null) {
                session.putSessionData(ACTIVE, list);
            } else {
                log.log(Level.CONFIG, "Setting active list to null, do something better than that, perhaps notify user.");
            }
        }
    }

    public static void setDefaultList(XMPPResourceConnection session, Element list) throws NotAuthorizedException, TigaseDBException {
        if (list != null && list.getAttributeStaticStr(NAME) != null) {
            session.setData(PRIVACY, DEFAULT, list.getAttributeStaticStr(NAME));
            session.putCommonSessionData(DEFAULT, PrivacyList.create(session, RosterFactory.getRosterImplementation(true), list));
        } else {
            session.removeData(PRIVACY, DEFAULT);
            session.removeCommonSessionData(DEFAULT);
        }
    }

    public static boolean unblock(XMPPResourceConnection session, List<String> jids) throws NotAuthorizedException, TigaseDBException {
        String name = Privacy.getDefaultListName(session);
        Element list = Privacy.getList(session, name);
        if (list == null) {
            return false;
        }
        Element list_new = new Element(LIST, new String[]{NAME}, new String[]{name});
        List items = list.findChildren(item -> !jids.contains(item.getAttributeStaticStr(VALUE)));
        if (items != null) {
            Collections.sort(items, JabberIqPrivacy.compar);
            for (int i = 0; i < items.size(); ++i) {
                ((Element)items.get(i)).setAttribute(ORDER, String.valueOf(i + 1));
            }
            list_new.addChildren(items);
        }
        Privacy.updateList(session, name, list_new);
        return false;
    }

    public static List<String> unblockAll(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        String name = Privacy.getDefaultListName(session);
        Element list = Privacy.getList(session, name);
        if (list == null) {
            return null;
        }
        List ulist = list.mapChildren(item -> Privacy.isBlockItem(item), item -> item.getAttributeStaticStr(VALUE));
        Element list_new = new Element(LIST, new String[]{NAME}, new String[]{name});
        List items = list.findChildren(item -> !Privacy.isBlockItem(item));
        if (items != null) {
            Collections.sort(items, JabberIqPrivacy.compar);
            for (int i = 0; i < items.size(); ++i) {
                ((Element)items.get(i)).setAttribute(ORDER, "" + (i + 1));
            }
            list_new.addChildren(items);
        }
        Privacy.updateList(session, name, list_new);
        return ulist;
    }

    private static void updateList(XMPPResourceConnection session, String name, Element list_new) throws NotAuthorizedException, TigaseDBException {
        Privacy.addList(session, list_new);
        Privacy.setDefaultList(session, list_new);
        if (Privacy.getDefaultList(session) == null) {
            Privacy.setActiveList(session, name);
        } else if (name.equals(Privacy.getActiveListName(session))) {
            session.putCommonSessionData(ACTIVE, list_new);
            session.putSessionData(ACTIVE, list_new);
        }
    }
}

