/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.HashMap;
import java.util.Map;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public enum StreamError {
    BadFormat("bad-format"),
    BadNamespacePrefix("bad-namespace-prefix"),
    Conflict("conflict"),
    ConnectionTimeout("connection-timeout"),
    HostGone("host-gone"),
    HostUnknown("host-unknown"),
    ImproperAddressing("improper-addressing"),
    InternalServerError("internal-server-error"),
    InvalidFrom("invalid-from"),
    InvalidNamespace("invalid-namespace"),
    InvalidXml("invalid-xml"),
    NotAuthorized("not-authorized"),
    NotWellFormed("not-well-formed"),
    PolicyViolation("policy-violation"),
    RemoteConnectionFailed("remote-connection-failed"),
    Reset("reset"),
    ResourceConstraint("resource-constraint"),
    RestrictedXml("restricted-xml"),
    SeeOtherHost("see-other-host"),
    SystemShutdown("system-shutdown"),
    UndefinedCondition("undefined-condition"),
    UnsupportedEncoding("unsupported-encoding"),
    UnsupportedFeature("unsupported-feature"),
    UnsupportedStanzaType("unsupported-stanza-type"),
    UnsupportedVersion("unsupported-version");

    private static final Map<String, StreamError> BY_CONDITION;
    private final String condition;

    public static StreamError getByCondition(String condition) {
        StreamError err = BY_CONDITION.get(condition);
        if (err == null) {
            return UndefinedCondition;
        }
        return err;
    }

    private StreamError(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public String prepareStreamError(String errorMessage) {
        return "<stream:error><" + this.condition + " xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + (String)(errorMessage != null ? "<text xmlns='urn:ietf:params:xml:ns:xmpp-streams'>" + errorMessage + "</text>" : "") + "</stream:error></stream:stream>";
    }

    public Element prepareStreamErrorElement(String errorMessage) {
        Element err_el = new Element(this.condition);
        err_el.setXMLNS("urn:ietf:params:xml:ns:xmpp-streams");
        if (errorMessage != null) {
            Element text_el = new Element("text");
            text_el.setXMLNS("urn:ietf:params:xml:ns:xmpp-streams");
            text_el.setCData(errorMessage);
            err_el.addChild((XMLNodeIfc)text_el);
        }
        return err_el;
    }

    static {
        BY_CONDITION = new HashMap<String, StreamError>();
        for (StreamError err : StreamError.values()) {
            BY_CONDITION.put(err.getCondition(), err);
        }
    }
}

