/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

public interface SpamReportsConsumer {
    public static final String XMLNS_PREFIX = "urn:xmpp:reporting:";
    public static final String XMLNS1_PREFIX = "urn:xmpp:reporting:1";
    public static final String XMLNS = "urn:xmpp:reporting:0";
    public static final Element[] FEATURES = (Element[])Stream.concat(Stream.of("0", "abuse:0", "spam:0").map(suffix -> XMLNS_PREFIX + suffix), Stream.of("urn:xmpp:reporting:1")).map(var -> new Element("feature", new String[]{"var"}, new String[]{var})).toArray(Element[]::new);

    public boolean spamReportedFrom(BareJID var1, ReportType var2);

    public static enum ReportType {
        abuse,
        spam;

        private static Map<String, ReportType> VALUES;

        public static ReportType fromReport(Element report) {
            if (report.getXMLNS() == SpamReportsConsumer.XMLNS1_PREFIX) {
                String reason = report.getAttributeStaticStr("reason");
                if (reason != null) {
                    switch (reason) {
                        case "urn:xmpp:reporting:spam": {
                            return spam;
                        }
                        case "urn:xmpp:reporting:abuse": {
                            return abuse;
                        }
                    }
                }
                return null;
            }
            List children = report.getChildren();
            if (children == null) {
                return null;
            }
            for (Element child : children) {
                ReportType type = ReportType.fromElement(child);
                if (type == null) continue;
                return type;
            }
            return null;
        }

        public static ReportType fromElement(Element element) {
            return VALUES.get(element.getName());
        }

        static {
            VALUES = Arrays.stream(ReportType.values()).collect(Collectors.toMap(it -> it.name(), Function.identity()));
        }
    }
}

