/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.rtbl;

import java.util.List;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.AbstractModule;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.criteria.Or;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.server.rtbl.RTBLComponent;
import tigase.server.rtbl.RTBLRepository;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

@Bean(name="rtblEventModule", parent=RTBLComponent.class, active=true)
public class RTBLEventModule
extends AbstractModule {
    private static final String PUBSUB_XMLNS = "http://jabber.org/protocol/pubsub";
    private static final String PUBSUB_EVENT_XMLNS = "http://jabber.org/protocol/pubsub#event";
    public Criteria criteria = ElementCriteria.name((String)"message").add(ElementCriteria.name((String)"event", (String)"http://jabber.org/protocol/pubsub#event").add((Criteria)new Or(new Criteria[]{ElementCriteria.name((String)"items"), ElementCriteria.name((String)"purge")})));
    @Inject
    private RTBLRepository repository;

    @Override
    public Criteria getModuleCriteria() {
        return this.criteria;
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        String node;
        Element event = packet.getElemChild("event", PUBSUB_EVENT_XMLNS);
        JID from = packet.getStanzaFrom();
        if (from == null) {
            return;
        }
        Element items = event.getChild("items");
        if (items == null) {
            Element purge = event.getChild("purge");
            if (purge == null) {
                return;
            }
            String node2 = event.getAttributeStaticStr("node");
            if (node2 != null) {
                this.repository.purge(from.getBareJID(), node2);
            }
        }
        if ((node = items.getAttributeStaticStr("node")) == null) {
            return;
        }
        List notifications = items.getChildren();
        if (notifications == null) {
            return;
        }
        for (Element notification : notifications) {
            String id = notification.getAttributeStaticStr("id");
            if (id == null) continue;
            switch (notification.getName()) {
                case "retract": {
                    this.repository.update(from.getBareJID(), node, RTBLRepository.Action.remove, id);
                    break;
                }
                case "item": {
                    this.repository.update(from.getBareJID(), node, RTBLRepository.Action.add, id);
                    break;
                }
            }
        }
    }
}

