/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.rtbl;

import java.util.List;
import tigase.cluster.ClusterConnectionManager;
import tigase.component.AbstractKernelBasedComponent;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.component.modules.impl.DiscoveryModule;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.server.rtbl.RTBL;
import tigase.server.rtbl.RTBLFetchModule;
import tigase.server.rtbl.RTBLRepository;
import tigase.server.rtbl.RTBLSubscribeModule;

@Bean(name="rtbl-component", parent=Kernel.class, active=true, exportable=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode})
public class RTBLComponent
extends AbstractKernelBasedComponent {
    @Inject
    private RTBLRepository repository;
    @Inject(nullAllowed=true)
    private RTBLSubscribeModule subscribeModule;
    @Inject(nullAllowed=true)
    private RTBLFetchModule fetchModule;

    @Override
    public boolean isDiscoNonAdmin() {
        return false;
    }

    @Override
    protected void registerModules(Kernel kernel) {
        kernel.registerBean(AdHocCommandModule.class).exec();
        kernel.registerBean(DiscoveryModule.class).exec();
    }

    @Override
    public void start() {
        super.start();
        this.eventBus.registerAll(this);
    }

    @Override
    public void stop() {
        super.stop();
        this.eventBus.unregisterAll(this);
    }

    @Override
    public boolean isSubdomain() {
        return true;
    }

    @HandleEvent
    public void serverInitialized(ClusterConnectionManager.ClusterInitializedEvent event) {
        if (this.subscribeModule != null && this.fetchModule != null) {
            List<RTBL> blocklists = this.repository.getBlockLists();
            for (RTBL rtbl : blocklists) {
                this.subscribeModule.subscribe(rtbl.getJID(), rtbl.getNode());
                this.fetchModule.fetch(rtbl.getJID(), rtbl.getNode());
            }
        } else {
            this.log.warning("failed to initialize RTBLComponent - missing subscribeModule: " + String.valueOf(this.subscribeModule) + ", fetchModule: " + String.valueOf(this.fetchModule));
        }
    }
}

