/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.extdisco;

import tigase.db.comp.RepositoryItemAbstract;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xml.Element;

public class ExtServiceDiscoItem
extends RepositoryItemAbstract {
    private static final String KEY_LABEL = "Service";
    private static final String HOST_LABEL = "Host";
    private static final String NAME_LABEL = "Service name";
    private static final String PORT_LABEL = "Port";
    private static final String TRANSPORT_LABEL = "Transport";
    private static final String TYPE_LABEL = "Type";
    private static final String RESTRICTED_LABEL = "Requires username and password";
    private static final String USERNAME_LABEL = "Username";
    private static final String PASSWORD_LABEL = "Password";
    private String host;
    private String key;
    private String name;
    private String password;
    private Integer port;
    private boolean restricted;
    private String transport;
    private String type;
    private String username;

    @Override
    public void addCommandFields(Packet packet) {
        Command.addFieldValue(packet, KEY_LABEL, this.key != null ? this.key : "");
        Command.addFieldValue(packet, NAME_LABEL, this.name != null ? this.name : "");
        Command.addFieldValue(packet, HOST_LABEL, this.host != null ? this.host : "");
        Command.addFieldValue(packet, PORT_LABEL, this.port != null ? String.valueOf(this.port) : "");
        Command.addFieldValue(packet, TYPE_LABEL, this.type != null ? this.type : "");
        Command.addFieldValue(packet, TRANSPORT_LABEL, this.transport != null ? this.transport : "");
        Command.addCheckBoxField(packet, RESTRICTED_LABEL, this.restricted);
        Command.addFieldValue(packet, USERNAME_LABEL, this.username != null ? this.username : "");
        Command.addFieldValue(packet, PASSWORD_LABEL, this.password != null ? this.password : "");
    }

    @Override
    public String[] getAdmins() {
        return null;
    }

    @Override
    public void setAdmins(String[] admins) {
    }

    @Override
    public String getElemName() {
        return "service";
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    protected void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getOwner() {
        return null;
    }

    @Override
    public void setOwner(String owner) {
    }

    public String getType() {
        return this.type;
    }

    @Override
    public void initFromCommand(Packet packet) {
        String tmp = Command.getFieldValue(packet, KEY_LABEL);
        this.key = tmp != null && !(tmp = tmp.trim()).isEmpty() ? tmp : null;
        tmp = Command.getFieldValue(packet, NAME_LABEL);
        this.name = tmp != null && !(tmp = tmp.trim()).isEmpty() ? tmp : null;
        tmp = Command.getFieldValue(packet, HOST_LABEL);
        this.host = tmp != null && !(tmp = tmp.trim()).isEmpty() ? tmp : null;
        tmp = Command.getFieldValue(packet, PORT_LABEL);
        this.port = tmp != null && !(tmp = tmp.trim()).isEmpty() ? Integer.valueOf(Integer.parseInt(tmp)) : null;
        tmp = Command.getFieldValue(packet, TYPE_LABEL);
        this.type = tmp != null && !(tmp = tmp.trim()).isEmpty() ? tmp : null;
        tmp = Command.getFieldValue(packet, TRANSPORT_LABEL);
        this.transport = tmp != null && !(tmp = tmp.trim()).isEmpty() ? tmp : null;
        this.restricted = Command.getCheckBoxFieldValue(packet, RESTRICTED_LABEL);
        tmp = Command.getFieldValue(packet, USERNAME_LABEL);
        this.username = tmp != null && !(tmp = tmp.trim()).isEmpty() ? tmp : null;
        tmp = Command.getFieldValue(packet, PASSWORD_LABEL);
        this.password = tmp != null && !(tmp = tmp.trim()).isEmpty() ? tmp : null;
    }

    @Override
    public void initFromElement(Element elem) {
        this.key = elem.getAttributeStaticStr("key");
        this.host = elem.getAttributeStaticStr("host");
        this.type = elem.getAttributeStaticStr("type");
        String tmp = elem.getAttributeStaticStr("port");
        this.port = tmp != null ? Integer.valueOf(Integer.parseInt(tmp)) : null;
        this.name = elem.getAttributeStaticStr("name");
        this.transport = elem.getAttributeStaticStr("transport");
        this.restricted = "true".equals(elem.getAttributeStaticStr("restricted"));
        this.username = elem.getAttributeStaticStr("username");
        this.password = elem.getAttributeStaticStr("password");
    }

    @Override
    public void initFromPropertyString(String propString) {
        String[] tmp = propString.split(":");
        this.key = tmp[0];
        block20: for (String part : tmp) {
            int idx = part.indexOf("=");
            String key = part;
            String val = null;
            if (idx > -1) {
                val = part.substring(idx + 1);
                key = part.substring(0, idx);
            }
            switch (key) {
                case "host": {
                    this.host = val;
                    continue block20;
                }
                case "type": {
                    this.type = val;
                    continue block20;
                }
                case "port": {
                    this.port = val != null && !val.isEmpty() ? Integer.valueOf(Integer.parseInt(val)) : null;
                    continue block20;
                }
                case "name": {
                    this.name = val;
                    continue block20;
                }
                case "transport": {
                    this.transport = val;
                    continue block20;
                }
                case "restricted": {
                    this.restricted = "true".equals(val);
                    continue block20;
                }
                case "username": {
                    this.username = val;
                    continue block20;
                }
                case "password": {
                    this.password = val;
                    continue block20;
                }
            }
        }
    }

    @Override
    public boolean isAdmin(String id) {
        return false;
    }

    @Override
    public boolean isOwner(String id) {
        return false;
    }

    @Override
    public Element toElement() {
        Element service = new Element("service");
        service.setAttribute("key", this.key);
        service.setAttribute("host", this.host);
        service.setAttribute("type", this.type);
        if (this.port != null) {
            service.setAttribute("port", String.valueOf(this.port));
        }
        if (this.name != null) {
            service.setAttribute("name", this.name);
        }
        if (this.transport != null) {
            service.setAttribute("transport", this.transport);
        }
        if (this.restricted) {
            service.setAttribute("restricted", "true");
        }
        if (this.username != null) {
            service.setAttribute("username", this.username);
        }
        if (this.password != null) {
            service.setAttribute("password", this.password);
        }
        return service;
    }

    @Override
    public String toPropertyString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key);
        if (this.host != null) {
            sb.append(":host=").append(this.host);
        }
        if (this.type != null) {
            sb.append(":type=").append(this.type);
        }
        if (this.port != null) {
            sb.append(":port=").append(String.valueOf(this.port));
        }
        if (this.name != null) {
            sb.append(":name=").append(this.name);
        }
        if (this.transport != null) {
            sb.append(":transport=").append(this.transport);
        }
        if (this.restricted) {
            sb.append(":restricted=true");
        }
        if (this.username != null) {
            sb.append(":username=").append(this.username);
        }
        if (this.password != null) {
            sb.append(":password=").append(this.password);
        }
        return sb.toString();
    }
}

