/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.util.RepositoryVersionAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.amp.db.MsgBroadcastRepository;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(isDefault=true, supportedUris={"jdbc:[^:]+:.*"})
@Repository.SchemaId(id="server", name="Tigase XMPP Server (Core)")
public class JDBCMsgBroadcastRepository
extends MsgBroadcastRepository<Long, DataRepository>
implements RepositoryVersionAware {
    private static final Logger log = Logger.getLogger(JDBCMsgBroadcastRepository.class.getCanonicalName());
    @ConfigField(desc="Query to add message to broadcast messsages", alias="add-message")
    private String BROADCAST_ADD_MESSAGE = "{ call Tig_BroadcastMessages_AddMessage(?,?,?) }";
    @ConfigField(desc="Query to add message recipient to broadcast message", alias="add-message-recipient")
    private String BROADCAST_ADD_MESSAGE_RECIPIENT = "{ call Tig_BroadcastMessages_AddMessageRecipient(?,?) }";
    @ConfigField(desc="Query to load not expired broadcast messages", alias="get-messages")
    private String BROADCAST_GET_MESSAGES = "{ call Tig_BroadcastMessages_GetMessages(?) }";
    @ConfigField(desc="Query to load recipients of broadcast message", alias="get-message-recipients")
    private String BROADCAST_GET_MESSAGE_RECIPIENTS = "{ call Tig_BroadcastMessages_GetMessageRecipients(?) }";
    private DataRepository data_repo = null;

    @Override
    public void setDataSource(DataRepository data_repo) {
        try {
            data_repo.initPreparedStatement(this.BROADCAST_ADD_MESSAGE, this.BROADCAST_ADD_MESSAGE);
            data_repo.initPreparedStatement(this.BROADCAST_ADD_MESSAGE_RECIPIENT, this.BROADCAST_ADD_MESSAGE_RECIPIENT);
            data_repo.initPreparedStatement(this.BROADCAST_GET_MESSAGES, this.BROADCAST_GET_MESSAGES);
            data_repo.initPreparedStatement(this.BROADCAST_GET_MESSAGE_RECIPIENTS, this.BROADCAST_GET_MESSAGE_RECIPIENTS);
        }
        catch (SQLException ex) {
            log.log(Level.WARNING, "MsgRepository not initialized due to exception", ex);
        }
        this.data_repo = data_repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void loadMessagesToBroadcast() {
        try {
            HashSet oldMessages = new HashSet(this.broadcastMessages.keySet());
            ResultSet rs = null;
            PreparedStatement stmt = this.data_repo.getPreparedStatement(null, this.BROADCAST_GET_MESSAGES);
            Iterator iterator = stmt;
            synchronized (iterator) {
                try {
                    Timestamp ts = new Timestamp(System.currentTimeMillis());
                    log.log(Level.FINEST, "loading expiring after " + String.valueOf(ts));
                    this.data_repo.setTimestamp(stmt, 1, ts);
                    rs = stmt.executeQuery();
                    DomBuilderHandler domHandler = new DomBuilderHandler();
                    while (rs.next()) {
                        String msgId = rs.getString(1);
                        log.log(Level.FINEST, "loaded msg with id = " + msgId);
                        oldMessages.remove(msgId);
                        if (this.broadcastMessages.containsKey(msgId)) continue;
                        Timestamp expire = this.data_repo.getTimestamp(rs, 2);
                        char[] msgChars = rs.getString(3).toCharArray();
                        this.parser.parse((SimpleHandler)domHandler, msgChars, 0, msgChars.length);
                        Queue elems = domHandler.getParsedElements();
                        Element msg = (Element)elems.poll();
                        if (msg == null) {
                            log.log(Level.FINEST, "not adding - msg is null!");
                            continue;
                        }
                        this.broadcastMessages.put(msgId, new MsgBroadcastRepository.BroadcastMsg<Object>(this, null, msg, expire));
                    }
                    log.log(Level.FINEST, "message loading finished!");
                    this.data_repo.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
            }
            for (String id : oldMessages) {
                this.broadcastMessages.remove(id);
            }
            rs = null;
            for (String id : this.broadcastMessages.keySet()) {
                MsgBroadcastRepository.BroadcastMsg bmsg = (MsgBroadcastRepository.BroadcastMsg)this.broadcastMessages.get(id);
                PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(null, this.BROADCAST_GET_MESSAGE_RECIPIENTS);
                synchronized (preparedStatement) {
                    try {
                        stmt.setString(1, id);
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            BareJID jid = BareJID.bareJIDInstanceNS((String)rs.getString(1));
                            bmsg.addRecipient(jid);
                        }
                    }
                    finally {
                        this.data_repo.release(null, rs);
                    }
                }
            }
            return;
        }
        catch (SQLException ex) {
            log.log(Level.WARNING, "Problem with retrieving broadcast messages", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertBroadcastMessage(String id, Element msg, Date expire, BareJID recipient) {
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(recipient, this.BROADCAST_ADD_MESSAGE);
            synchronized (preparedStatement) {
                stmt.setString(1, id);
                this.data_repo.setTimestamp(stmt, 2, new Timestamp(expire.getTime()));
                stmt.setString(3, msg.toString());
                stmt.executeUpdate();
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem with updating broadcast message", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ensureBroadcastMessageRecipient(String id, BareJID recipient) {
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(recipient, this.BROADCAST_ADD_MESSAGE_RECIPIENT);
            synchronized (preparedStatement) {
                stmt.setString(1, id);
                stmt.setString(2, recipient.toString());
                stmt.executeUpdate();
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem with updating broadcast message", ex);
        }
    }
}

