/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class JidResourceMap<T> {
    private final ConcurrentHashMap<BareJID, Map<String, T>> usersMap = new ConcurrentHashMap();

    public boolean containsKey(BareJID jid) {
        return this.usersMap.containsKey(jid);
    }

    public boolean containsKey(JID jid) {
        Map<String, T> resources = this.usersMap.get(jid.getBareJID());
        return resources != null && resources.containsKey(jid.getResource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(JID jid) {
        Map<String, T> resources = this.usersMap.get(jid.getBareJID());
        if (resources == null) {
            return null;
        }
        Map<String, T> map = resources;
        synchronized (map) {
            return resources.get(jid.getResource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T put(JID jid, T value) {
        if (value == null) {
            return this.remove(jid);
        }
        Map<String, T> resources = this.usersMap.get(jid.getBareJID());
        if (resources == null) {
            resources = new HashMap<String, T>();
            Map<String, T> oldResources = this.usersMap.putIfAbsent(jid.getBareJID(), resources);
            if (oldResources != null) {
                resources = oldResources;
            }
        }
        if (jid.getResource() != null) {
            Map<String, T> map = resources;
            synchronized (map) {
                return resources.put(jid.getResource(), value);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(JID jid) {
        Map<String, T> resources = this.usersMap.get(jid.getBareJID());
        if (resources == null) {
            return null;
        }
        Map<String, T> map = resources;
        synchronized (map) {
            return resources.remove(jid.getResource());
        }
    }
}

