/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tigase.conf.ConfigurationException;
import tigase.server.BasicComponent;
import tigase.server.ComponentRegistrator;
import tigase.server.ServerComponent;

public abstract class AbstractComponentRegistrator<E extends ServerComponent>
extends BasicComponent
implements ComponentRegistrator {
    protected Map<String, E> components = new ConcurrentHashMap<String, E>();
    private long packetId = 0L;

    public abstract void componentAdded(E var1) throws ConfigurationException;

    public abstract void componentRemoved(E var1);

    public abstract boolean isCorrectType(ServerComponent var1);

    @Override
    public boolean addComponent(ServerComponent component) throws ConfigurationException {
        if (this.isCorrectType(component)) {
            this.components.put(component.getName(), component);
            this.componentAdded(component);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteComponent(ServerComponent component) {
        if (this.isCorrectType(component)) {
            this.components.remove(component.getName());
            this.componentRemoved(component);
        }
        return true;
    }

    public E getComponent(String name) {
        return (E)((ServerComponent)this.components.get(name));
    }

    public String newPacketId(String prefix) {
        StringBuilder sb = new StringBuilder(32);
        if (prefix != null) {
            sb.append(prefix).append("-");
        }
        sb.append(this.getName()).append(++this.packetId);
        return sb.toString();
    }

    @Override
    public void release() {
    }
}

