/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.HashSet;
import java.util.Map;
import tigase.eventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.InfoTask;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTimerTask;
import tigase.monitor.tasks.TasksEvent;
import tigase.server.monitor.MonitorRuntime;
import tigase.util.datetime.TimestampHelper;

@Bean(name="memory-checker-task", parent=MonitorComponent.class, active=true)
public class MemoryCheckerTask
extends AbstractConfigurableTimerTask
implements InfoTask,
Initializable {
    public static final String HEAP_MEMORY_MONITOR_EVENT_NAME = "tigase.monitor.tasks.HeapMemoryMonitorEvent";
    public static final String NONHEAP_MEMORY_MONITOR_EVENT_NAME = "tigase.monitor.tasks.NonHeapMemoryMonitorEvent";
    private static final TimestampHelper dtf = new TimestampHelper();
    private final HashSet<String> triggeredEvents = new HashSet();
    @Inject
    private MonitorComponent component;
    @Inject
    private EventBus eventBus;
    @ConfigField(desc="Max Heap Mem Usage Threshold [%]")
    private int maxHeapMemUsagePercentThreshold = 90;
    @ConfigField(desc="Max Non-Heap Mem Usage Threshold [%]")
    private int maxNonHeapMemUsagePercentThreshold = 90;
    @Inject
    private MonitorRuntime runtime;

    @Override
    public Form getCurrentConfiguration() {
        Form form = super.getCurrentConfiguration();
        form.addField(Field.fieldTextSingle((String)"maxHeapMemUsagePercentThreshold", (String)String.valueOf(this.maxHeapMemUsagePercentThreshold), (String)"Alarm when heap mem usage is bigger than [%]"));
        form.addField(Field.fieldTextSingle((String)"maxNonHeapMemUsagePercentThreshold", (String)String.valueOf(this.maxNonHeapMemUsagePercentThreshold), (String)"Alarm when non-heap mem usage is bigger than [%]"));
        return form;
    }

    public int getMaxHeapMemUsagePercentThreshold() {
        return this.maxHeapMemUsagePercentThreshold;
    }

    public void setMaxHeapMemUsagePercentThreshold(Integer maxHeapMemUsagePercentThreshold) {
        this.maxHeapMemUsagePercentThreshold = maxHeapMemUsagePercentThreshold;
    }

    public int getMaxNonHeapMemUsagePercentThreshold() {
        return this.maxNonHeapMemUsagePercentThreshold;
    }

    public void setMaxNonHeapMemUsagePercentThreshold(Integer maxNonHeapMemUsagePercentThreshold) {
        this.maxNonHeapMemUsagePercentThreshold = maxNonHeapMemUsagePercentThreshold;
    }

    @Override
    public Form getTaskInfo() {
        Form result = new Form("", "Memory Information", "");
        result.addField(Field.fieldTextSingle((String)"heapMemMax", (String)Long.toString(this.runtime.getHeapMemMax()), (String)"Heap Memory Max"));
        result.addField(Field.fieldTextSingle((String)"heapMemUsed", (String)Long.toString(this.runtime.getHeapMemUsed()), (String)"Heap Memory Used"));
        result.addField(Field.fieldTextSingle((String)"heapMemUsedPercentage", (String)Float.toString(this.runtime.getHeapMemUsage()), (String)"Heap Memory Used [%]"));
        result.addField(Field.fieldTextSingle((String)"nonHeapMemMax", (String)Long.toString(this.runtime.getNonHeapMemMax()), (String)"Non-Heap Memory Max"));
        result.addField(Field.fieldTextSingle((String)"nonHeapMemUsed", (String)Long.toString(this.runtime.getNonHeapMemUsed()), (String)"Non-Heap Memory Used"));
        result.addField(Field.fieldTextSingle((String)"nonHeapMemUsedPercentage", (String)Float.toString(this.runtime.getNonHeapMemUsage()), (String)"Non-Heap Memory Used [%]"));
        result.addField(Field.fieldTextSingle((String)"directMemUsed", (String)Long.toString(this.runtime.getDirectMemUsed()), (String)"Direct Memory Used"));
        return result;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.eventBus.registerEvent(MemoryCheckerTaskEvent.class, "Fired when HEAP memory is too low", false);
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field nonHeapMemUsage;
        Field heapMemUsage = form.get("maxHeapMemUsagePercentThreshold");
        if (heapMemUsage != null) {
            this.maxHeapMemUsagePercentThreshold = Integer.parseInt(heapMemUsage.getValue());
        }
        if ((nonHeapMemUsage = form.get("maxNonHeapMemUsagePercentThreshold")) != null) {
            this.maxNonHeapMemUsagePercentThreshold = Integer.parseInt(nonHeapMemUsage.getValue());
        }
        super.setNewConfiguration(form);
    }

    @Override
    protected void run() {
        MemoryCheckerTaskEvent event;
        float curHeapMemUsagePercent = this.runtime.getHeapMemUsage();
        float curNonHeapMemUsagePercent = this.runtime.getNonHeapMemUsage();
        if (curHeapMemUsagePercent >= (float)this.maxHeapMemUsagePercentThreshold) {
            event = new MemoryCheckerTaskEvent(HEAP_MEMORY_MONITOR_EVENT_NAME, "Fired when HEAP memory is too low", curHeapMemUsagePercent, curNonHeapMemUsagePercent, this.runtime.getHeapMemMax(), this.runtime.getHeapMemUsed(), this.runtime.getNonHeapMemMax(), this.runtime.getNonHeapMemUsed(), this.runtime.getDirectMemUsed(), "Heap memory usage is higher than " + this.maxHeapMemUsagePercentThreshold + " and it equals " + curHeapMemUsagePercent);
            if (!this.triggeredEvents.contains(event.getName())) {
                this.eventBus.fire(event);
                this.triggeredEvents.add(event.getName());
            }
        } else {
            this.triggeredEvents.remove(HEAP_MEMORY_MONITOR_EVENT_NAME);
        }
        if (curNonHeapMemUsagePercent >= (float)this.maxNonHeapMemUsagePercentThreshold) {
            event = new MemoryCheckerTaskEvent(NONHEAP_MEMORY_MONITOR_EVENT_NAME, "Fired when Non-HEAP memory is too low", curHeapMemUsagePercent, curNonHeapMemUsagePercent, this.runtime.getHeapMemMax(), this.runtime.getHeapMemUsed(), this.runtime.getNonHeapMemMax(), this.runtime.getNonHeapMemUsed(), this.runtime.getDirectMemUsed(), "Heap memory usage is higher than " + this.maxNonHeapMemUsagePercentThreshold + " and it equals " + curNonHeapMemUsagePercent);
            if (!this.triggeredEvents.contains(event.getName())) {
                this.eventBus.fire(event);
                this.triggeredEvents.add(event.getName());
            }
        } else {
            this.triggeredEvents.remove(NONHEAP_MEMORY_MONITOR_EVENT_NAME);
        }
    }

    static class MemoryCheckerTaskEvent
    extends TasksEvent {
        float heapMemUsage;
        float nonHeapMemUsage;
        long heapMemMax;
        long heapMemUsed;
        long nonHeapMemMax;
        long nonHeapMemUsed;
        long directMemUsed;
        String message;

        public MemoryCheckerTaskEvent(String name, String description) {
            super(name, description);
        }

        public MemoryCheckerTaskEvent(String name, String description, float heapMemUsage, float nonHeapMemUsage, long heapMemMax, long heapMemUsed, long nonHeapMemMax, long nonHeapMemUsed, long directMemUsed, String message) {
            super(name, description);
            this.heapMemUsage = heapMemUsage;
            this.nonHeapMemUsage = nonHeapMemUsage;
            this.heapMemMax = heapMemMax;
            this.heapMemUsed = heapMemUsed;
            this.nonHeapMemMax = nonHeapMemMax;
            this.nonHeapMemUsed = nonHeapMemUsed;
            this.directMemUsed = directMemUsed;
            this.message = message;
        }

        @Override
        public Map<String, String> getAdditionalData() {
            return Map.of("heapMemUsage", Float.toString(this.heapMemUsage), "nonHeapMemUsage", Float.toString(this.nonHeapMemUsage), "heapMemMax", Long.toString(this.heapMemMax), "heapMemUsed", Long.toString(this.heapMemUsed), "nonHeapMemMax", Long.toString(this.nonHeapMemMax), "nonHeapMemUsed", Long.toString(this.nonHeapMemUsed), "directMemUsed", Long.toString(this.directMemUsed), "message", this.message);
        }

        public float getHeapMemUsage() {
            return this.heapMemUsage;
        }

        public float getNonHeapMemUsage() {
            return this.nonHeapMemUsage;
        }

        public long getHeapMemMax() {
            return this.heapMemMax;
        }

        public long getHeapMemUsed() {
            return this.heapMemUsed;
        }

        public long getNonHeapMemMax() {
            return this.nonHeapMemMax;
        }

        public long getNonHeapMemUsed() {
            return this.nonHeapMemUsed;
        }

        public long getDirectMemUsed() {
            return this.directMemUsed;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

