/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.modules;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.Kernel;
import tigase.monitor.ConfigurableTask;
import tigase.monitor.MonitorComponent;
import tigase.monitor.TasksScriptRegistrar;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="x-config", parent=MonitorComponent.class, active=true)
public class ConfigureTaskCommand
implements AdHocCommand {
    private static final Logger log = Logger.getLogger(ConfigureTaskCommand.class.getName());
    public static final String NODE = "x-config";
    @Inject
    private MonitorComponent component;
    @Inject(bean="kernel")
    private Kernel kernel;
    @Inject
    private TasksScriptRegistrar registrar;

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                ConfigurableTask taskInstance = (ConfigurableTask)this.kernel.getInstance(request.getIq().getStanzaTo().getResource());
                Form form = taskInstance.getCurrentConfiguration();
                form.setType("form");
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    ConfigurableTask taskInstance = (ConfigurableTask)this.kernel.getInstance(request.getIq().getStanzaTo().getResource());
                    this.registrar.updateConfig(request.getIq().getStanzaTo().getResource(), form);
                    form = new Form("form", "Completed", null);
                    form.addField(Field.fieldFixed((String)"Script configured"));
                    response.getElements().add(form.getElement());
                    response.completeSession();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Error configuring task", e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return "Task config";
    }

    @Override
    public String getNode() {
        return NODE;
    }

    @Override
    public boolean isAllowedFor(JID jid) {
        return this.component.isAdmin(jid);
    }
}

