/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.beans.selector;

import java.util.Arrays;
import java.util.List;
import tigase.kernel.beans.BeanSelector;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;

public class ServerBeanSelector
implements BeanSelector {
    private static boolean checkClusterMode(Class clazz, Kernel kernel) {
        ClusterModeRequired clusterModeRequired = clazz.getAnnotation(ClusterModeRequired.class);
        return clusterModeRequired == null || clusterModeRequired.active() == ServerBeanSelector.getClusterMode(kernel);
    }

    private static boolean checkConfigType(Class clazz, Kernel kernel) {
        ConfigType configType = clazz.getAnnotation(ConfigType.class);
        if (configType == null) {
            return true;
        }
        List<ConfigTypeEnum> supportedTypes = Arrays.asList(configType.value());
        ConfigTypeEnum activeConfigType = ServerBeanSelector.getConfigType(kernel);
        return supportedTypes.contains((Object)activeConfigType);
    }

    public static boolean getClusterMode(Kernel kernel) {
        Boolean val = ServerBeanSelector.getProperty(kernel, "cluster-mode", false);
        if (val instanceof Boolean) {
            return val;
        }
        return Boolean.valueOf((String)((Object)val));
    }

    public static ConfigTypeEnum getConfigType(Kernel kernel) {
        while (kernel.getParent() != null) {
            kernel = kernel.getParent();
        }
        return ConfigTypeEnum.valueForId(switch (type = ServerBeanSelector.getProperty(kernel, "config-type", "default")) {
            case "--gen-config-def", "--gen-config-default" -> "default";
        });
    }

    protected static <T> T getProperty(Kernel kernel, String name, T defValue) {
        if (kernel.isBeanClassRegistered("defaultBeanConfigurator")) {
            return (T)kernel.getInstance(AbstractBeanConfigurator.class).getProperties().getOrDefault(name, defValue);
        }
        return defValue;
    }

    @Override
    public boolean shouldRegister(Class clazz, Kernel kernel) {
        return ServerBeanSelector.checkClusterMode(clazz, kernel) && ServerBeanSelector.checkConfigType(clazz, kernel);
    }
}

