/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.component.DSLBeanConfigurator;
import tigase.component.DSLBeanConfiguratorWithBackwardCompatibility;
import tigase.component.exceptions.RepositoryException;
import tigase.conf.ConfigBuilder;
import tigase.conf.ConfigHolder;
import tigase.conf.ConfigReader;
import tigase.conf.ConfigWriter;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.Repository;
import tigase.db.beans.DataSourceBean;
import tigase.db.beans.MDPoolBean;
import tigase.db.beans.MDPoolConfigBean;
import tigase.db.beans.MDRepositoryBean;
import tigase.db.beans.SDRepositoryBean;
import tigase.db.beans.UserRepositoryMDPoolBean;
import tigase.db.util.DBSchemaLoader;
import tigase.db.util.JDBCPasswordObfuscator;
import tigase.db.util.RepositoryVersionAware;
import tigase.db.util.SchemaLoader;
import tigase.db.util.SchemaManagerLogHandler;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.beans.selector.ServerBeanSelector;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.Kernel;
import tigase.kernel.core.RegistrarKernel;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.XMPPServer;
import tigase.server.monitor.MonitorRuntime;
import tigase.sys.TigaseRuntime;
import tigase.util.Version;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.reflection.ClassUtilBean;
import tigase.util.setup.BeanDefinition;
import tigase.util.setup.SetupHelper;
import tigase.util.ui.console.CommandlineParameter;
import tigase.util.ui.console.ParameterParser;
import tigase.util.ui.console.Task;
import tigase.xmpp.jid.BareJID;

public class SchemaManager {
    protected static final Class[] SUPPORTED_CLASSES = new Class[]{MDPoolBean.class, MDRepositoryBean.class, SDRepositoryBean.class};
    public static final String COMMON_SCHEMA_ID = "common";
    public static final String COMMON_SCHEMA_VERSION = "0.0.3";
    private static final Logger log = Logger.getLogger(SchemaManager.class.getCanonicalName());
    private static final Comparator<SchemaInfo> SCHEMA_INFO_COMPARATOR = (o1, o2) -> {
        if (o1.getId().equals("<unknown>") || o2.getId().equals("server")) {
            return 1;
        }
        if (o2.getId().equals("<unknown>") || o1.getId().equals("server")) {
            return -1;
        }
        return o1.getId().compareTo(o2.getId());
    };
    private CommandlineParameter COMPONENTS = new CommandlineParameter.Builder("C", "components").description("List of enabled components identifiers (+/-)").defaultValue(SchemaManager.getActiveNonCoreComponentNames().sorted().collect(Collectors.joining(","))).options((String[])SchemaManager.getNonCoreComponentNames().sorted().toArray(String[]::new)).build();
    private CommandlineParameter PROPERTY_CONFIG_FILE = new CommandlineParameter.Builder(null, "--property-file".replace("--", "")).defaultValue("etc/init.properties").description("Path to properties configuration file").requireArguments(true).build();
    private CommandlineParameter ROOT_PASSWORD = new CommandlineParameter.Builder("A", DBSchemaLoader.PARAMETERS_ENUM.ROOT_PASSWORD.getName()).description("Database root account password used to create/remove tigase user and database").secret().build();
    private CommandlineParameter ROOT_USERNAME = new CommandlineParameter.Builder("R", DBSchemaLoader.PARAMETERS_ENUM.ROOT_USERNAME.getName()).description("Database root account username used to create/remove tigase user and database").build();
    private CommandlineParameter ROOT_ASK = new CommandlineParameter.Builder(null, DBSchemaLoader.PARAMETERS_ENUM.ROOT_ASK.getName()).description("Ask for database root account credentials.").build();
    private CommandlineParameter TDSL_CONFIG_FILE = new CommandlineParameter.Builder(null, "--config-file".replace("--", "")).defaultValue(ConfigHolder.TDSL_CONFIG_FILE_DEF).description("Path to DSL configuration file").requireArguments(true).build();
    private CommandlineParameter LOG_LEVEL = new CommandlineParameter.Builder("L", DBSchemaLoader.PARAMETERS_ENUM.LOG_LEVEL.getName()).description("Java Logger level during loading process").defaultValue(DBSchemaLoader.PARAMETERS_ENUM.LOG_LEVEL.getDefaultValue()).build();
    private CommandlineParameter FORCE_RELOAD_SCHEMA = new CommandlineParameter.Builder(null, DBSchemaLoader.PARAMETERS_ENUM.FORCE_RELOAD_ALL_SCHEMA_FILES.getName()).description("Force reloading all schema files").defaultValue(DBSchemaLoader.PARAMETERS_ENUM.FORCE_RELOAD_ALL_SCHEMA_FILES.getDefaultValue()).build();
    private CommandlineParameter ADMIN_JID = new CommandlineParameter.Builder("J", DBSchemaLoader.PARAMETERS_ENUM.ADMIN_JID.getName()).description("Comma separated list of administrator JID(s)").build();
    private CommandlineParameter ADMIN_JID_PASS = new CommandlineParameter.Builder("N", DBSchemaLoader.PARAMETERS_ENUM.ADMIN_JID_PASS.getName()).description("Password that will be used for the entered JID(s) - one for all configured administrators").secret().build();
    private Boolean dbRootAsk = false;
    private String adminPass = null;
    private List<BareJID> admins = null;
    private Map<String, Object> config;
    private Level logLevel = Level.CONFIG;
    private boolean forceReloadSchema = false;
    private RootCredentialsCache rootCredentialsCache = new RootCredentialsCache();

    private static Stream<String> getActiveNonCoreComponentNames() {
        return SetupHelper.getAvailableComponents().stream().filter(BeanDefinition::isActive).filter(def -> !def.isCoreComponent()).map(BeanDefinition::getName);
    }

    private static Stream<String> getNonCoreComponentNames() {
        return SetupHelper.getAvailableComponents().stream().filter(def -> !def.isCoreComponent()).map(BeanDefinition::getName);
    }

    public static Optional<String> getProperty(Properties props, CommandlineParameter parameter) {
        Optional<String> value = Optional.ofNullable(props.getProperty((String)parameter.getFullName(false).get()));
        if (!value.isPresent()) {
            return parameter.getDefaultValue();
        }
        return value;
    }

    public static <T> Optional<T> getProperty(Properties props, CommandlineParameter parameter, Function<String, T> converter) {
        Optional<String> value = SchemaManager.getProperty(props, parameter);
        if (!value.isPresent()) {
            return Optional.empty();
        }
        T result = converter.apply(value.get());
        return Optional.ofNullable(result);
    }

    public static List<Class<?>> getRepositoryClasses() {
        return ClassUtilBean.getInstance().getAllClasses().stream().filter(clazz -> Arrays.stream(SUPPORTED_CLASSES).anyMatch(supClazz -> supClazz.isAssignableFrom((Class<?>)clazz))).filter(clazz -> {
            Bean bean = clazz.getAnnotation(Bean.class);
            return bean != null && (bean.parent() != Object.class || bean.parents().length > 0);
        }).filter(clazz -> !DataSourceBean.class.isAssignableFrom((Class<?>)clazz)).collect(Collectors.toList());
    }

    public static void main(String[] args) throws IOException, ConfigReader.ConfigException {
        try {
            SchemaManager schemaManager = new SchemaManager();
            schemaManager.execute(args);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error while loading schema", ex);
        }
        finally {
            System.exit(0);
        }
    }

    public SchemaManager() {
        List<Class<?>> repositoryClasses = SchemaManager.getRepositoryClasses();
        log.log(Level.FINE, "found following data source related classes: {0}", repositoryClasses);
    }

    public void execute(String[] args) throws Exception {
        Properties props;
        ParameterParser parser;
        String scriptName;
        block5: {
            scriptName = System.getProperty("scriptName");
            parser = new ParameterParser(true);
            parser.setTasks(new Task[]{new Task.Builder().name("upgrade-schema").description("Upgrade schema of databases specified in your config file - it's not possible to specify parameters").additionalParameterSupplier(this::upgradeSchemaParametersSupplier).function(this::upgradeSchema).build(), new Task.Builder().name("install-schema").description("Install schema to database - it requires specifying database parameters where schema will be installed (config file will be ignored)").additionalParameterSupplier(this::installSchemaParametersSupplier).function(this::installSchema).build(), new Task.Builder().name("destroy-schema").description("Destroy database and schemas (DANGEROUS)").additionalParameterSupplier(this::destroySchemaParametersSupplier).function(this::destroySchema).build()});
            props = null;
            try {
                props = parser.parseArgs(args);
            }
            catch (IllegalArgumentException ex) {
                if (!log.isLoggable(Level.FINEST)) break block5;
                log.log(Level.FINEST, ex.getMessage(), ex);
            }
        }
        Optional task = parser.getTask();
        if (props != null && task.isPresent()) {
            ((Task)task.get()).execute(props);
        } else {
            String executionCommand = null;
            if (scriptName != null) {
                executionCommand = "$ " + scriptName + " [task] [params-file.conf] [options]\n\t\tif the option defines default then <value> is optional";
            }
            System.out.println(parser.getHelp(executionCommand));
        }
    }

    public void destroySchema(Properties props) throws IOException, ConfigReader.ConfigException {
        SchemaManager.fixShutdownThreadIssue();
        String type = props.getProperty(DBSchemaLoader.PARAMETERS_ENUM.DATABASE_TYPE.getName());
        Map<String, Object> config = null;
        Optional<String[]> conversionMessages = Optional.empty();
        if (type != null) {
            SchemaLoader loader = SchemaLoader.newInstance(type);
            Object params = loader.createParameters();
            params.setProperties(props);
            loader.init(params, Optional.ofNullable(this.rootCredentialsCache));
            String dbUri = loader.getDBUri();
            String vhost = DNSResolverFactory.getInstance().getDefaultHost();
            ConfigBuilder configBuilder = SetupHelper.generateConfig(ConfigTypeEnum.DefaultMode, dbUri, false, false, Optional.empty(), Optional.empty(), Optional.empty(), vhost, Optional.empty(), Optional.empty());
            config = (Map<String, Object>)configBuilder.build();
        } else {
            ConfigHolder holder = new ConfigHolder();
            conversionMessages = holder.loadConfiguration(new String[]{"--property-file", (String)this.PROPERTY_CONFIG_FILE.getValue().get(), "--config-file", (String)this.TDSL_CONFIG_FILE.getValue().get()});
            config = holder.getProperties();
        }
        Optional<String> rootUser = SchemaManager.getProperty(props, this.ROOT_USERNAME);
        Optional<String> rootPass = SchemaManager.getProperty(props, this.ROOT_PASSWORD);
        this.setConfig(config);
        if (rootUser.isPresent() && rootPass.isPresent()) {
            this.setDbRootCredentials(rootUser.get(), rootPass.get());
        }
        SchemaManager.getProperty(props, this.LOG_LEVEL, Level::parse).ifPresent(result -> {
            this.logLevel = result;
        });
        Map<String, DataSourceInfo> result2 = SchemaManager.getDataSources(config);
        log.log(Level.INFO, "found " + result2.size() + " data sources to destroy...");
        Map<DataSourceInfo, List<ResultEntry>> results = this.destroySchemas(result2.values());
        log.log(Level.INFO, "data sources  destruction finished!");
        List<String> output = this.prepareOutput("Data source destruction finished", results, conversionMessages);
        int exitCode = this.isErrorPresent(results) ? 1 : 0;
        String[] message = output.toArray(new String[output.size()]);
        TigaseRuntime.getTigaseRuntime().shutdownTigase(message, exitCode);
    }

    public void installSchema(Properties props) throws IOException, ConfigReader.ConfigException {
        String type = props.getProperty(DBSchemaLoader.PARAMETERS_ENUM.DATABASE_TYPE.getName());
        SchemaLoader loader = SchemaLoader.newInstance(type);
        Object params = loader.createParameters();
        params.setProperties(props);
        loader.init(params, Optional.ofNullable(this.rootCredentialsCache));
        String dbUri = loader.getDBUri();
        Function<String, List> stringToListFunction = listStr -> Arrays.asList(listStr.split(","));
        Function<String, String> signRemovingFunction = v -> v.startsWith("-") || v.startsWith("+") ? v.substring(1) : v;
        Map changes = SchemaManager.getProperty(props, this.COMPONENTS, stringToListFunction).orElse(Collections.emptyList()).stream().collect(Collectors.groupingBy(v -> v.startsWith("-") ? "-" : "+", Collectors.mapping(signRemovingFunction, Collectors.toSet())));
        Set components = SchemaManager.getActiveNonCoreComponentNames().collect(Collectors.toSet());
        changes.forEach((k, v) -> {
            switch (k) {
                case "+": {
                    components.addAll(v);
                    break;
                }
                case "-": {
                    components.removeAll((Collection<?>)v);
                }
            }
        });
        this.admins = params.getAdmins();
        this.adminPass = params.getAdminPassword();
        this.dbRootAsk = params.isDbRootAsk();
        this.logLevel = params.getLogLevel();
        String vhost = DNSResolverFactory.getInstance().getDefaultHost();
        ConfigBuilder configBuilder = SetupHelper.generateConfig(ConfigTypeEnum.DefaultMode, dbUri, false, false, Optional.ofNullable(components), Optional.ofNullable(changes.get("+")), Optional.empty(), vhost, Optional.of(params.getAdmins().toArray(new BareJID[params.getAdmins().size()])), Optional.empty());
        Object config = configBuilder.build();
        Map<DataSourceInfo, List<ResultEntry>> results = this.loadSchemas((Map<String, Object>)config, props);
        List<String> output = this.prepareOutput("Schema installation finished", results, Optional.empty());
        output.add("");
        output.add("Example " + ConfigHolder.TDSL_CONFIG_FILE_DEF + " configuration file:");
        output.add("");
        try (StringWriter writer = new StringWriter();){
            new ConfigWriter().write(writer, (Map<String, Object>)config);
            output.addAll(Arrays.stream(writer.toString().split("\n")).collect(Collectors.toList()));
        }
        int exitCode = this.isErrorPresent(results) ? 1 : 0;
        String[] message = output.toArray(new String[output.size()]);
        TigaseRuntime.getTigaseRuntime().shutdownTigase(message, exitCode);
    }

    public void upgradeSchema(Properties props) throws IOException, ConfigReader.ConfigException {
        ConfigHolder holder = new ConfigHolder();
        Optional<String[]> conversionMessages = holder.loadConfiguration(new String[]{"--property-file", (String)this.PROPERTY_CONFIG_FILE.getValue().get(), "--config-file", (String)this.TDSL_CONFIG_FILE.getValue().get()});
        Map<String, Object> config = holder.getProperties();
        this.admins = SchemaManager.getProperty(props, this.ADMIN_JID).map(str -> Arrays.stream(str.split(",")).map(BareJID::bareJIDInstanceNS).collect(Collectors.toList())).orElse(null);
        this.adminPass = SchemaManager.getProperty(props, this.ADMIN_JID_PASS).orElse(null);
        this.dbRootAsk = SchemaManager.getProperty(props, this.ROOT_ASK, Boolean::parseBoolean).orElse(false);
        SchemaManager.getProperty(props, this.LOG_LEVEL, Level::parse).ifPresent(result -> {
            this.logLevel = result;
        });
        SchemaManager.getProperty(props, this.FORCE_RELOAD_SCHEMA, Boolean::parseBoolean).ifPresent(result -> {
            this.forceReloadSchema = result;
        });
        Map<DataSourceInfo, List<ResultEntry>> results = this.loadSchemas(config, props);
        List<String> output = this.prepareOutput("Schema upgrade finished", results, conversionMessages);
        int exitCode = this.isErrorPresent(results) ? 1 : 0;
        String[] message = output.toArray(new String[output.size()]);
        TigaseRuntime.getTigaseRuntime().shutdownTigase(message, exitCode);
    }

    public void readConfig(File file) throws IOException, ConfigReader.ConfigException {
        this.config = new ConfigReader().read(file);
    }

    public void readConfig(String configString) throws IOException, ConfigReader.ConfigException {
        try (StringReader reader = new StringReader(configString);){
            this.readConfig(reader);
        }
    }

    public void readConfig(Reader reader) throws IOException, ConfigReader.ConfigException {
        this.config = new ConfigReader().read(reader);
    }

    public void setAdmins(List<BareJID> admins, String adminPass) {
        this.admins = admins;
        this.adminPass = adminPass;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public void setDbRootCredentials(String user, String pass) {
        this.rootCredentialsCache.set(null, new RootCredentials(user, pass));
    }

    public static Map<DataSourceInfo, List<SchemaInfo>> getDefaultDataSourceAndSchemas(String dbUri) {
        return SchemaManager.getDefaultDataSourceAndSchemas(dbUri, SchemaManager.getActiveNonCoreComponentNames().collect(Collectors.toSet()));
    }

    private static Map<DataSourceInfo, List<SchemaInfo>> getDefaultDataSourceAndSchemas(String dbUri, Set<String> components) {
        ConfigBuilder configBuilder = SetupHelper.generateConfig(ConfigTypeEnum.DefaultMode, dbUri, false, false, Optional.ofNullable(components), Optional.empty(), Optional.empty(), "example.com", Optional.empty(), Optional.empty());
        Object config = configBuilder.build();
        return SchemaManager.getDataSourcesAndSchemas(config);
    }

    public static Optional<SchemaInfo> getDefaultSchemaFor(String dbUri, String schemaId, Set<String> components) {
        return SchemaManager.getDefaultDataSourceAndSchemas(dbUri, components).values().stream().flatMap(value -> value.stream()).filter(schema -> schemaId.equals(schema.getId())).findFirst();
    }

    public static Map<DataSourceInfo, List<SchemaInfo>> getDataSourcesAndSchemas(Map<String, Object> config) {
        Kernel kernel = SchemaManager.prepareKernel(config);
        List<BeanConfig> repoBeans = SchemaManager.getRepositoryBeans(kernel, SchemaManager.getRepositoryClasses(), config);
        List<RepoInfo> repositories = SchemaManager.getRepositories(kernel, repoBeans, config);
        Map<DataSourceInfo, List<RepoInfo>> repositoriesByDataSource = repositories.stream().collect(Collectors.groupingBy(RepoInfo::getDataSource, Collectors.toList()));
        return SchemaManager.collectSchemasByDataSource(repositoriesByDataSource);
    }

    public Map<DataSourceInfo, List<ResultEntry>> destroySchemas(Collection<DataSourceInfo> dataSources) {
        return dataSources.stream().map(e -> new Pair<DataSourceInfo, List<ResultEntry>>((DataSourceInfo)e, e.automaticSchemaManagement() ? this.destroySchemas((DataSource)e) : Collections.singletonList(new ResultEntry("Destroying data source", SchemaLoader.Result.skipped, "Automatic schema management is disabled for this data source!")))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public List<ResultEntry> destroySchemas(DataSource ds) {
        return this.executeWithSchemaLoader(ds, (schemaLoader, handler) -> {
            ArrayList<ResultEntry> results = new ArrayList<ResultEntry>();
            log.log(Level.FINEST, "removing database for data source " + String.valueOf(ds));
            results.add(new ResultEntry("Destroying data source", schemaLoader.destroyDataSource(), handler));
            return results;
        });
    }

    public Map<DataSourceInfo, List<ResultEntry>> loadSchemas() {
        Map<DataSourceInfo, List<SchemaInfo>> dataSourceSchemas = SchemaManager.getDataSourcesAndSchemas(this.config);
        Map<DataSourceInfo, List> upgradeSupportResults = dataSourceSchemas.entrySet().stream().filter(e -> ((DataSourceInfo)e.getKey()).automaticSchemaManagement()).map(e -> new Pair<DataSourceInfo, List<ResultEntry>>((DataSourceInfo)e.getKey(), this.checkUpgradeSupport((DataSource)e.getKey(), (List)e.getValue()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        if (upgradeSupportResults.values().stream().flatMap(Collection::stream).filter(re -> re.result != SchemaLoader.Result.ok).findAny().isPresent()) {
            return upgradeSupportResults.entrySet().stream().map(e -> new Pair((DataSourceInfo)e.getKey(), ((List)e.getValue()).stream().map(re -> {
                if (re.result == SchemaLoader.Result.ok && !"Checking connection to database".equals(re.name)) {
                    return new ResultEntry(re.name, SchemaLoader.Result.skipped, "Skipped due to other errors");
                }
                return re;
            }).collect(Collectors.toList()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        }
        return dataSourceSchemas.entrySet().stream().map(e -> new Pair<DataSourceInfo, List<ResultEntry>>((DataSourceInfo)e.getKey(), ((DataSourceInfo)e.getKey()).automaticSchemaManagement() ? this.loadSchemas((DataSource)e.getKey(), (List)e.getValue()) : ((List)e.getValue()).stream().map(schema -> new ResultEntry("Loading schema: " + schema.getName() + ", version: " + schema.getVersion().map(Version::toString).orElse("0.0.0"), SchemaLoader.Result.skipped, "Automatic schema management is disabled for this data source!")).collect(Collectors.toList()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public List<ResultEntry> checkUpgradeSupport(DataSource ds, List<SchemaInfo> schemas) {
        List validSchemas = schemas.stream().filter(SchemaInfo::isValid).collect(Collectors.toList());
        if (validSchemas.isEmpty()) {
            log.log(Level.FINER, "no known schemas for data source " + String.valueOf(ds) + ", skipping schema loading...");
            return Collections.emptyList();
        }
        return this.executeWithSchemaLoader(ds, (schemaLoader, handler) -> {
            if (schemaLoader.validateDBExists() == SchemaLoader.Result.ok) {
                return validSchemas.stream().map(schema -> {
                    Optional<Version> versionFromDB = schemaLoader.getComponentVersionFromDb(schema.getId());
                    Optional<Version> minimalSchemaVersionForUpgrade = schemaLoader.getMinimalRequiredComponentVersionForUpgrade((SchemaInfo)schema);
                    if (!versionFromDB.isPresent() || minimalSchemaVersionForUpgrade.map(version -> ((Version)versionFromDB.get()).compareTo(version) >= 0).orElse(false).booleanValue()) {
                        return new ResultEntry(schema.getName(), SchemaLoader.Result.ok, "Upgrade supported");
                    }
                    return new ResultEntry(schema.getName(), SchemaLoader.Result.error, minimalSchemaVersionForUpgrade.map(version -> "Upgrade supported only from version " + String.valueOf(version) + " or higher").orElse("Upgrade not supported!"));
                }).collect(Collectors.toList());
            }
            return validSchemas.stream().map(schema -> new ResultEntry(schema.getName(), SchemaLoader.Result.ok, "Database do not exist")).collect(Collectors.toList());
        });
    }

    public List<ResultEntry> loadSchemas(DataSource ds, List<SchemaInfo> schemas) {
        List validSchemas = schemas.stream().filter(SchemaInfo::isValid).collect(Collectors.toList());
        if (validSchemas.isEmpty()) {
            log.log(Level.FINER, "no known schemas for data source " + String.valueOf(ds) + ", skipping schema loading...");
            return Collections.emptyList();
        }
        return this.executeWithSchemaLoader(ds, (schemaLoader, handler) -> {
            ArrayList<ResultEntry> results = new ArrayList<ResultEntry>();
            results.add(new ResultEntry("Checking if database exists", schemaLoader.validateDBExists(), handler));
            log.log(Level.FINER, "loading schemas for data source " + String.valueOf(ds));
            schemas.sort(SCHEMA_INFO_COMPARATOR);
            results.add(new ResultEntry("Loading Common Schema Files", schemaLoader.loadCommonSchema(), handler));
            for (SchemaInfo schema2 : validSchemas) {
                ResultEntry schemaLoadResultEntry;
                Version version = schema2.getVersion().get();
                Optional<Version> componentVersionFromDb = schemaLoader.getComponentVersionFromDb(schema2.getId());
                String dbVersionMsg = " (database version: " + String.valueOf(componentVersionFromDb.isPresent() ? (Comparable)componentVersionFromDb.get() : "none") + ")";
                if (!Version.TYPE.FINAL.equals((Object)version.getVersionType()) || !componentVersionFromDb.isPresent() || version.getBaseVersion().equals((Object)componentVersionFromDb.get().getBaseVersion()) && !Version.TYPE.FINAL.equals((Object)componentVersionFromDb.get().getVersionType()) || !version.getBaseVersion().equals((Object)componentVersionFromDb.get().getBaseVersion())) {
                    log.log(Level.FINER, "loading schema with id ='" + String.valueOf(schema2) + "'");
                    schemaLoadResultEntry = new ResultEntry("Loading schema: " + schema2.getName() + ", version: " + String.valueOf(version) + dbVersionMsg, schemaLoader.loadSchema(schema2, version.toString()), handler);
                } else {
                    log.log(Level.FINER, "Skipped loading schema with id ='" + String.valueOf(schema2) + "'");
                    log.log(Level.INFO, "Required schema is already loaded in correct version");
                    schemaLoadResultEntry = new ResultEntry("Skipping schema: " + schema2.getName() + ", version: " + String.valueOf(version) + dbVersionMsg, SchemaLoader.Result.skipped, handler);
                }
                results.add(schemaLoadResultEntry);
            }
            schemas.stream().filter(schema -> "server".equals(schema.getId()) || "server-user".equals(schema.getId())).findAny().ifPresent(schemaInfo -> results.add(new ResultEntry("Adding XMPP admin accounts", schemaLoader.addXmppAdminAccount((SchemaInfo)schemaInfo), handler)));
            results.add(new ResultEntry("Post installation action", schemaLoader.postInstallation(), handler));
            return results;
        });
    }

    private List<CommandlineParameter> destroySchemaParametersSupplier() {
        ArrayList<CommandlineParameter> options = new ArrayList<CommandlineParameter>();
        options.addAll(Arrays.asList(this.ROOT_USERNAME, this.ROOT_PASSWORD, this.ROOT_ASK, this.TDSL_CONFIG_FILE, this.PROPERTY_CONFIG_FILE, this.LOG_LEVEL));
        options.addAll(SchemaLoader.getMainCommandlineParameters(true));
        return options;
    }

    private List<CommandlineParameter> installSchemaParametersSupplier() {
        ArrayList<CommandlineParameter> options = new ArrayList<CommandlineParameter>();
        options.add(this.COMPONENTS);
        options.add(this.LOG_LEVEL);
        options.addAll(SchemaLoader.getMainCommandlineParameters(false));
        return options;
    }

    private List<CommandlineParameter> upgradeSchemaParametersSupplier() {
        return Arrays.asList(this.ROOT_USERNAME, this.ROOT_PASSWORD, this.ROOT_ASK, this.TDSL_CONFIG_FILE, this.PROPERTY_CONFIG_FILE, this.LOG_LEVEL, this.FORCE_RELOAD_SCHEMA, this.ADMIN_JID, this.ADMIN_JID_PASS);
    }

    private boolean isErrorPresent(Map<DataSourceInfo, List<ResultEntry>> results) {
        return results.values().stream().flatMap(Collection::stream).map(entry -> entry.result).anyMatch(r -> r == SchemaLoader.Result.error);
    }

    private Map<DataSourceInfo, List<ResultEntry>> loadSchemas(Map<String, Object> config, Properties props) throws IOException, ConfigReader.ConfigException {
        Optional<String> rootUser = SchemaManager.getProperty(props, this.ROOT_USERNAME);
        Optional<String> rootPass = SchemaManager.getProperty(props, this.ROOT_PASSWORD);
        this.setConfig(config);
        if (rootUser.isPresent() && rootPass.isPresent()) {
            this.setDbRootCredentials(rootUser.get(), rootPass.get());
        }
        SchemaManager.getProperty(props, this.LOG_LEVEL, Level::parse).ifPresent(result -> {
            this.logLevel = result;
        });
        log.log(Level.INFO, "beginning loading schema files...");
        Map<DataSourceInfo, List<ResultEntry>> results = this.loadSchemas();
        log.log(Level.INFO, "schema loading finished!");
        return results;
    }

    private List<String> prepareOutput(String title, Map<DataSourceInfo, List<ResultEntry>> results, Optional<String[]> conversionMessages) {
        ArrayList<String> output = new ArrayList<String>(Arrays.asList("\t" + title));
        conversionMessages.ifPresent(msgs -> {
            output.add("");
            output.addAll(Arrays.asList(msgs));
        });
        results.forEach((k, v) -> {
            output.add("");
            output.add("Data source: " + k.getName() + " with uri " + JDBCPasswordObfuscator.obfuscatePassword(k.getResourceUri()));
            v.forEach(r -> {
                output.add("\t" + r.name + "\t" + String.valueOf((Object)r.result));
                if (r.result != SchemaLoader.Result.ok && r.message != null) {
                    String[] lines = r.message.split("\n");
                    for (int i = 0; i < lines.length; ++i) {
                        if (i == 0) {
                            output.add("\t\tMessage: " + lines[0]);
                            continue;
                        }
                        output.add("\t\t         " + lines[i]);
                    }
                }
            });
        });
        return output;
    }

    private List<ResultEntry> executeWithSchemaLoader(DataSource ds, SchemaLoaderExecutor function) {
        SchemaLoader schemaLoader = SchemaLoader.newInstanceForURI(ds.getResourceUri());
        ArrayList<ResultEntry> results = new ArrayList<ResultEntry>();
        Logger logger = Logger.getLogger(schemaLoader.getClass().getCanonicalName());
        SchemaManagerLogHandler handler = Arrays.stream(logger.getHandlers()).filter(h -> h instanceof SchemaManagerLogHandler).map(h -> (SchemaManagerLogHandler)h).findAny().orElseGet(() -> {
            SchemaManagerLogHandler handler1 = new SchemaManagerLogHandler();
            logger.addHandler(handler1);
            return handler1;
        });
        handler.setLevel(Level.FINEST);
        logger.setLevel(Level.FINEST);
        Object params = schemaLoader.createParameters();
        params.parseUri(ds.getResourceUri());
        params.setAdmins(this.admins, this.adminPass);
        params.setLogLevel(this.logLevel);
        params.setForceReloadSchema(this.forceReloadSchema);
        params.setDbRootAsk(this.dbRootAsk);
        schemaLoader.init(params, Optional.ofNullable(this.rootCredentialsCache));
        results.add(new ResultEntry("Checking connection to database", schemaLoader.validateDBConnection(), handler));
        results.addAll(function.execute(schemaLoader, handler));
        schemaLoader.shutdown();
        return results;
    }

    private static Map<String, DataSourceInfo> getDataSources(Map<String, Object> config) {
        Optional<Map> dataSources = Optional.ofNullable(config.get("dataSource")).map(obj -> (Map)obj);
        boolean automaticSchemaManagement = dataSources.map(map -> map.getOrDefault("automaticSchemaManagement", map.get("schema-management"))).map(Boolean.class::cast).orElseGet(() -> config.getOrDefault("automaticSchemaManagement", config.getOrDefault("schema-management", true)));
        return dataSources.isEmpty() ? Collections.emptyMap() : dataSources.get().values().stream().filter(v -> v instanceof AbstractBeanConfigurator.BeanDefinition).map(v -> (AbstractBeanConfigurator.BeanDefinition)v).filter(AbstractBeanConfigurator.BeanDefinition::isActive).map(v -> SchemaManager.createDataSourceInfo(v, automaticSchemaManagement)).collect(Collectors.toMap(DataSourceInfo::getName, Function.identity()));
    }

    private static DataSourceInfo createDataSourceInfo(AbstractBeanConfigurator.BeanDefinition def, boolean automaticSchemaManagement) {
        Object v = def.getOrDefault("uri", def.get("repo-uri"));
        DataSourceInfo info = new DataSourceInfo(def.getBeanName(), v instanceof ConfigReader.Variable ? ((ConfigReader.Variable)v).calculateValue().toString() : v.toString());
        boolean schemaManagement = def.getOrDefault("automaticSchemaManagement", def.getOrDefault("schema-management", automaticSchemaManagement));
        info.setAutomaticSchemaManagement(schemaManagement);
        return info;
    }

    public static List<RepoInfo> getRepositories(Kernel kernel, List<BeanConfig> repoBeans, Map<String, Object> config) {
        DSLBeanConfigurator configurator = kernel.getInstance(DSLBeanConfigurator.class);
        Map<String, DataSourceInfo> dataSources = SchemaManager.getDataSources(config);
        return dataSources.isEmpty() ? Collections.emptyList() : repoBeans.stream().filter(Objects::nonNull).flatMap(bc -> {
            try {
                if (SDRepositoryBean.class.isAssignableFrom(bc.getClazz())) {
                    String dataSourceName = SchemaManager.getDataSourceNameOr(configurator, bc, "default");
                    DataSourceInfo dataSource = (DataSourceInfo)dataSources.get(dataSourceName);
                    Class<?> implementation = SchemaManager.getRepositoryImplementation(configurator, dataSource, bc, null);
                    return Stream.of(new RepoInfo((BeanConfig)bc, dataSource, implementation));
                }
                MDRepositoryBean.SelectorType selectorType = Optional.ofNullable(configurator.getConfiguration((BeanConfig)bc)).map(tmpConfig -> tmpConfig.get("dataSourceSelection")).map(val -> {
                    if (val instanceof MDRepositoryBean.SelectorType) {
                        return (MDRepositoryBean.SelectorType)((Object)((Object)((Object)val)));
                    }
                    return MDRepositoryBean.SelectorType.valueOf(val.toString());
                }).orElseGet(() -> {
                    try {
                        Field f = MDRepositoryBean.class.getDeclaredField("dataSourceSelection");
                        f.setAccessible(true);
                        Object instance = bc.getClazz().newInstance();
                        return (MDRepositoryBean.SelectorType)((Object)((Object)((Object)f.get(instance))));
                    }
                    catch (Exception ex) {
                        return MDRepositoryBean.SelectorType.List;
                    }
                });
                switch (selectorType) {
                    case EveryDataSource: {
                        MDRepositoryBean mdRepositoryBean = (MDRepositoryBean)bc.getClazz().newInstance();
                        mdRepositoryBean.register(bc.getKernel());
                        return SchemaManager.getDataSources(config).entrySet().stream().map(e -> {
                            try {
                                DataSourceInfo dataSource = (DataSourceInfo)e.getValue();
                                mdRepositoryBean.registerIfNotExists((String)e.getKey());
                                BeanConfig bc2 = bc.getKernel().getDependencyManager().getBeanConfig((String)e.getKey());
                                Class<?> implementation = SchemaManager.getRepositoryImplementation(configurator, dataSource, bc2, bc);
                                return new RepoInfo(bc2, dataSource, implementation);
                            }
                            catch (Exception ex) {
                                log.log(Level.WARNING, "Error getting repository implementation", ex);
                                return null;
                            }
                        });
                    }
                    case EveryUserRepository: {
                        MDRepositoryBean mdRepositoryBean = (MDRepositoryBean)bc.getClazz().newInstance();
                        mdRepositoryBean.register(bc.getKernel());
                        return kernel.getDependencyManager().getBeanConfigs().stream().filter(bc1 -> UserRepositoryMDPoolBean.class.isAssignableFrom(bc1.getClazz())).map(BeanConfig::getKernel).flatMap(k1 -> k1.getDependencyManager().getBeanConfigs().stream()).filter(bc1 -> !Kernel.class.isAssignableFrom(bc1.getClazz())).filter(bc1 -> !Kernel.DelegatedBeanConfig.class.isAssignableFrom(bc1.getClass())).map(bc1 -> {
                            String dataSourceName = null;
                            try {
                                dataSourceName = SchemaManager.getDataSourceNameOr(configurator, bc1, bc1.getBeanName());
                                DataSourceInfo dataSource = (DataSourceInfo)dataSources.get(dataSourceName);
                                mdRepositoryBean.registerIfNotExists(bc1.getBeanName());
                                BeanConfig bc2 = bc.getKernel().getDependencyManager().getBeanConfig(bc1.getBeanName());
                                Class<?> implementation = SchemaManager.getRepositoryImplementation(configurator, dataSource, bc2, bc);
                                return new RepoInfo(bc2, dataSource, implementation);
                            }
                            catch (Exception ex) {
                                log.log(Level.WARNING, "Error getting repository implementation for: " + bc.getKernel().getParent().getName() + " bean and named repository: " + dataSourceName + ", available data sources:\n" + String.valueOf(dataSources.values()), ex);
                                return null;
                            }
                        });
                    }
                    case List: {
                        return bc.getKernel().getDependencyManager().getBeanConfigs().stream().filter(bc1 -> !Kernel.class.isAssignableFrom(bc1.getClazz())).filter(bc1 -> !Kernel.DelegatedBeanConfig.class.isAssignableFrom(bc1.getClass())).map(bc1 -> {
                            String dataSourceName = null;
                            try {
                                dataSourceName = SchemaManager.getDataSourceNameOr(configurator, bc1, bc1.getBeanName());
                                DataSourceInfo dataSource = (DataSourceInfo)dataSources.get(dataSourceName);
                                Class<?> implementation = SchemaManager.getRepositoryImplementation(configurator, dataSource, bc1, bc);
                                return new RepoInfo((BeanConfig)bc1, dataSource, implementation);
                            }
                            catch (Exception ex) {
                                log.log(Level.WARNING, "Error getting repository implementation for: " + bc.getKernel().getParent().getName() + " bean and named repository: " + dataSourceName + ", available data sources:\n" + String.valueOf(dataSources.values()), ex);
                                return null;
                            }
                        });
                    }
                }
                return Stream.empty();
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Error getting repository implementation", ex);
                return Stream.empty();
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Map<DataSourceInfo, List<SchemaInfo>> collectSchemasByDataSource(Map<DataSourceInfo, List<RepoInfo>> repositoriesByDataSource) {
        HashMap<DataSourceInfo, List<SchemaInfo>> dataSourceSchemas = new HashMap<DataSourceInfo, List<SchemaInfo>>();
        for (Map.Entry<DataSourceInfo, List<RepoInfo>> entry : repositoriesByDataSource.entrySet()) {
            List schemas = entry.getValue().stream().collect(Collectors.groupingBy(SchemaManager::getSchemaId, Collectors.toList())).entrySet().stream().map(e -> {
                Repository.SchemaId annotation = ((RepoInfo)((List)e.getValue()).iterator().next()).getImplementation().getAnnotation(Repository.SchemaId.class);
                return new SchemaInfo(annotation, (List)e.getValue());
            }).collect(Collectors.toList());
            dataSourceSchemas.put(entry.getKey(), schemas);
        }
        return dataSourceSchemas;
    }

    private static String getSchemaId(RepoInfo repoInfo) {
        Repository.SchemaId schemaId = repoInfo.getImplementation().getAnnotation(Repository.SchemaId.class);
        return schemaId == null ? "<unknown>" : schemaId.id();
    }

    private static String getDataSourceNameOr(DSLBeanConfigurator configurator, BeanConfig bc, String defValue) {
        Map<String, Object> cfg = configurator.getConfiguration(bc);
        return (String)cfg.getOrDefault("dataSourceName", cfg.getOrDefault("data-source", defValue));
    }

    private static Class<?> getRepositoryImplementation(DSLBeanConfigurator configurator, DataSourceInfo dataSource, BeanConfig beanConfig, BeanConfig mdRepoBeanConfig) throws ClassNotFoundException, DBInitException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Object mdRepoBean;
        if (dataSource == null) {
            throw new RuntimeException("No dataSource configured!");
        }
        Map<String, Object> cfg = configurator.getConfiguration(beanConfig);
        String cls = (String)cfg.getOrDefault("cls", cfg.get("repo-cls"));
        if (cls != null) {
            return ModulesManagerImpl.getInstance().forName(cls);
        }
        Object bean = beanConfig.getClazz().newInstance();
        if (bean instanceof MDPoolConfigBean) {
            Method m = MDPoolConfigBean.class.getDeclaredMethod("getRepositoryIfc", new Class[0]);
            m.setAccessible(true);
            return DataSourceHelper.getDefaultClass((Class)m.invoke(bean, new Object[0]), dataSource.getResourceUri());
        }
        if (bean instanceof SDRepositoryBean) {
            Method m = SDRepositoryBean.class.getDeclaredMethod("findClassForDataSource", DataSource.class);
            m.setAccessible(true);
            return (Class)m.invoke(bean, dataSource);
        }
        if (mdRepoBeanConfig != null && (mdRepoBean = mdRepoBeanConfig.getClazz().newInstance()) instanceof MDRepositoryBean) {
            Method m = MDRepositoryBean.class.getDeclaredMethod("findClassForDataSource", DataSource.class);
            m.setAccessible(true);
            return (Class)m.invoke(mdRepoBean, dataSource);
        }
        throw new RuntimeException("Unknown repository!");
    }

    public static Kernel prepareKernel(Map<String, Object> config) {
        Kernel kernel = new Kernel("root");
        try {
            if (XMPPServer.isOSGi()) {
                kernel.registerBean("classUtilBean").asInstance(Class.forName("tigase.osgi.util.ClassUtilBean").newInstance()).exportable().exec();
            } else {
                kernel.registerBean("classUtilBean").asInstance(Class.forName("tigase.util.reflection.ClassUtilBean").newInstance()).exportable().exec();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        kernel.registerBean(DefaultTypesConverter.class).exportable().exec();
        kernel.registerBean(DSLBeanConfiguratorWithBackwardCompatibility.class).exportable().exec();
        kernel.registerBean("eventBus").asInstance(EventBusFactory.getInstance()).exportable().exec();
        DSLBeanConfigurator configurator = kernel.getInstance(DSLBeanConfigurator.class);
        configurator.setProperties(config);
        ModulesManagerImpl.getInstance().setBeanConfigurator(configurator);
        kernel.registerBean("beanSelector").asInstance(new ServerBeanSelector()).exportable().exec();
        return kernel;
    }

    public static List<BeanConfig> getRepositoryBeans(Kernel kernel, List<Class<?>> repositoryClasses, Map<String, Object> config) {
        DSLBeanConfigurator configurator = kernel.getInstance(DSLBeanConfigurator.class);
        configurator.registerBeans(null, null, config);
        List<BeanConfig> repoBeans = SchemaManager.crawlKernel(repositoryClasses, kernel, configurator, config);
        SchemaManager.fixShutdownThreadIssue();
        return repoBeans;
    }

    private static void fixShutdownThreadIssue() {
        MonitorRuntime.getMonitorRuntime();
        try {
            Field f = MonitorRuntime.class.getDeclaredField("mainShutdownThread");
            f.setAccessible(true);
            MonitorRuntime monitorRuntime = MonitorRuntime.getMonitorRuntime();
            Runtime.getRuntime().removeShutdownHook((Thread)f.get(monitorRuntime));
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            log.log(Level.FINEST, "There was an error with unregistration of shutdown hook", ex);
        }
    }

    public static List<BeanConfig> crawlKernel(List<Class<?>> repositoryClasses, Kernel kernel, DSLBeanConfigurator configurator, Map<String, Object> config) {
        ArrayList<BeanConfig> results = new ArrayList<BeanConfig>();
        kernel.getDependencyManager().getBeanConfigs().stream().filter(bc -> bc.getState() == BeanConfig.State.registered).filter(bc -> !Kernel.DelegatedBeanConfig.class.isAssignableFrom(bc.getClass())).forEach(bc -> {
            try {
                Class<?> clazz = bc.getClazz();
                if ("tigase.muc.cluster.MUCComponentClustered".equals(clazz.getName())) {
                    clazz = ModulesManagerImpl.getInstance().forName("tigase.muc.MUCComponent");
                }
                if ("tigase.pubsub.cluster.PubSubComponentClustered".equals(clazz.getName())) {
                    clazz = ModulesManagerImpl.getInstance().forName("tigase.pubsub.PubSubComponent");
                }
                Object bean = clazz.newInstance();
                if (RegistrarBean.class.isAssignableFrom(clazz)) {
                    RegistrarKernel k = new RegistrarKernel();
                    k.setName(bc.getBeanName());
                    bc.getKernel().registerBean(bc.getBeanName() + "#KERNEL").asInstance(k).exec();
                    Method m = bc.getClass().getDeclaredMethod("setKernel", Kernel.class);
                    m.setAccessible(true);
                    m.invoke(bc, k);
                    Kernel parent = bc.getKernel().getParent();
                    parent.ln(bc.getBeanName(), bc.getKernel(), "service");
                    ((RegistrarBean)bean).register(bc.getKernel());
                    Map cfg = config.getOrDefault(bc.getBeanName(), new HashMap());
                    configurator.registerBeans((BeanConfig)bc, bean, cfg);
                    results.addAll(SchemaManager.crawlKernel(repositoryClasses, bc.getKernel(), configurator, cfg));
                }
                if (repositoryClasses.stream().anyMatch(repoClazz -> repoClazz.isAssignableFrom(bc.getClazz()))) {
                    results.add((BeanConfig)bc);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                log.log(Level.SEVERE, "Exception while crawling kernel", ex);
            }
            catch (StackOverflowError ex) {
                ex.printStackTrace();
                Kernel k = bc.getKernel();
                ArrayList<String> list = new ArrayList<String>();
                do {
                    list.add(k.getName());
                } while ((k = k.getParent()) != null);
                log.log(Level.SEVERE, "exception in path " + String.valueOf(list));
            }
        });
        return results;
    }

    private static <T> T getInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.log(Level.WARNING, "Error creating instance of: " + clazz.getName(), e);
            return null;
        }
    }

    public static class RootCredentialsCache {
        private final Map<String, RootCredentials> cache = new ConcurrentHashMap<String, RootCredentials>();

        public RootCredentials get(String server) {
            return this.cache.getOrDefault(this.createKey(server), this.cache.get("default"));
        }

        public void set(String server, RootCredentials credentials) {
            this.cache.put(this.createKey(server), credentials);
        }

        private String createKey(String server) {
            if (server == null) {
                return "default";
            }
            return server;
        }
    }

    public static class RootCredentials {
        public final String password;
        public final String user;

        public RootCredentials(String user, String password) {
            this.user = user;
            this.password = password;
        }
    }

    @FunctionalInterface
    public static interface SchemaLoaderExecutor {
        public List<ResultEntry> execute(SchemaLoader var1, SchemaManagerLogHandler var2);
    }

    public static class ResultEntry {
        public final String message;
        public final String name;
        public final SchemaLoader.Result result;

        private ResultEntry(String name, SchemaLoader.Result result, SchemaManagerLogHandler logHandler) {
            this.name = name;
            this.result = result;
            this.message = logHandler.getMessage().orElse(null);
        }

        private ResultEntry(String name, SchemaLoader.Result result, String message) {
            this.name = name;
            this.result = result;
            this.message = message;
        }
    }

    public static class DataSourceInfo
    implements DataSource {
        private final String name;
        private final String uri;
        private boolean automaticSchemaManagement = true;

        private DataSourceInfo(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Optional<Version> getSchemaVersion(String component) {
            return Optional.empty();
        }

        @Override
        public String getResourceUri() {
            return this.uri;
        }

        @Override
        public void initialize(String connStr) throws RepositoryException {
        }

        @Override
        @Deprecated
        public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        }

        @Override
        public boolean automaticSchemaManagement() {
            return this.automaticSchemaManagement;
        }

        protected void setAutomaticSchemaManagement(boolean value) {
            this.automaticSchemaManagement = value;
        }

        public String toString() {
            return this.name + "[uri=" + this.uri + "]";
        }
    }

    public static class RepoInfo {
        private final BeanConfig beanConfig;
        private final DataSourceInfo dataSource;
        private final Class<?> implementation;

        public RepoInfo(BeanConfig beanConfig, DataSourceInfo dataSource, Class<?> implementation) {
            this.beanConfig = beanConfig;
            this.dataSource = dataSource;
            this.implementation = implementation;
        }

        public DataSourceInfo getDataSource() {
            return this.dataSource;
        }

        public Class<?> getImplementation() {
            return this.implementation;
        }

        public String toString() {
            return this.beanConfig.getBeanName() + "[dataSource=" + this.dataSource.getName() + ", class=" + String.valueOf(this.implementation) + "]";
        }
    }

    public static class SchemaInfo {
        private final List<RepoInfo> repositories;
        private final Optional<String> id;
        private final Optional<String> name;
        private final boolean external;

        public SchemaInfo(Repository.SchemaId schema, List<RepoInfo> repositories) {
            this(schema == null ? null : schema.id(), schema == null ? null : schema.name(), schema == null || schema.external(), repositories);
        }

        public SchemaInfo(String id, String name, boolean external, List<RepoInfo> repositories) {
            this.id = Optional.ofNullable(id);
            this.name = Optional.ofNullable(name);
            this.external = external;
            this.repositories = repositories;
        }

        public String getId() {
            return this.id.orElse("<unknown>");
        }

        public String getName() {
            return this.name.orElse("");
        }

        public List<RepoInfo> getRepositories() {
            return this.repositories;
        }

        public Optional<Version> getVersion() {
            Map versions = this.repositories.stream().map(RepoInfo::getImplementation).filter(RepositoryVersionAware.class::isAssignableFrom).map(SchemaManager::getInstance).map(RepositoryVersionAware.class::cast).filter(Objects::nonNull).map(RepositoryVersionAware::getVersion).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity()));
            if (versions.size() == 1) {
                return Optional.of((Version)versions.keySet().iterator().next());
            }
            return Optional.empty();
        }

        public boolean isExternal() {
            return this.external;
        }

        public boolean isValid() {
            return this.id.isPresent() && this.getVersion().isPresent();
        }

        public String toString() {
            return "SchemaInfo[id=" + this.getId() + ", repositories=" + String.valueOf(this.repositories) + "]";
        }
    }

    public static class Pair<K, V> {
        private final K key;
        private final V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

