/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import tigase.db.util.SchemaLoader;
import tigase.util.Version;

public interface RepositoryVersionAware {
    default public Version getVersion() {
        if (this.getClass().isAnnotationPresent(SchemaVersion.class)) {
            SchemaVersion sv = this.getClass().getAnnotation(SchemaVersion.class);
            return Version.of((String)sv.version());
        }
        String impl = this.getClass().getPackage().getImplementationVersion();
        if (impl != null && !impl.isEmpty()) {
            return Version.of((String)impl);
        }
        return Version.ZERO;
    }

    default public SchemaLoader.Result updateSchema(Optional<Version> oldVersion, Version newVersion) throws Exception {
        return SchemaLoader.Result.skipped;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SchemaVersion {
        public String version() default "0.0.0-b0";
    }
}

