/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util;

import tigase.db.DataRepository;
import tigase.db.jdbc.DataRepositoryImpl;

public class JDBCPasswordObfuscator {
    private static String getObfuscatedUrl(String url, char separatorCharacter) {
        String passwordParameter = "password=";
        int passwordIndex = ((String)url).lastIndexOf(passwordParameter);
        String urlReminder = ((String)url).substring(passwordIndex + passwordParameter.length());
        int nextSectionIndex = urlReminder.indexOf(separatorCharacter);
        int passwordLength = nextSectionIndex > 0 ? nextSectionIndex : urlReminder.length();
        url = ((String)url).substring(0, passwordIndex + passwordParameter.length()) + "*".repeat(passwordLength) + urlReminder.substring(passwordLength);
        return url;
    }

    public static String obfuscatePassword(String url) {
        DataRepository.dbTypes dbType = DataRepositoryImpl.parseDatabaseType(url);
        switch (dbType) {
            case postgresql: 
            case mysql: {
                url = JDBCPasswordObfuscator.getObfuscatedUrl(url, '&');
                break;
            }
            case jtds: 
            case sqlserver: {
                url = JDBCPasswordObfuscator.getObfuscatedUrl(url, ';');
            }
        }
        return url;
    }
}

