/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.jdbc;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.auth.mechanisms.AbstractSaslSCRAM;
import tigase.db.AuthorizationException;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.jdbc.TigaseCustomAuth;
import tigase.db.util.RepositoryVersionAware;
import tigase.util.Base64;
import tigase.xmpp.jid.BareJID;

@Repository.SchemaId(id="server", name="Tigase XMPP Server (Core)")
public class TigaseSPAuth
extends TigaseCustomAuth
implements RepositoryVersionAware {
    private static final Logger log = Logger.getLogger(TigaseSPAuth.class.getName());
    private static final SecureRandom random = new SecureRandom();

    private static final String encode(String pwd) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] salt = new byte[20];
        random.nextBytes(salt);
        return TigaseSPAuth.encode(pwd, salt);
    }

    private static final String encode(String pwd, byte[] salt) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] saltedPassword = AbstractSaslSCRAM.hi("SHA1", AbstractSaslSCRAM.normalize(pwd), salt, 4096);
        byte[] result = new byte[salt.length + saltedPassword.length];
        System.arraycopy(salt, 0, result, 0, salt.length);
        System.arraycopy(saltedPassword, 0, result, salt.length, saltedPassword.length);
        return Base64.encode((byte[])result);
    }

    @Override
    public void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        try {
            super.addUser(user, TigaseSPAuth.encode(password));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can't add user " + String.valueOf(user), e);
        }
    }

    @Override
    public boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        String password = (String)props.get("password");
        BareJID user_id = (BareJID)props.get("user-id");
        try {
            props.put("password", this.encodeWithUserSalt(user_id, password));
            return super.otherAuth(props);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can't salt user password", e);
            throw new AuthorizationException("Can't salt user password", e);
        }
    }

    @Override
    public void updatePassword(BareJID user, String password) throws UserNotFoundException, TigaseDBException {
        try {
            super.updatePassword(user, TigaseSPAuth.encode(password));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can't update password for user " + String.valueOf(user), e);
        }
    }

    private String encodeWithUserSalt(BareJID user, String password) throws UserNotFoundException, TigaseDBException, InvalidKeyException, NoSuchAlgorithmException {
        String pwd = this.getPassword(user);
        if (pwd == null) {
            throw new UserNotFoundException("User " + String.valueOf(user) + " not found.");
        }
        byte[] buffer = Base64.decode((String)pwd);
        byte[] salt = new byte[20];
        System.arraycopy(buffer, 0, salt, 0, salt.length);
        return TigaseSPAuth.encode(password, salt);
    }

    private boolean isPasswordValid(BareJID user, String password) throws UserNotFoundException, TigaseDBException, InvalidKeyException, NoSuchAlgorithmException {
        String pwd = this.getPassword(user);
        if (pwd == null) {
            throw new UserNotFoundException("User " + String.valueOf(user) + " not found.");
        }
        byte[] buffer = Base64.decode((String)pwd);
        byte[] salt = new byte[20];
        byte[] saltedPassword = new byte[20];
        System.arraycopy(buffer, 0, salt, 0, salt.length);
        System.arraycopy(buffer, salt.length, saltedPassword, 0, saltedPassword.length);
        byte[] np = AbstractSaslSCRAM.hi("SHA1", AbstractSaslSCRAM.normalize(password), salt, 4096);
        return Arrays.equals(saltedPassword, np);
    }
}

