/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DataOverwriteException;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.core.Kernel;
import tigase.xmpp.jid.BareJID;

@Bean(name="nonAuthUserRepository", parent=Kernel.class, active=true, exportable=true)
public class NonAuthUserRepositoryImpl
implements NonAuthUserRepository {
    private static final Logger log = Logger.getLogger(NonAuthUserRepositoryImpl.class.getName());
    private final Set<BareJID> existing_domains = new ConcurrentSkipListSet<BareJID>();
    @ConfigField(alias="offline-user-autocreate", desc="Autocreate offline users")
    private boolean autoCreateOffline = false;
    private BareJID defDomain = null;
    @Inject
    private UserRepository rep;

    public NonAuthUserRepositoryImpl(UserRepository userRep, BareJID defDomain, boolean autoCreateOffline) {
        this.rep = userRep;
        this.defDomain = defDomain;
        this.autoCreateOffline = autoCreateOffline;
    }

    public NonAuthUserRepositoryImpl() {
    }

    @Override
    public void addOfflineData(BareJID user, String subnode, String key, String value) throws UserNotFoundException, DataOverwriteException {
        String node = this.calcNode("offline", subnode);
        try {
            String data = this.rep.getData(user, node, key);
            if (data != null) {
                throw new DataOverwriteException("Not authorized attempt to overwrite data.");
            }
            this.rep.setData(user, node, key, value);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Problem accessing repository data.", e);
        }
    }

    @Override
    public void addOfflineDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException {
        try {
            if (!this.autoCreateOffline && !this.rep.userExists(user)) {
                throw new UserNotFoundException("User: " + String.valueOf(user) + " has not been found inthe repository.");
            }
            this.rep.addDataList(user, this.calcNode("offline", subnode), key, list);
        }
        catch (UserNotFoundException e) {
            log.log(Level.CONFIG, "User not found in repository: {0}", user);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Problem accessing repository data.", e);
        }
    }

    @Override
    public String getDomainTempData(BareJID domain, String subnode, String key, String def) throws TigaseDBException {
        this.checkDomain(domain);
        return this.rep.getData(domain, subnode, key, def);
    }

    @Override
    public String getPublicData(BareJID user, String subnode, String key, String def) throws UserNotFoundException {
        try {
            return this.rep.userExists(user) ? this.rep.getData(user, this.calcNode("public", subnode), key, def) : null;
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Problem accessing repository data.", e);
            return null;
        }
    }

    @Override
    public String[] getPublicDataList(BareJID user, String subnode, String key) throws UserNotFoundException {
        try {
            return this.rep.userExists(user) ? this.rep.getDataList(user, this.calcNode("public", subnode), key) : null;
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Problem accessing repository data.", e);
            return null;
        }
    }

    @Override
    public String getTempData(String subnode, String key, String def) throws TigaseDBException {
        this.checkDomain(this.defDomain);
        return this.rep.getData(this.defDomain, subnode, key, def);
    }

    @Override
    public void putDomainTempData(BareJID domain, String subnode, String key, String value) throws TigaseDBException {
        this.checkDomain(domain);
        this.rep.setData(domain, subnode, key, value);
    }

    @Override
    public void putTempData(String subnode, String key, String value) throws TigaseDBException {
        this.checkDomain(this.defDomain);
        this.rep.setData(this.defDomain, subnode, key, value);
    }

    @Override
    public void removeDomainTempData(BareJID domain, String subnode, String key) throws TigaseDBException {
        this.checkDomain(this.defDomain);
        this.rep.removeData(domain, subnode, key);
    }

    @Override
    public void removeTempData(String subnode, String key) throws TigaseDBException {
        this.checkDomain(this.defDomain);
        this.rep.removeData(this.defDomain, subnode, key);
    }

    private String calcNode(String base, String subnode) {
        if (subnode == null) {
            return base;
        }
        return base + "/" + subnode;
    }

    private void checkDomain(BareJID domain) throws TigaseDBException {
        if (!this.existing_domains.contains(domain) && !this.rep.userExists(domain)) {
            this.rep.addUser(domain);
            this.existing_domains.add(domain);
        }
    }
}

